/****************************************************************************
**
** Copyright (C) 2014 Digia Plc and/or its subsidiary(-ies).
** Contact: http://www.qt-project.org/legal
**
** This file is part of the Qt Build Suite.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Digia.  For licensing terms and
** conditions see http://qt.digia.com/licensing.  For further information
** use the contact form at http://qt.digia.com/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Digia gives you certain additional
** rights.  These rights are described in the Digia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
****************************************************************************/

#include <string>
#include <iostream>
#include <fstream>

using namespace std;

bool displayTextFile(const string &dirPath, const string &fileName)
{
    string fullPath = dirPath + fileName;
    ifstream istream(fullPath.c_str());
    if (!istream.is_open()) {
        cout << "Cannot open " << fileName << endl;
        return false;
    }
    cout << "---" << fileName << "---" << endl;
    char buf[256];
    unsigned int i = 1;
    while (istream.good()) {
        istream.getline(buf, sizeof(buf));
        cout << i++ << ": " << buf << endl;
    }
    return true;
}

int main(int, char **argv)
{
    string appPath(argv[0]);
    size_t i = appPath.find_last_of('/');
    if (i == string::npos)
        i = appPath.find_last_of('\\');
    if (i == string::npos) // No path, plain executable was called
        appPath.clear();
    else
        appPath.resize(i + 1);
    if (!displayTextFile(appPath, "foo.txt"))
        return 1;
    if (!displayTextFile(appPath, "bar.txt"))
        return 2;
    cout << "-------------" << endl;
    return 0;
}

