// Copyright (C) 2020 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

#include "enclosingclassmixin.h"
#include "abstractmetalang.h"
#include "namespacetypeentry.h"

AbstractMetaClassCPtr EnclosingClassMixin::targetLangEnclosingClass() const
{
    auto result = m_enclosingClass.lock();
    while (result && !NamespaceTypeEntry::isVisibleScope(result->typeEntry()))
        result = result->enclosingClass();
    return result;
}
