/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputListener;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Theme;

public class EditorToolbar
extends JComponent
implements MouseInputListener {
    static final String[] title = new String[]{"Verify", "Stop", "New", "Open", "Save", "Upload", "Serial Monitor"};
    static final int BUTTON_COUNT = title.length;
    static final int BUTTON_WIDTH = 27;
    static final int BUTTON_HEIGHT = 32;
    static final int BUTTON_GAP = 5;
    static final int RUN = 0;
    static final int STOP = 1;
    static final int NEW = 2;
    static final int OPEN = 3;
    static final int SAVE = 4;
    static final int EXPORT = 5;
    static final int SERIAL = 6;
    static final int INACTIVE = 0;
    static final int ROLLOVER = 1;
    static final int ACTIVE = 2;
    Editor editor;
    Image offscreen;
    int width;
    int height;
    Color bgcolor;
    static Image buttons;
    static Image[] inactive;
    static Image[] rollover;
    static Image[] active;
    int currentRollover;
    JPopupMenu popup;
    JMenu menu;
    int buttonCount;
    int[] state = new int[BUTTON_COUNT];
    Image[] stateImage;
    int[] which;
    int[] x1;
    int[] x2;
    int y1;
    int y2;
    String status;
    Font statusFont;
    Color statusColor;
    int wasDown = -1;

    public EditorToolbar(Editor editor, JMenu jMenu) {
        this.editor = editor;
        this.menu = jMenu;
        if (buttons == null) {
            buttons = Base.getThemeImage("buttons.gif", this);
        }
        this.buttonCount = 0;
        this.which = new int[BUTTON_COUNT];
        this.which[this.buttonCount++] = 0;
        this.which[this.buttonCount++] = 1;
        this.which[this.buttonCount++] = 2;
        this.which[this.buttonCount++] = 3;
        this.which[this.buttonCount++] = 4;
        this.which[this.buttonCount++] = 5;
        this.which[this.buttonCount++] = 6;
        this.currentRollover = -1;
        this.bgcolor = Theme.getColor("buttons.bgcolor");
        this.status = "";
        this.statusFont = Theme.getFont("buttons.status.font");
        this.statusColor = Theme.getColor("buttons.status.color");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (inactive == null) {
            inactive = new Image[BUTTON_COUNT];
            rollover = new Image[BUTTON_COUNT];
            active = new Image[BUTTON_COUNT];
            n3 = 33;
            for (n2 = 0; n2 < BUTTON_COUNT; ++n2) {
                EditorToolbar.inactive[n2] = this.createImage(27, 32);
                Graphics graphics2 = inactive[n2].getGraphics();
                graphics2.drawImage(buttons, -(n2 * n3) - 3, -2 * n3, null);
                EditorToolbar.rollover[n2] = this.createImage(27, 32);
                graphics2 = rollover[n2].getGraphics();
                graphics2.drawImage(buttons, -(n2 * n3) - 3, -1 * n3, null);
                EditorToolbar.active[n2] = this.createImage(27, 32);
                graphics2 = active[n2].getGraphics();
                graphics2.drawImage(buttons, -(n2 * n3) - 3, 0 * n3, null);
            }
        }
        if (this.stateImage == null) {
            this.state = new int[this.buttonCount];
            this.stateImage = new Image[this.buttonCount];
            for (n3 = 0; n3 < this.buttonCount; ++n3) {
                this.setState(n3, 0, false);
            }
            this.y1 = 0;
            this.y2 = 32;
            this.x1 = new int[this.buttonCount];
            this.x2 = new int[this.buttonCount];
        }
        Dimension dimension = this.getSize();
        if (this.offscreen == null || dimension.width != this.width || dimension.height != this.height) {
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.width = dimension.width;
            this.height = dimension.height;
            n2 = 3;
            for (int i = 0; i < this.buttonCount; ++i) {
                this.x1[i] = n2;
                if (i == 2 || i == 6) {
                    int n4 = i;
                    this.x1[n4] = this.x1[n4] + 5;
                }
                this.x2[i] = this.x1[i] + 27;
                n2 = this.x2[i];
            }
        }
        Graphics graphics3 = this.offscreen.getGraphics();
        graphics3.setColor(this.bgcolor);
        graphics3.fillRect(0, 0, this.width, this.height);
        for (n = 0; n < this.buttonCount; ++n) {
            graphics3.drawImage(this.stateImage[n], this.x1[n], this.y1, null);
        }
        graphics3.setColor(this.statusColor);
        graphics3.setFont(this.statusFont);
        n = (32 + graphics3.getFontMetrics().getAscent()) / 2;
        graphics3.drawString(this.status, this.buttonCount * 27 + 15, n);
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.state == null) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, false);
        }
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void handleMouse(int n, int n2) {
        int n3;
        if (this.currentRollover != -1) {
            if (n > this.x1[this.currentRollover] && n2 > this.y1 && n < this.x2[this.currentRollover] && n2 < this.y2) {
                return;
            }
            this.setState(this.currentRollover, 0, true);
            this.messageClear(title[this.currentRollover]);
            this.currentRollover = -1;
        }
        if ((n3 = this.findSelection(n, n2)) == -1) {
            return;
        }
        if (this.state[n3] != 2) {
            this.setState(n3, 1, true);
            this.currentRollover = n3;
        }
    }

    private int findSelection(int n, int n2) {
        if (this.x1 == null || this.x2 == null) {
            return -1;
        }
        for (int i = 0; i < this.buttonCount; ++i) {
            if (n2 <= this.y1 || n <= this.x1[i] || n2 >= this.y2 || n >= this.x2[i]) continue;
            return i;
        }
        return -1;
    }

    private void setState(int n, int n2, boolean bl) {
        this.state[n] = n2;
        switch (n2) {
            case 0: {
                this.stateImage[n] = inactive[this.which[n]];
                break;
            }
            case 2: {
                this.stateImage[n] = active[this.which[n]];
                break;
            }
            case 1: {
                this.stateImage[n] = rollover[this.which[n]];
                this.message(title[this.which[n]]);
            }
        }
        if (bl) {
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this.popup != null && this.popup.isVisible()) {
            return;
        }
        if (this.state[3] != 0) {
            this.setState(3, 0, true);
        }
        this.status = "";
        this.handleMouse(mouseEvent.getX(), mouseEvent.getY());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        int n3 = this.findSelection(n2, n = mouseEvent.getY());
        if (n3 == -1) {
            return;
        }
        this.currentRollover = -1;
        switch (n3) {
            case 0: {
                this.editor.handleRun(mouseEvent.isShiftDown());
                break;
            }
            case 1: {
                this.editor.handleStop();
                break;
            }
            case 3: {
                this.popup = this.menu.getPopupMenu();
                this.popup.show(this, n2, n);
                break;
            }
            case 2: {
                this.editor.base.handleNewReplace();
                break;
            }
            case 4: {
                this.editor.handleSave(false);
                break;
            }
            case 5: {
                this.editor.handleExport(mouseEvent.isShiftDown());
                break;
            }
            case 6: {
                this.editor.handleSerial();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void activate(int n) {
        if (inactive == null) {
            return;
        }
        this.setState(n, 2, true);
    }

    public void deactivate(int n) {
        if (inactive == null) {
            return;
        }
        this.setState(n, 0, true);
    }

    public void message(String string) {
        this.status = string;
    }

    public void messageClear(String string) {
        if (this.status.equals(string)) {
            this.status = "";
        }
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension((BUTTON_COUNT + 1) * 27, 32);
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, 32);
    }
}

