#ifndef HardwareRadio_h
#define HardwareRadio_h
#include <string.h>
#include "radio.h"


typedef struct 
{
    uint8_t len;
    uint8_t frm[127];
} rx_frame_t;

extern rx_frame_t rxbuf;

/* This static inline functions add no code overhead, 
 * they are just transform the uracoli 
 * functions have a arduino look.
 */
static inline void radioInit(void)
{
    radio_init(rxbuf.frm, sizeof(rxbuf.frm));
}

static inline void radioSetChannel(uint8_t chan)
{
    radio_set_param(RP_CHANNEL(chan));
}


static inline void radioSetIdleState(uint8_t chan)
{
    radio_set_param(RP_IDLESTATE(state));
}


static inline void radioTransmit(uint8_t len, uint8_t* buf)
{
  radio_set_state(STATE_TXAUTO);
  radio_send_frame(len, buf, 0);
}

static inline void radioState(radio_state_t st)
{ 
  radio_set_state(st);
} 

static inline void radioForceState(radio_state_t   st)
{ 
  radio_force_state(st);
} 

#define transmitDoneCallback usr_radio_tx_done
#define txdone_t radio_tx_done_t


/**

@code
uint8_t* receiveFrameCallback( uint8_t len, uint8_t * frm, 
          uint8_t lqi, uint8_t rssi, uint8_t crc_fail)
{

}
@endcode
*/
#define receiveFrameCallback  usr_radio_receive_frame

#endif
