/*****************************************************************************
 *
 * Copyright (C) 2009 Atmel Corporation
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in
 *   the documentation and/or other materials provided with the
 *   distribution.
 *
 * * Neither the name of the copyright holders nor the names of
 *   contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Model        : UC3000
 * Revision     : $Revision: 65140 $
 * Checkin Date : $Date: 2009-11-30 23:21:11 -0700 (Mon, 30 Nov 2009) $ 
 *
 ****************************************************************************/
#ifndef AVR32_INTC_H_INCLUDED
#define AVR32_INTC_H_INCLUDED

#include "avr32/abi.h"

#define AVR32_INTC_ICR0                                     0x0000020c
#define AVR32_INTC_ICR0_CAUSEGRP                                     0
#define AVR32_INTC_ICR0_CAUSEGRP_MASK                       0x0000003f
#define AVR32_INTC_ICR0_CAUSEGRP_OFFSET                              0
#define AVR32_INTC_ICR0_CAUSEGRP_SIZE                                6
#define AVR32_INTC_ICR0_MASK                                0x0000003f
#define AVR32_INTC_ICR0_RESETVALUE                          0x00000000
#define AVR32_INTC_ICR1                                     0x00000208
#define AVR32_INTC_ICR1_CAUSEGRP                                     0
#define AVR32_INTC_ICR1_CAUSEGRP_MASK                       0x0000003f
#define AVR32_INTC_ICR1_CAUSEGRP_OFFSET                              0
#define AVR32_INTC_ICR1_CAUSEGRP_SIZE                                6
#define AVR32_INTC_ICR1_MASK                                0x0000003f
#define AVR32_INTC_ICR1_RESETVALUE                          0x00000000
#define AVR32_INTC_ICR2                                     0x00000204
#define AVR32_INTC_ICR2_CAUSEGRP                                     0
#define AVR32_INTC_ICR2_CAUSEGRP_MASK                       0x0000003f
#define AVR32_INTC_ICR2_CAUSEGRP_OFFSET                              0
#define AVR32_INTC_ICR2_CAUSEGRP_SIZE                                6
#define AVR32_INTC_ICR2_MASK                                0x0000003f
#define AVR32_INTC_ICR2_RESETVALUE                          0x00000000
#define AVR32_INTC_ICR3                                     0x00000200
#define AVR32_INTC_ICR3_CAUSEGRP                                     0
#define AVR32_INTC_ICR3_CAUSEGRP_MASK                       0x0000003f
#define AVR32_INTC_ICR3_CAUSEGRP_OFFSET                              0
#define AVR32_INTC_ICR3_CAUSEGRP_SIZE                                6
#define AVR32_INTC_ICR3_MASK                                0x0000003f
#define AVR32_INTC_ICR3_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR                                      0x00000000
#define AVR32_INTC_IPR_AUTOVECTOR                                    0
#define AVR32_INTC_IPR_AUTOVECTOR_MASK                      0x00003fff
#define AVR32_INTC_IPR_AUTOVECTOR_OFFSET                             0
#define AVR32_INTC_IPR_AUTOVECTOR_SIZE                              14
#define AVR32_INTC_IPR0                                     0x00000000
#define AVR32_INTC_IPR0_INTLEV                                      30
#define AVR32_INTC_IPR0_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR0_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR0_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR0_MASK                                0xc0003fff
#define AVR32_INTC_IPR0_OFFSET                                       0
#define AVR32_INTC_IPR0_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR0_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR0_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR0_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR1                                     0x00000004
#define AVR32_INTC_IPR10                                    0x00000028
#define AVR32_INTC_IPR10_INTLEV                                     30
#define AVR32_INTC_IPR10_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR10_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR10_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR10_MASK                               0xc0003fff
#define AVR32_INTC_IPR10_OFFSET                                      0
#define AVR32_INTC_IPR10_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR10_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR10_OFFSET_SIZE                                14
#define AVR32_INTC_IPR10_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR11                                    0x0000002c
#define AVR32_INTC_IPR11_INTLEV                                     30
#define AVR32_INTC_IPR11_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR11_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR11_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR11_MASK                               0xc0003fff
#define AVR32_INTC_IPR11_OFFSET                                      0
#define AVR32_INTC_IPR11_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR11_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR11_OFFSET_SIZE                                14
#define AVR32_INTC_IPR11_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR12                                    0x00000030
#define AVR32_INTC_IPR12_INTLEV                                     30
#define AVR32_INTC_IPR12_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR12_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR12_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR12_MASK                               0xc0003fff
#define AVR32_INTC_IPR12_OFFSET                                      0
#define AVR32_INTC_IPR12_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR12_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR12_OFFSET_SIZE                                14
#define AVR32_INTC_IPR12_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR13                                    0x00000034
#define AVR32_INTC_IPR13_INTLEV                                     30
#define AVR32_INTC_IPR13_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR13_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR13_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR13_MASK                               0xc0003fff
#define AVR32_INTC_IPR13_OFFSET                                      0
#define AVR32_INTC_IPR13_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR13_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR13_OFFSET_SIZE                                14
#define AVR32_INTC_IPR13_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR14                                    0x00000038
#define AVR32_INTC_IPR14_INTLEV                                     30
#define AVR32_INTC_IPR14_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR14_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR14_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR14_MASK                               0xc0003fff
#define AVR32_INTC_IPR14_OFFSET                                      0
#define AVR32_INTC_IPR14_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR14_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR14_OFFSET_SIZE                                14
#define AVR32_INTC_IPR14_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR15                                    0x0000003c
#define AVR32_INTC_IPR15_INTLEV                                     30
#define AVR32_INTC_IPR15_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR15_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR15_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR15_MASK                               0xc0003fff
#define AVR32_INTC_IPR15_OFFSET                                      0
#define AVR32_INTC_IPR15_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR15_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR15_OFFSET_SIZE                                14
#define AVR32_INTC_IPR15_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR16                                    0x00000040
#define AVR32_INTC_IPR16_INTLEV                                     30
#define AVR32_INTC_IPR16_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR16_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR16_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR16_MASK                               0xc0003fff
#define AVR32_INTC_IPR16_OFFSET                                      0
#define AVR32_INTC_IPR16_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR16_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR16_OFFSET_SIZE                                14
#define AVR32_INTC_IPR16_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR17                                    0x00000044
#define AVR32_INTC_IPR17_INTLEV                                     30
#define AVR32_INTC_IPR17_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR17_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR17_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR17_MASK                               0xc0003fff
#define AVR32_INTC_IPR17_OFFSET                                      0
#define AVR32_INTC_IPR17_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR17_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR17_OFFSET_SIZE                                14
#define AVR32_INTC_IPR17_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR18                                    0x00000048
#define AVR32_INTC_IPR18_INTLEV                                     30
#define AVR32_INTC_IPR18_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR18_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR18_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR18_MASK                               0xc0003fff
#define AVR32_INTC_IPR18_OFFSET                                      0
#define AVR32_INTC_IPR18_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR18_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR18_OFFSET_SIZE                                14
#define AVR32_INTC_IPR18_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR19                                    0x0000004c
#define AVR32_INTC_IPR19_INTLEV                                     30
#define AVR32_INTC_IPR19_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR19_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR19_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR19_MASK                               0xc0003fff
#define AVR32_INTC_IPR19_OFFSET                                      0
#define AVR32_INTC_IPR19_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR19_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR19_OFFSET_SIZE                                14
#define AVR32_INTC_IPR19_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR1_INTLEV                                      30
#define AVR32_INTC_IPR1_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR1_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR1_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR1_MASK                                0xc0003fff
#define AVR32_INTC_IPR1_OFFSET                                       0
#define AVR32_INTC_IPR1_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR1_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR1_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR1_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR2                                     0x00000008
#define AVR32_INTC_IPR20                                    0x00000050
#define AVR32_INTC_IPR20_INTLEV                                     30
#define AVR32_INTC_IPR20_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR20_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR20_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR20_MASK                               0xc0003fff
#define AVR32_INTC_IPR20_OFFSET                                      0
#define AVR32_INTC_IPR20_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR20_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR20_OFFSET_SIZE                                14
#define AVR32_INTC_IPR20_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR21                                    0x00000054
#define AVR32_INTC_IPR21_INTLEV                                     30
#define AVR32_INTC_IPR21_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR21_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR21_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR21_MASK                               0xc0003fff
#define AVR32_INTC_IPR21_OFFSET                                      0
#define AVR32_INTC_IPR21_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR21_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR21_OFFSET_SIZE                                14
#define AVR32_INTC_IPR21_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR22                                    0x00000058
#define AVR32_INTC_IPR22_INTLEV                                     30
#define AVR32_INTC_IPR22_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR22_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR22_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR22_MASK                               0xc0003fff
#define AVR32_INTC_IPR22_OFFSET                                      0
#define AVR32_INTC_IPR22_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR22_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR22_OFFSET_SIZE                                14
#define AVR32_INTC_IPR22_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR23                                    0x0000005c
#define AVR32_INTC_IPR23_INTLEV                                     30
#define AVR32_INTC_IPR23_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR23_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR23_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR23_MASK                               0xc0003fff
#define AVR32_INTC_IPR23_OFFSET                                      0
#define AVR32_INTC_IPR23_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR23_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR23_OFFSET_SIZE                                14
#define AVR32_INTC_IPR23_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR24                                    0x00000060
#define AVR32_INTC_IPR24_INTLEV                                     30
#define AVR32_INTC_IPR24_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR24_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR24_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR24_MASK                               0xc0003fff
#define AVR32_INTC_IPR24_OFFSET                                      0
#define AVR32_INTC_IPR24_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR24_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR24_OFFSET_SIZE                                14
#define AVR32_INTC_IPR24_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR25                                    0x00000064
#define AVR32_INTC_IPR25_INTLEV                                     30
#define AVR32_INTC_IPR25_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR25_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR25_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR25_MASK                               0xc0003fff
#define AVR32_INTC_IPR25_OFFSET                                      0
#define AVR32_INTC_IPR25_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR25_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR25_OFFSET_SIZE                                14
#define AVR32_INTC_IPR25_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR26                                    0x00000068
#define AVR32_INTC_IPR26_INTLEV                                     30
#define AVR32_INTC_IPR26_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR26_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR26_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR26_MASK                               0xc0003fff
#define AVR32_INTC_IPR26_OFFSET                                      0
#define AVR32_INTC_IPR26_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR26_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR26_OFFSET_SIZE                                14
#define AVR32_INTC_IPR26_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR27                                    0x0000006c
#define AVR32_INTC_IPR27_INTLEV                                     30
#define AVR32_INTC_IPR27_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR27_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR27_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR27_MASK                               0xc0003fff
#define AVR32_INTC_IPR27_OFFSET                                      0
#define AVR32_INTC_IPR27_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR27_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR27_OFFSET_SIZE                                14
#define AVR32_INTC_IPR27_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR28                                    0x00000070
#define AVR32_INTC_IPR28_INTLEV                                     30
#define AVR32_INTC_IPR28_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR28_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR28_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR28_MASK                               0xc0003fff
#define AVR32_INTC_IPR28_OFFSET                                      0
#define AVR32_INTC_IPR28_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR28_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR28_OFFSET_SIZE                                14
#define AVR32_INTC_IPR28_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR29                                    0x00000074
#define AVR32_INTC_IPR29_INTLEV                                     30
#define AVR32_INTC_IPR29_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR29_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR29_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR29_MASK                               0xc0003fff
#define AVR32_INTC_IPR29_OFFSET                                      0
#define AVR32_INTC_IPR29_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR29_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR29_OFFSET_SIZE                                14
#define AVR32_INTC_IPR29_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR2_INTLEV                                      30
#define AVR32_INTC_IPR2_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR2_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR2_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR2_MASK                                0xc0003fff
#define AVR32_INTC_IPR2_OFFSET                                       0
#define AVR32_INTC_IPR2_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR2_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR2_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR2_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR3                                     0x0000000c
#define AVR32_INTC_IPR30                                    0x00000078
#define AVR32_INTC_IPR30_INTLEV                                     30
#define AVR32_INTC_IPR30_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR30_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR30_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR30_MASK                               0xc0003fff
#define AVR32_INTC_IPR30_OFFSET                                      0
#define AVR32_INTC_IPR30_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR30_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR30_OFFSET_SIZE                                14
#define AVR32_INTC_IPR30_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR31                                    0x0000007c
#define AVR32_INTC_IPR31_INTLEV                                     30
#define AVR32_INTC_IPR31_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR31_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR31_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR31_MASK                               0xc0003fff
#define AVR32_INTC_IPR31_OFFSET                                      0
#define AVR32_INTC_IPR31_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR31_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR31_OFFSET_SIZE                                14
#define AVR32_INTC_IPR31_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR32                                    0x00000080
#define AVR32_INTC_IPR32_INTLEV                                     30
#define AVR32_INTC_IPR32_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR32_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR32_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR32_MASK                               0xc0003fff
#define AVR32_INTC_IPR32_OFFSET                                      0
#define AVR32_INTC_IPR32_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR32_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR32_OFFSET_SIZE                                14
#define AVR32_INTC_IPR32_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR33                                    0x00000084
#define AVR32_INTC_IPR33_INTLEV                                     30
#define AVR32_INTC_IPR33_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR33_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR33_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR33_MASK                               0xc0003fff
#define AVR32_INTC_IPR33_OFFSET                                      0
#define AVR32_INTC_IPR33_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR33_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR33_OFFSET_SIZE                                14
#define AVR32_INTC_IPR33_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR34                                    0x00000088
#define AVR32_INTC_IPR34_INTLEV                                     30
#define AVR32_INTC_IPR34_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR34_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR34_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR34_MASK                               0xc0003fff
#define AVR32_INTC_IPR34_OFFSET                                      0
#define AVR32_INTC_IPR34_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR34_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR34_OFFSET_SIZE                                14
#define AVR32_INTC_IPR34_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR35                                    0x0000008c
#define AVR32_INTC_IPR35_INTLEV                                     30
#define AVR32_INTC_IPR35_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR35_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR35_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR35_MASK                               0xc0003fff
#define AVR32_INTC_IPR35_OFFSET                                      0
#define AVR32_INTC_IPR35_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR35_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR35_OFFSET_SIZE                                14
#define AVR32_INTC_IPR35_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR36                                    0x00000090
#define AVR32_INTC_IPR36_INTLEV                                     30
#define AVR32_INTC_IPR36_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR36_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR36_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR36_MASK                               0xc0003fff
#define AVR32_INTC_IPR36_OFFSET                                      0
#define AVR32_INTC_IPR36_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR36_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR36_OFFSET_SIZE                                14
#define AVR32_INTC_IPR36_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR37                                    0x00000094
#define AVR32_INTC_IPR37_INTLEV                                     30
#define AVR32_INTC_IPR37_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR37_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR37_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR37_MASK                               0xc0003fff
#define AVR32_INTC_IPR37_OFFSET                                      0
#define AVR32_INTC_IPR37_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR37_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR37_OFFSET_SIZE                                14
#define AVR32_INTC_IPR37_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR38                                    0x00000098
#define AVR32_INTC_IPR38_INTLEV                                     30
#define AVR32_INTC_IPR38_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR38_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR38_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR38_MASK                               0xc0003fff
#define AVR32_INTC_IPR38_OFFSET                                      0
#define AVR32_INTC_IPR38_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR38_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR38_OFFSET_SIZE                                14
#define AVR32_INTC_IPR38_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR39                                    0x0000009c
#define AVR32_INTC_IPR39_INTLEV                                     30
#define AVR32_INTC_IPR39_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR39_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR39_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR39_MASK                               0xc0003fff
#define AVR32_INTC_IPR39_OFFSET                                      0
#define AVR32_INTC_IPR39_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR39_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR39_OFFSET_SIZE                                14
#define AVR32_INTC_IPR39_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR3_INTLEV                                      30
#define AVR32_INTC_IPR3_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR3_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR3_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR3_MASK                                0xc0003fff
#define AVR32_INTC_IPR3_OFFSET                                       0
#define AVR32_INTC_IPR3_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR3_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR3_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR3_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR4                                     0x00000010
#define AVR32_INTC_IPR40                                    0x000000a0
#define AVR32_INTC_IPR40_INTLEV                                     30
#define AVR32_INTC_IPR40_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR40_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR40_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR40_MASK                               0xc0003fff
#define AVR32_INTC_IPR40_OFFSET                                      0
#define AVR32_INTC_IPR40_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR40_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR40_OFFSET_SIZE                                14
#define AVR32_INTC_IPR40_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR41                                    0x000000a4
#define AVR32_INTC_IPR41_INTLEV                                     30
#define AVR32_INTC_IPR41_INTLEV_MASK                        0xc0000000
#define AVR32_INTC_IPR41_INTLEV_OFFSET                              30
#define AVR32_INTC_IPR41_INTLEV_SIZE                                 2
#define AVR32_INTC_IPR41_MASK                               0xc0003fff
#define AVR32_INTC_IPR41_OFFSET                                      0
#define AVR32_INTC_IPR41_OFFSET_MASK                        0x00003fff
#define AVR32_INTC_IPR41_OFFSET_OFFSET                               0
#define AVR32_INTC_IPR41_OFFSET_SIZE                                14
#define AVR32_INTC_IPR41_RESETVALUE                         0x00000000
#define AVR32_INTC_IPR4_INTLEV                                      30
#define AVR32_INTC_IPR4_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR4_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR4_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR4_MASK                                0xc0003fff
#define AVR32_INTC_IPR4_OFFSET                                       0
#define AVR32_INTC_IPR4_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR4_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR4_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR4_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR5                                     0x00000014
#define AVR32_INTC_IPR5_INTLEV                                      30
#define AVR32_INTC_IPR5_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR5_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR5_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR5_MASK                                0xc0003fff
#define AVR32_INTC_IPR5_OFFSET                                       0
#define AVR32_INTC_IPR5_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR5_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR5_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR5_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR6                                     0x00000018
#define AVR32_INTC_IPR6_INTLEV                                      30
#define AVR32_INTC_IPR6_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR6_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR6_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR6_MASK                                0xc0003fff
#define AVR32_INTC_IPR6_OFFSET                                       0
#define AVR32_INTC_IPR6_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR6_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR6_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR6_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR7                                     0x0000001c
#define AVR32_INTC_IPR7_INTLEV                                      30
#define AVR32_INTC_IPR7_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR7_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR7_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR7_MASK                                0xc0003fff
#define AVR32_INTC_IPR7_OFFSET                                       0
#define AVR32_INTC_IPR7_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR7_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR7_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR7_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR8                                     0x00000020
#define AVR32_INTC_IPR8_INTLEV                                      30
#define AVR32_INTC_IPR8_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR8_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR8_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR8_MASK                                0xc0003fff
#define AVR32_INTC_IPR8_OFFSET                                       0
#define AVR32_INTC_IPR8_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR8_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR8_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR8_RESETVALUE                          0x00000000
#define AVR32_INTC_IPR9                                     0x00000024
#define AVR32_INTC_IPR9_INTLEV                                      30
#define AVR32_INTC_IPR9_INTLEV_MASK                         0xc0000000
#define AVR32_INTC_IPR9_INTLEV_OFFSET                               30
#define AVR32_INTC_IPR9_INTLEV_SIZE                                  2
#define AVR32_INTC_IPR9_MASK                                0xc0003fff
#define AVR32_INTC_IPR9_OFFSET                                       0
#define AVR32_INTC_IPR9_OFFSET_MASK                         0x00003fff
#define AVR32_INTC_IPR9_OFFSET_OFFSET                                0
#define AVR32_INTC_IPR9_OFFSET_SIZE                                 14
#define AVR32_INTC_IPR9_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR0                                     0x00000100
#define AVR32_INTC_IRR0_IREQUEST0                                    0
#define AVR32_INTC_IRR0_IREQUEST0_MASK                      0x00000001
#define AVR32_INTC_IRR0_IREQUEST0_OFFSET                             0
#define AVR32_INTC_IRR0_IREQUEST0_SIZE                               1
#define AVR32_INTC_IRR0_MASK                                0x00000001
#define AVR32_INTC_IRR0_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR1                                     0x00000104
#define AVR32_INTC_IRR10                                    0x00000128
#define AVR32_INTC_IRR10_IREQUEST320                                 0
#define AVR32_INTC_IRR10_IREQUEST320_MASK                   0x00000001
#define AVR32_INTC_IRR10_IREQUEST320_OFFSET                          0
#define AVR32_INTC_IRR10_IREQUEST320_SIZE                            1
#define AVR32_INTC_IRR10_MASK                               0x00000001
#define AVR32_INTC_IRR10_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR11                                    0x0000012c
#define AVR32_INTC_IRR11_IREQUEST352                                 0
#define AVR32_INTC_IRR11_IREQUEST352_MASK                   0x00000001
#define AVR32_INTC_IRR11_IREQUEST352_OFFSET                          0
#define AVR32_INTC_IRR11_IREQUEST352_SIZE                            1
#define AVR32_INTC_IRR11_IREQUEST353                                 1
#define AVR32_INTC_IRR11_IREQUEST353_MASK                   0x00000002
#define AVR32_INTC_IRR11_IREQUEST353_OFFSET                          1
#define AVR32_INTC_IRR11_IREQUEST353_SIZE                            1
#define AVR32_INTC_IRR11_IREQUEST354                                 2
#define AVR32_INTC_IRR11_IREQUEST354_MASK                   0x00000004
#define AVR32_INTC_IRR11_IREQUEST354_OFFSET                          2
#define AVR32_INTC_IRR11_IREQUEST354_SIZE                            1
#define AVR32_INTC_IRR11_MASK                               0x00000007
#define AVR32_INTC_IRR11_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR12                                    0x00000130
#define AVR32_INTC_IRR12_IREQUEST384                                 0
#define AVR32_INTC_IRR12_IREQUEST384_MASK                   0x00000001
#define AVR32_INTC_IRR12_IREQUEST384_OFFSET                          0
#define AVR32_INTC_IRR12_IREQUEST384_SIZE                            1
#define AVR32_INTC_IRR12_MASK                               0x00000001
#define AVR32_INTC_IRR12_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR13                                    0x00000134
#define AVR32_INTC_IRR13_IREQUEST416                                 0
#define AVR32_INTC_IRR13_IREQUEST416_MASK                   0x00000001
#define AVR32_INTC_IRR13_IREQUEST416_OFFSET                          0
#define AVR32_INTC_IRR13_IREQUEST416_SIZE                            1
#define AVR32_INTC_IRR13_MASK                               0x00000001
#define AVR32_INTC_IRR13_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR14                                    0x00000138
#define AVR32_INTC_IRR14_IREQUEST448                                 0
#define AVR32_INTC_IRR14_IREQUEST448_MASK                   0x00000001
#define AVR32_INTC_IRR14_IREQUEST448_OFFSET                          0
#define AVR32_INTC_IRR14_IREQUEST448_SIZE                            1
#define AVR32_INTC_IRR14_IREQUEST449                                 1
#define AVR32_INTC_IRR14_IREQUEST449_MASK                   0x00000002
#define AVR32_INTC_IRR14_IREQUEST449_OFFSET                          1
#define AVR32_INTC_IRR14_IREQUEST449_SIZE                            1
#define AVR32_INTC_IRR14_IREQUEST450                                 2
#define AVR32_INTC_IRR14_IREQUEST450_MASK                   0x00000004
#define AVR32_INTC_IRR14_IREQUEST450_OFFSET                          2
#define AVR32_INTC_IRR14_IREQUEST450_SIZE                            1
#define AVR32_INTC_IRR14_IREQUEST451                                 3
#define AVR32_INTC_IRR14_IREQUEST451_MASK                   0x00000008
#define AVR32_INTC_IRR14_IREQUEST451_OFFSET                          3
#define AVR32_INTC_IRR14_IREQUEST451_SIZE                            1
#define AVR32_INTC_IRR14_IREQUEST452                                 4
#define AVR32_INTC_IRR14_IREQUEST452_MASK                   0x00000010
#define AVR32_INTC_IRR14_IREQUEST452_OFFSET                          4
#define AVR32_INTC_IRR14_IREQUEST452_SIZE                            1
#define AVR32_INTC_IRR14_MASK                               0x0000001f
#define AVR32_INTC_IRR14_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR15                                    0x0000013c
#define AVR32_INTC_IRR15_IREQUEST480                                 0
#define AVR32_INTC_IRR15_IREQUEST480_MASK                   0x00000001
#define AVR32_INTC_IRR15_IREQUEST480_OFFSET                          0
#define AVR32_INTC_IRR15_IREQUEST480_SIZE                            1
#define AVR32_INTC_IRR15_IREQUEST481                                 1
#define AVR32_INTC_IRR15_IREQUEST481_MASK                   0x00000002
#define AVR32_INTC_IRR15_IREQUEST481_OFFSET                          1
#define AVR32_INTC_IRR15_IREQUEST481_SIZE                            1
#define AVR32_INTC_IRR15_IREQUEST482                                 2
#define AVR32_INTC_IRR15_IREQUEST482_MASK                   0x00000004
#define AVR32_INTC_IRR15_IREQUEST482_OFFSET                          2
#define AVR32_INTC_IRR15_IREQUEST482_SIZE                            1
#define AVR32_INTC_IRR15_IREQUEST483                                 3
#define AVR32_INTC_IRR15_IREQUEST483_MASK                   0x00000008
#define AVR32_INTC_IRR15_IREQUEST483_OFFSET                          3
#define AVR32_INTC_IRR15_IREQUEST483_SIZE                            1
#define AVR32_INTC_IRR15_MASK                               0x0000000f
#define AVR32_INTC_IRR15_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR16                                    0x00000140
#define AVR32_INTC_IRR16_IREQUEST512                                 0
#define AVR32_INTC_IRR16_IREQUEST512_MASK                   0x00000001
#define AVR32_INTC_IRR16_IREQUEST512_OFFSET                          0
#define AVR32_INTC_IRR16_IREQUEST512_SIZE                            1
#define AVR32_INTC_IRR16_IREQUEST513                                 1
#define AVR32_INTC_IRR16_IREQUEST513_MASK                   0x00000002
#define AVR32_INTC_IRR16_IREQUEST513_OFFSET                          1
#define AVR32_INTC_IRR16_IREQUEST513_SIZE                            1
#define AVR32_INTC_IRR16_IREQUEST514                                 2
#define AVR32_INTC_IRR16_IREQUEST514_MASK                   0x00000004
#define AVR32_INTC_IRR16_IREQUEST514_OFFSET                          2
#define AVR32_INTC_IRR16_IREQUEST514_SIZE                            1
#define AVR32_INTC_IRR16_IREQUEST515                                 3
#define AVR32_INTC_IRR16_IREQUEST515_MASK                   0x00000008
#define AVR32_INTC_IRR16_IREQUEST515_OFFSET                          3
#define AVR32_INTC_IRR16_IREQUEST515_SIZE                            1
#define AVR32_INTC_IRR16_MASK                               0x0000000f
#define AVR32_INTC_IRR16_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR17                                    0x00000144
#define AVR32_INTC_IRR17_IREQUEST544                                 0
#define AVR32_INTC_IRR17_IREQUEST544_MASK                   0x00000001
#define AVR32_INTC_IRR17_IREQUEST544_OFFSET                          0
#define AVR32_INTC_IRR17_IREQUEST544_SIZE                            1
#define AVR32_INTC_IRR17_MASK                               0x00000001
#define AVR32_INTC_IRR17_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR18                                    0x00000148
#define AVR32_INTC_IRR18_IREQUEST576                                 0
#define AVR32_INTC_IRR18_IREQUEST576_MASK                   0x00000001
#define AVR32_INTC_IRR18_IREQUEST576_OFFSET                          0
#define AVR32_INTC_IRR18_IREQUEST576_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST577                                 1
#define AVR32_INTC_IRR18_IREQUEST577_MASK                   0x00000002
#define AVR32_INTC_IRR18_IREQUEST577_OFFSET                          1
#define AVR32_INTC_IRR18_IREQUEST577_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST578                                 2
#define AVR32_INTC_IRR18_IREQUEST578_MASK                   0x00000004
#define AVR32_INTC_IRR18_IREQUEST578_OFFSET                          2
#define AVR32_INTC_IRR18_IREQUEST578_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST579                                 3
#define AVR32_INTC_IRR18_IREQUEST579_MASK                   0x00000008
#define AVR32_INTC_IRR18_IREQUEST579_OFFSET                          3
#define AVR32_INTC_IRR18_IREQUEST579_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST580                                 4
#define AVR32_INTC_IRR18_IREQUEST580_MASK                   0x00000010
#define AVR32_INTC_IRR18_IREQUEST580_OFFSET                          4
#define AVR32_INTC_IRR18_IREQUEST580_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST581                                 5
#define AVR32_INTC_IRR18_IREQUEST581_MASK                   0x00000020
#define AVR32_INTC_IRR18_IREQUEST581_OFFSET                          5
#define AVR32_INTC_IRR18_IREQUEST581_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST582                                 6
#define AVR32_INTC_IRR18_IREQUEST582_MASK                   0x00000040
#define AVR32_INTC_IRR18_IREQUEST582_OFFSET                          6
#define AVR32_INTC_IRR18_IREQUEST582_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST583                                 7
#define AVR32_INTC_IRR18_IREQUEST583_MASK                   0x00000080
#define AVR32_INTC_IRR18_IREQUEST583_OFFSET                          7
#define AVR32_INTC_IRR18_IREQUEST583_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST584                                 8
#define AVR32_INTC_IRR18_IREQUEST584_MASK                   0x00000100
#define AVR32_INTC_IRR18_IREQUEST584_OFFSET                          8
#define AVR32_INTC_IRR18_IREQUEST584_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST585                                 9
#define AVR32_INTC_IRR18_IREQUEST585_MASK                   0x00000200
#define AVR32_INTC_IRR18_IREQUEST585_OFFSET                          9
#define AVR32_INTC_IRR18_IREQUEST585_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST586                                10
#define AVR32_INTC_IRR18_IREQUEST586_MASK                   0x00000400
#define AVR32_INTC_IRR18_IREQUEST586_OFFSET                         10
#define AVR32_INTC_IRR18_IREQUEST586_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST587                                11
#define AVR32_INTC_IRR18_IREQUEST587_MASK                   0x00000800
#define AVR32_INTC_IRR18_IREQUEST587_OFFSET                         11
#define AVR32_INTC_IRR18_IREQUEST587_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST588                                12
#define AVR32_INTC_IRR18_IREQUEST588_MASK                   0x00001000
#define AVR32_INTC_IRR18_IREQUEST588_OFFSET                         12
#define AVR32_INTC_IRR18_IREQUEST588_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST589                                13
#define AVR32_INTC_IRR18_IREQUEST589_MASK                   0x00002000
#define AVR32_INTC_IRR18_IREQUEST589_OFFSET                         13
#define AVR32_INTC_IRR18_IREQUEST589_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST590                                14
#define AVR32_INTC_IRR18_IREQUEST590_MASK                   0x00004000
#define AVR32_INTC_IRR18_IREQUEST590_OFFSET                         14
#define AVR32_INTC_IRR18_IREQUEST590_SIZE                            1
#define AVR32_INTC_IRR18_IREQUEST591                                15
#define AVR32_INTC_IRR18_IREQUEST591_MASK                   0x00008000
#define AVR32_INTC_IRR18_IREQUEST591_OFFSET                         15
#define AVR32_INTC_IRR18_IREQUEST591_SIZE                            1
#define AVR32_INTC_IRR18_MASK                               0x0000ffff
#define AVR32_INTC_IRR18_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR19                                    0x0000014c
#define AVR32_INTC_IRR19_IREQUEST608                                 0
#define AVR32_INTC_IRR19_IREQUEST608_MASK                   0x00000001
#define AVR32_INTC_IRR19_IREQUEST608_OFFSET                          0
#define AVR32_INTC_IRR19_IREQUEST608_SIZE                            1
#define AVR32_INTC_IRR19_MASK                               0x00000001
#define AVR32_INTC_IRR19_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR1_IREQUEST32                                   0
#define AVR32_INTC_IRR1_IREQUEST32_MASK                     0x00000001
#define AVR32_INTC_IRR1_IREQUEST32_OFFSET                            0
#define AVR32_INTC_IRR1_IREQUEST32_SIZE                              1
#define AVR32_INTC_IRR1_IREQUEST33                                   1
#define AVR32_INTC_IRR1_IREQUEST33_MASK                     0x00000002
#define AVR32_INTC_IRR1_IREQUEST33_OFFSET                            1
#define AVR32_INTC_IRR1_IREQUEST33_SIZE                              1
#define AVR32_INTC_IRR1_MASK                                0x00000003
#define AVR32_INTC_IRR1_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR2                                     0x00000108
#define AVR32_INTC_IRR20                                    0x00000150
#define AVR32_INTC_IRR20_IREQUEST640                                 0
#define AVR32_INTC_IRR20_IREQUEST640_MASK                   0x00000001
#define AVR32_INTC_IRR20_IREQUEST640_OFFSET                          0
#define AVR32_INTC_IRR20_IREQUEST640_SIZE                            1
#define AVR32_INTC_IRR20_MASK                               0x00000001
#define AVR32_INTC_IRR20_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR21                                    0x00000154
#define AVR32_INTC_IRR21_IREQUEST672                                 0
#define AVR32_INTC_IRR21_IREQUEST672_MASK                   0x00000001
#define AVR32_INTC_IRR21_IREQUEST672_OFFSET                          0
#define AVR32_INTC_IRR21_IREQUEST672_SIZE                            1
#define AVR32_INTC_IRR21_MASK                               0x00000001
#define AVR32_INTC_IRR21_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR22                                    0x00000158
#define AVR32_INTC_IRR22_IREQUEST704                                 0
#define AVR32_INTC_IRR22_IREQUEST704_MASK                   0x00000001
#define AVR32_INTC_IRR22_IREQUEST704_OFFSET                          0
#define AVR32_INTC_IRR22_IREQUEST704_SIZE                            1
#define AVR32_INTC_IRR22_MASK                               0x00000001
#define AVR32_INTC_IRR22_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR23                                    0x0000015c
#define AVR32_INTC_IRR23_IREQUEST736                                 0
#define AVR32_INTC_IRR23_IREQUEST736_MASK                   0x00000001
#define AVR32_INTC_IRR23_IREQUEST736_OFFSET                          0
#define AVR32_INTC_IRR23_IREQUEST736_SIZE                            1
#define AVR32_INTC_IRR23_MASK                               0x00000001
#define AVR32_INTC_IRR23_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR24                                    0x00000160
#define AVR32_INTC_IRR24_IREQUEST768                                 0
#define AVR32_INTC_IRR24_IREQUEST768_MASK                   0x00000001
#define AVR32_INTC_IRR24_IREQUEST768_OFFSET                          0
#define AVR32_INTC_IRR24_IREQUEST768_SIZE                            1
#define AVR32_INTC_IRR24_MASK                               0x00000001
#define AVR32_INTC_IRR24_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR25                                    0x00000164
#define AVR32_INTC_IRR25_IREQUEST800                                 0
#define AVR32_INTC_IRR25_IREQUEST800_MASK                   0x00000001
#define AVR32_INTC_IRR25_IREQUEST800_OFFSET                          0
#define AVR32_INTC_IRR25_IREQUEST800_SIZE                            1
#define AVR32_INTC_IRR25_MASK                               0x00000001
#define AVR32_INTC_IRR25_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR26                                    0x00000168
#define AVR32_INTC_IRR26_IREQUEST832                                 0
#define AVR32_INTC_IRR26_IREQUEST832_MASK                   0x00000001
#define AVR32_INTC_IRR26_IREQUEST832_OFFSET                          0
#define AVR32_INTC_IRR26_IREQUEST832_SIZE                            1
#define AVR32_INTC_IRR26_MASK                               0x00000001
#define AVR32_INTC_IRR26_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR27                                    0x0000016c
#define AVR32_INTC_IRR27_IREQUEST864                                 0
#define AVR32_INTC_IRR27_IREQUEST864_MASK                   0x00000001
#define AVR32_INTC_IRR27_IREQUEST864_OFFSET                          0
#define AVR32_INTC_IRR27_IREQUEST864_SIZE                            1
#define AVR32_INTC_IRR27_MASK                               0x00000001
#define AVR32_INTC_IRR27_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR28                                    0x00000170
#define AVR32_INTC_IRR28_IREQUEST896                                 0
#define AVR32_INTC_IRR28_IREQUEST896_MASK                   0x00000001
#define AVR32_INTC_IRR28_IREQUEST896_OFFSET                          0
#define AVR32_INTC_IRR28_IREQUEST896_SIZE                            1
#define AVR32_INTC_IRR28_MASK                               0x00000001
#define AVR32_INTC_IRR28_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR29                                    0x00000174
#define AVR32_INTC_IRR29_IREQUEST928                                 0
#define AVR32_INTC_IRR29_IREQUEST928_MASK                   0x00000001
#define AVR32_INTC_IRR29_IREQUEST928_OFFSET                          0
#define AVR32_INTC_IRR29_IREQUEST928_SIZE                            1
#define AVR32_INTC_IRR29_MASK                               0x00000001
#define AVR32_INTC_IRR29_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR2_IREQUEST64                                   0
#define AVR32_INTC_IRR2_IREQUEST64_MASK                     0x00000001
#define AVR32_INTC_IRR2_IREQUEST64_OFFSET                            0
#define AVR32_INTC_IRR2_IREQUEST64_SIZE                              1
#define AVR32_INTC_IRR2_MASK                                0x00000001
#define AVR32_INTC_IRR2_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR3                                     0x0000010c
#define AVR32_INTC_IRR30                                    0x00000178
#define AVR32_INTC_IRR30_IREQUEST960                                 0
#define AVR32_INTC_IRR30_IREQUEST960_MASK                   0x00000001
#define AVR32_INTC_IRR30_IREQUEST960_OFFSET                          0
#define AVR32_INTC_IRR30_IREQUEST960_SIZE                            1
#define AVR32_INTC_IRR30_MASK                               0x00000001
#define AVR32_INTC_IRR30_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR31                                    0x0000017c
#define AVR32_INTC_IRR31_IREQUEST992                                 0
#define AVR32_INTC_IRR31_IREQUEST992_MASK                   0x00000001
#define AVR32_INTC_IRR31_IREQUEST992_OFFSET                          0
#define AVR32_INTC_IRR31_IREQUEST992_SIZE                            1
#define AVR32_INTC_IRR31_MASK                               0x00000001
#define AVR32_INTC_IRR31_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR32                                    0x00000180
#define AVR32_INTC_IRR32_IREQUEST1024                                0
#define AVR32_INTC_IRR32_IREQUEST1024_MASK                  0x00000001
#define AVR32_INTC_IRR32_IREQUEST1024_OFFSET                         0
#define AVR32_INTC_IRR32_IREQUEST1024_SIZE                           1
#define AVR32_INTC_IRR32_MASK                               0x00000001
#define AVR32_INTC_IRR32_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR33                                    0x00000184
#define AVR32_INTC_IRR33_IREQUEST1056                                0
#define AVR32_INTC_IRR33_IREQUEST1056_MASK                  0x00000001
#define AVR32_INTC_IRR33_IREQUEST1056_OFFSET                         0
#define AVR32_INTC_IRR33_IREQUEST1056_SIZE                           1
#define AVR32_INTC_IRR33_IREQUEST1057                                1
#define AVR32_INTC_IRR33_IREQUEST1057_MASK                  0x00000002
#define AVR32_INTC_IRR33_IREQUEST1057_OFFSET                         1
#define AVR32_INTC_IRR33_IREQUEST1057_SIZE                           1
#define AVR32_INTC_IRR33_IREQUEST1058                                2
#define AVR32_INTC_IRR33_IREQUEST1058_MASK                  0x00000004
#define AVR32_INTC_IRR33_IREQUEST1058_OFFSET                         2
#define AVR32_INTC_IRR33_IREQUEST1058_SIZE                           1
#define AVR32_INTC_IRR33_MASK                               0x00000007
#define AVR32_INTC_IRR33_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR34                                    0x00000188
#define AVR32_INTC_IRR34_IREQUEST1088                                0
#define AVR32_INTC_IRR34_IREQUEST1088_MASK                  0x00000001
#define AVR32_INTC_IRR34_IREQUEST1088_OFFSET                         0
#define AVR32_INTC_IRR34_IREQUEST1088_SIZE                           1
#define AVR32_INTC_IRR34_IREQUEST1089                                1
#define AVR32_INTC_IRR34_IREQUEST1089_MASK                  0x00000002
#define AVR32_INTC_IRR34_IREQUEST1089_OFFSET                         1
#define AVR32_INTC_IRR34_IREQUEST1089_SIZE                           1
#define AVR32_INTC_IRR34_IREQUEST1090                                2
#define AVR32_INTC_IRR34_IREQUEST1090_MASK                  0x00000004
#define AVR32_INTC_IRR34_IREQUEST1090_OFFSET                         2
#define AVR32_INTC_IRR34_IREQUEST1090_SIZE                           1
#define AVR32_INTC_IRR34_MASK                               0x00000007
#define AVR32_INTC_IRR34_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR35                                    0x0000018c
#define AVR32_INTC_IRR35_IREQUEST1120                                0
#define AVR32_INTC_IRR35_IREQUEST1120_MASK                  0x00000001
#define AVR32_INTC_IRR35_IREQUEST1120_OFFSET                         0
#define AVR32_INTC_IRR35_IREQUEST1120_SIZE                           1
#define AVR32_INTC_IRR35_IREQUEST1121                                1
#define AVR32_INTC_IRR35_IREQUEST1121_MASK                  0x00000002
#define AVR32_INTC_IRR35_IREQUEST1121_OFFSET                         1
#define AVR32_INTC_IRR35_IREQUEST1121_SIZE                           1
#define AVR32_INTC_IRR35_MASK                               0x00000003
#define AVR32_INTC_IRR35_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR36                                    0x00000190
#define AVR32_INTC_IRR36_IREQUEST1152                                0
#define AVR32_INTC_IRR36_IREQUEST1152_MASK                  0x00000001
#define AVR32_INTC_IRR36_IREQUEST1152_OFFSET                         0
#define AVR32_INTC_IRR36_IREQUEST1152_SIZE                           1
#define AVR32_INTC_IRR36_IREQUEST1153                                1
#define AVR32_INTC_IRR36_IREQUEST1153_MASK                  0x00000002
#define AVR32_INTC_IRR36_IREQUEST1153_OFFSET                         1
#define AVR32_INTC_IRR36_IREQUEST1153_SIZE                           1
#define AVR32_INTC_IRR36_IREQUEST1154                                2
#define AVR32_INTC_IRR36_IREQUEST1154_MASK                  0x00000004
#define AVR32_INTC_IRR36_IREQUEST1154_OFFSET                         2
#define AVR32_INTC_IRR36_IREQUEST1154_SIZE                           1
#define AVR32_INTC_IRR36_IREQUEST1155                                3
#define AVR32_INTC_IRR36_IREQUEST1155_MASK                  0x00000008
#define AVR32_INTC_IRR36_IREQUEST1155_OFFSET                         3
#define AVR32_INTC_IRR36_IREQUEST1155_SIZE                           1
#define AVR32_INTC_IRR36_IREQUEST1156                                4
#define AVR32_INTC_IRR36_IREQUEST1156_MASK                  0x00000010
#define AVR32_INTC_IRR36_IREQUEST1156_OFFSET                         4
#define AVR32_INTC_IRR36_IREQUEST1156_SIZE                           1
#define AVR32_INTC_IRR36_IREQUEST1157                                5
#define AVR32_INTC_IRR36_IREQUEST1157_MASK                  0x00000020
#define AVR32_INTC_IRR36_IREQUEST1157_OFFSET                         5
#define AVR32_INTC_IRR36_IREQUEST1157_SIZE                           1
#define AVR32_INTC_IRR36_MASK                               0x0000003f
#define AVR32_INTC_IRR36_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR37                                    0x00000194
#define AVR32_INTC_IRR37_IREQUEST1184                                0
#define AVR32_INTC_IRR37_IREQUEST1184_MASK                  0x00000001
#define AVR32_INTC_IRR37_IREQUEST1184_OFFSET                         0
#define AVR32_INTC_IRR37_IREQUEST1184_SIZE                           1
#define AVR32_INTC_IRR37_MASK                               0x00000001
#define AVR32_INTC_IRR37_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR38                                    0x00000198
#define AVR32_INTC_IRR38_IREQUEST1216                                0
#define AVR32_INTC_IRR38_IREQUEST1216_MASK                  0x00000001
#define AVR32_INTC_IRR38_IREQUEST1216_OFFSET                         0
#define AVR32_INTC_IRR38_IREQUEST1216_SIZE                           1
#define AVR32_INTC_IRR38_MASK                               0x00000001
#define AVR32_INTC_IRR38_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR39                                    0x0000019c
#define AVR32_INTC_IRR39_IREQUEST1248                                0
#define AVR32_INTC_IRR39_IREQUEST1248_MASK                  0x00000001
#define AVR32_INTC_IRR39_IREQUEST1248_OFFSET                         0
#define AVR32_INTC_IRR39_IREQUEST1248_SIZE                           1
#define AVR32_INTC_IRR39_IREQUEST1249                                1
#define AVR32_INTC_IRR39_IREQUEST1249_MASK                  0x00000002
#define AVR32_INTC_IRR39_IREQUEST1249_OFFSET                         1
#define AVR32_INTC_IRR39_IREQUEST1249_SIZE                           1
#define AVR32_INTC_IRR39_IREQUEST1250                                2
#define AVR32_INTC_IRR39_IREQUEST1250_MASK                  0x00000004
#define AVR32_INTC_IRR39_IREQUEST1250_OFFSET                         2
#define AVR32_INTC_IRR39_IREQUEST1250_SIZE                           1
#define AVR32_INTC_IRR39_IREQUEST1251                                3
#define AVR32_INTC_IRR39_IREQUEST1251_MASK                  0x00000008
#define AVR32_INTC_IRR39_IREQUEST1251_OFFSET                         3
#define AVR32_INTC_IRR39_IREQUEST1251_SIZE                           1
#define AVR32_INTC_IRR39_IREQUEST1252                                4
#define AVR32_INTC_IRR39_IREQUEST1252_MASK                  0x00000010
#define AVR32_INTC_IRR39_IREQUEST1252_OFFSET                         4
#define AVR32_INTC_IRR39_IREQUEST1252_SIZE                           1
#define AVR32_INTC_IRR39_IREQUEST1253                                5
#define AVR32_INTC_IRR39_IREQUEST1253_MASK                  0x00000020
#define AVR32_INTC_IRR39_IREQUEST1253_OFFSET                         5
#define AVR32_INTC_IRR39_IREQUEST1253_SIZE                           1
#define AVR32_INTC_IRR39_MASK                               0x0000003f
#define AVR32_INTC_IRR39_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR3_IREQUEST96                                   0
#define AVR32_INTC_IRR3_IREQUEST96_MASK                     0x00000001
#define AVR32_INTC_IRR3_IREQUEST96_OFFSET                            0
#define AVR32_INTC_IRR3_IREQUEST96_SIZE                              1
#define AVR32_INTC_IRR3_IREQUEST97                                   1
#define AVR32_INTC_IRR3_IREQUEST97_MASK                     0x00000002
#define AVR32_INTC_IRR3_IREQUEST97_OFFSET                            1
#define AVR32_INTC_IRR3_IREQUEST97_SIZE                              1
#define AVR32_INTC_IRR3_IREQUEST98                                   2
#define AVR32_INTC_IRR3_IREQUEST98_MASK                     0x00000004
#define AVR32_INTC_IRR3_IREQUEST98_OFFSET                            2
#define AVR32_INTC_IRR3_IREQUEST98_SIZE                              1
#define AVR32_INTC_IRR3_IREQUEST99                                   3
#define AVR32_INTC_IRR3_IREQUEST99_MASK                     0x00000008
#define AVR32_INTC_IRR3_IREQUEST99_OFFSET                            3
#define AVR32_INTC_IRR3_IREQUEST99_SIZE                              1
#define AVR32_INTC_IRR3_MASK                                0x0000000f
#define AVR32_INTC_IRR3_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR4                                     0x00000110
#define AVR32_INTC_IRR40                                    0x000001a0
#define AVR32_INTC_IRR40_IREQUEST1280                                0
#define AVR32_INTC_IRR40_IREQUEST1280_MASK                  0x00000001
#define AVR32_INTC_IRR40_IREQUEST1280_OFFSET                         0
#define AVR32_INTC_IRR40_IREQUEST1280_SIZE                           1
#define AVR32_INTC_IRR40_IREQUEST1281                                1
#define AVR32_INTC_IRR40_IREQUEST1281_MASK                  0x00000002
#define AVR32_INTC_IRR40_IREQUEST1281_OFFSET                         1
#define AVR32_INTC_IRR40_IREQUEST1281_SIZE                           1
#define AVR32_INTC_IRR40_IREQUEST1282                                2
#define AVR32_INTC_IRR40_IREQUEST1282_MASK                  0x00000004
#define AVR32_INTC_IRR40_IREQUEST1282_OFFSET                         2
#define AVR32_INTC_IRR40_IREQUEST1282_SIZE                           1
#define AVR32_INTC_IRR40_IREQUEST1283                                3
#define AVR32_INTC_IRR40_IREQUEST1283_MASK                  0x00000008
#define AVR32_INTC_IRR40_IREQUEST1283_OFFSET                         3
#define AVR32_INTC_IRR40_IREQUEST1283_SIZE                           1
#define AVR32_INTC_IRR40_IREQUEST1284                                4
#define AVR32_INTC_IRR40_IREQUEST1284_MASK                  0x00000010
#define AVR32_INTC_IRR40_IREQUEST1284_OFFSET                         4
#define AVR32_INTC_IRR40_IREQUEST1284_SIZE                           1
#define AVR32_INTC_IRR40_IREQUEST1285                                5
#define AVR32_INTC_IRR40_IREQUEST1285_MASK                  0x00000020
#define AVR32_INTC_IRR40_IREQUEST1285_OFFSET                         5
#define AVR32_INTC_IRR40_IREQUEST1285_SIZE                           1
#define AVR32_INTC_IRR40_MASK                               0x0000003f
#define AVR32_INTC_IRR40_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR41                                    0x000001a4
#define AVR32_INTC_IRR41_IREQUEST1312                                0
#define AVR32_INTC_IRR41_IREQUEST1312_MASK                  0x00000001
#define AVR32_INTC_IRR41_IREQUEST1312_OFFSET                         0
#define AVR32_INTC_IRR41_IREQUEST1312_SIZE                           1
#define AVR32_INTC_IRR41_MASK                               0x00000001
#define AVR32_INTC_IRR41_RESETVALUE                         0x00000000
#define AVR32_INTC_IRR4_IREQUEST128                                  0
#define AVR32_INTC_IRR4_IREQUEST128_MASK                    0x00000001
#define AVR32_INTC_IRR4_IREQUEST128_OFFSET                           0
#define AVR32_INTC_IRR4_IREQUEST128_SIZE                             1
#define AVR32_INTC_IRR4_IREQUEST129                                  1
#define AVR32_INTC_IRR4_IREQUEST129_MASK                    0x00000002
#define AVR32_INTC_IRR4_IREQUEST129_OFFSET                           1
#define AVR32_INTC_IRR4_IREQUEST129_SIZE                             1
#define AVR32_INTC_IRR4_IREQUEST130                                  2
#define AVR32_INTC_IRR4_IREQUEST130_MASK                    0x00000004
#define AVR32_INTC_IRR4_IREQUEST130_OFFSET                           2
#define AVR32_INTC_IRR4_IREQUEST130_SIZE                             1
#define AVR32_INTC_IRR4_IREQUEST131                                  3
#define AVR32_INTC_IRR4_IREQUEST131_MASK                    0x00000008
#define AVR32_INTC_IRR4_IREQUEST131_OFFSET                           3
#define AVR32_INTC_IRR4_IREQUEST131_SIZE                             1
#define AVR32_INTC_IRR4_MASK                                0x0000000f
#define AVR32_INTC_IRR4_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR5                                     0x00000114
#define AVR32_INTC_IRR5_IREQUEST160                                  0
#define AVR32_INTC_IRR5_IREQUEST160_MASK                    0x00000001
#define AVR32_INTC_IRR5_IREQUEST160_OFFSET                           0
#define AVR32_INTC_IRR5_IREQUEST160_SIZE                             1
#define AVR32_INTC_IRR5_IREQUEST161                                  1
#define AVR32_INTC_IRR5_IREQUEST161_MASK                    0x00000002
#define AVR32_INTC_IRR5_IREQUEST161_OFFSET                           1
#define AVR32_INTC_IRR5_IREQUEST161_SIZE                             1
#define AVR32_INTC_IRR5_IREQUEST162                                  2
#define AVR32_INTC_IRR5_IREQUEST162_MASK                    0x00000004
#define AVR32_INTC_IRR5_IREQUEST162_OFFSET                           2
#define AVR32_INTC_IRR5_IREQUEST162_SIZE                             1
#define AVR32_INTC_IRR5_IREQUEST163                                  3
#define AVR32_INTC_IRR5_IREQUEST163_MASK                    0x00000008
#define AVR32_INTC_IRR5_IREQUEST163_OFFSET                           3
#define AVR32_INTC_IRR5_IREQUEST163_SIZE                             1
#define AVR32_INTC_IRR5_MASK                                0x0000000f
#define AVR32_INTC_IRR5_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR6                                     0x00000118
#define AVR32_INTC_IRR6_IREQUEST192                                  0
#define AVR32_INTC_IRR6_IREQUEST192_MASK                    0x00000001
#define AVR32_INTC_IRR6_IREQUEST192_OFFSET                           0
#define AVR32_INTC_IRR6_IREQUEST192_SIZE                             1
#define AVR32_INTC_IRR6_MASK                                0x00000001
#define AVR32_INTC_IRR6_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR7                                     0x0000011c
#define AVR32_INTC_IRR7_IREQUEST224                                  0
#define AVR32_INTC_IRR7_IREQUEST224_MASK                    0x00000001
#define AVR32_INTC_IRR7_IREQUEST224_OFFSET                           0
#define AVR32_INTC_IRR7_IREQUEST224_SIZE                             1
#define AVR32_INTC_IRR7_MASK                                0x00000001
#define AVR32_INTC_IRR7_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR8                                     0x00000120
#define AVR32_INTC_IRR8_IREQUEST256                                  0
#define AVR32_INTC_IRR8_IREQUEST256_MASK                    0x00000001
#define AVR32_INTC_IRR8_IREQUEST256_OFFSET                           0
#define AVR32_INTC_IRR8_IREQUEST256_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST257                                  1
#define AVR32_INTC_IRR8_IREQUEST257_MASK                    0x00000002
#define AVR32_INTC_IRR8_IREQUEST257_OFFSET                           1
#define AVR32_INTC_IRR8_IREQUEST257_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST258                                  2
#define AVR32_INTC_IRR8_IREQUEST258_MASK                    0x00000004
#define AVR32_INTC_IRR8_IREQUEST258_OFFSET                           2
#define AVR32_INTC_IRR8_IREQUEST258_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST259                                  3
#define AVR32_INTC_IRR8_IREQUEST259_MASK                    0x00000008
#define AVR32_INTC_IRR8_IREQUEST259_OFFSET                           3
#define AVR32_INTC_IRR8_IREQUEST259_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST260                                  4
#define AVR32_INTC_IRR8_IREQUEST260_MASK                    0x00000010
#define AVR32_INTC_IRR8_IREQUEST260_OFFSET                           4
#define AVR32_INTC_IRR8_IREQUEST260_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST261                                  5
#define AVR32_INTC_IRR8_IREQUEST261_MASK                    0x00000020
#define AVR32_INTC_IRR8_IREQUEST261_OFFSET                           5
#define AVR32_INTC_IRR8_IREQUEST261_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST262                                  6
#define AVR32_INTC_IRR8_IREQUEST262_MASK                    0x00000040
#define AVR32_INTC_IRR8_IREQUEST262_OFFSET                           6
#define AVR32_INTC_IRR8_IREQUEST262_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST263                                  7
#define AVR32_INTC_IRR8_IREQUEST263_MASK                    0x00000080
#define AVR32_INTC_IRR8_IREQUEST263_OFFSET                           7
#define AVR32_INTC_IRR8_IREQUEST263_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST264                                  8
#define AVR32_INTC_IRR8_IREQUEST264_MASK                    0x00000100
#define AVR32_INTC_IRR8_IREQUEST264_OFFSET                           8
#define AVR32_INTC_IRR8_IREQUEST264_SIZE                             1
#define AVR32_INTC_IRR8_IREQUEST265                                  9
#define AVR32_INTC_IRR8_IREQUEST265_MASK                    0x00000200
#define AVR32_INTC_IRR8_IREQUEST265_OFFSET                           9
#define AVR32_INTC_IRR8_IREQUEST265_SIZE                             1
#define AVR32_INTC_IRR8_MASK                                0x000003ff
#define AVR32_INTC_IRR8_RESETVALUE                          0x00000000
#define AVR32_INTC_IRR9                                     0x00000124
#define AVR32_INTC_IRR9_IREQUEST288                                  0
#define AVR32_INTC_IRR9_IREQUEST288_MASK                    0x00000001
#define AVR32_INTC_IRR9_IREQUEST288_OFFSET                           0
#define AVR32_INTC_IRR9_IREQUEST288_SIZE                             1
#define AVR32_INTC_IRR9_MASK                                0x00000001
#define AVR32_INTC_IRR9_RESETVALUE                          0x00000000


//! Local Patch For A32SFW Compilation
#define AVR32_INTC_INT0                                     0x00000000
#define AVR32_INTC_INT1                                     0x00000001
#define AVR32_INTC_INT2                                     0x00000002
#define AVR32_INTC_INT3                                     0x00000003
#define AVR32_INTC_IPR_INTLEVEL                                     30
#define AVR32_INTC_IPR_INTLEVEL_INT0                        0x00000000
#define AVR32_INTC_IPR_INTLEVEL_INT1                        0x00000001
#define AVR32_INTC_IPR_INTLEVEL_INT2                        0x00000002
#define AVR32_INTC_IPR_INTLEVEL_INT3                        0x00000003
#define AVR32_INTC_IPR_INTLEVEL_MASK                        0xc0000000
#define AVR32_INTC_IPR_INTLEVEL_OFFSET                              30
#define AVR32_INTC_IPR_INTLEVEL_SIZE                                 2
//! Local Patch For A32SFW Compilation

#ifdef __AVR32_ABI_COMPILER__

typedef struct avr32_intc_icr_t {
    unsigned int                 :26;
    unsigned int cause           : 6;
} avr32_intc_icr_t;

typedef struct avr32_intc_t {
  /*0x000*/
        unsigned long ipr[64];
  /*0x100*/
  const unsigned long irr[64];
  /*0x200*/
  union {
    const unsigned long                  icr       [4];//0x0200
    const avr32_intc_icr_t               ICR       [4];
  };
} avr32_intc_t;


/* #ifdef __AVR32_ABI_COMPILER__ */
#endif

/*#ifdef AVR32_INTC_H_INCLUDED*/
#endif

