/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class ColorWheelImageProducer
extends MemoryImageSource {
    protected int[] pixels;
    protected int w;
    protected int h;
    protected float brightness = 1.0f;
    protected boolean isDirty = true;
    protected float[] hues;
    protected float[] saturations;
    protected int[] alphas;

    public ColorWheelImageProducer(int w, int h) {
        super(w, h, null, 0, w);
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.generateLookupTables();
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, w);
        this.setAnimated(true);
        this.generateColorWheel();
    }

    public int getRadius() {
        return Math.min(this.w, this.h) / 2 - 2;
    }

    protected void generateLookupTables() {
        this.saturations = new float[this.w * this.h];
        this.hues = new float[this.w * this.h];
        this.alphas = new int[this.w * this.h];
        float radius = this.getRadius();
        float blend = (radius + 2.0f) / radius - 1.0f;
        int cx = this.w / 2;
        int cy = this.h / 2;
        for (int x = 0; x < this.w; ++x) {
            int kx = x - cx;
            int squarekx = kx * kx;
            for (int y = 0; y < this.h; ++y) {
                int ky = cy - y;
                int index = x + y * this.w;
                this.saturations[index] = (float)Math.sqrt(squarekx + ky * ky) / radius;
                if (this.saturations[index] <= 1.0f) {
                    this.alphas[index] = -16777216;
                } else {
                    this.alphas[index] = (int)((blend - Math.min(blend, this.saturations[index] - 1.0f)) * 255.0f / blend) << 24;
                    this.saturations[index] = 1.0f;
                }
                if (this.alphas[index] == 0) continue;
                this.hues[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
            }
        }
    }

    public void setBrightness(float newValue) {
        this.isDirty = this.isDirty || this.brightness != newValue;
        this.brightness = newValue;
    }

    public boolean needsGeneration() {
        return this.isDirty;
    }

    public void regenerateColorWheel() {
        if (this.isDirty) {
            this.generateColorWheel();
        }
    }

    public void generateColorWheel() {
        float radius = Math.min(this.w, this.h);
        for (int index = 0; index < this.pixels.length; ++index) {
            if (this.alphas[index] == 0) continue;
            this.pixels[index] = this.alphas[index] | 0xFFFFFF & Color.HSBtoRGB(this.hues[index], this.saturations[index], this.brightness);
        }
        this.newPixels();
        this.isDirty = false;
    }

    protected Point getColorLocation(Color c, int width, int height) {
        float[] hsb = new float[3];
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), hsb);
        return this.getColorLocation(hsb[0], hsb[1], hsb[2], width, height);
    }

    protected Point getColorLocation(float hue, float saturation, float brightness, int width, int height) {
        float radius = (float)Math.min(width, height) / 2.0f;
        return new Point(width / 2 + (int)((double)(radius * saturation) * Math.cos((double)hue * Math.PI * 2.0)), height / 2 - (int)((double)(radius * saturation) * Math.sin((double)hue * Math.PI * 2.0)));
    }

    protected float[] getColorAt(int x, int y, int width, int height) {
        float r = (float)Math.sqrt((x -= width / 2) * x + (y -= height / 2) * y);
        float theta = (float)Math.atan2(y, -x);
        float[] hsb = new float[]{(float)(0.5 + (double)theta / Math.PI / 2.0), Math.min(1.0f, r / (float)this.getRadius()), this.brightness};
        return hsb;
    }
}

