/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaBorderFactory;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisualMargin;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.InsetsUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

public class QuaquaScrollPaneBorder
extends VisualMargin {
    private String scrollPaneImagesLocation;
    private String textFieldImagesLocation;
    private Border[] scrollPaneBorders;
    private Border[] textFieldBorders;

    public QuaquaScrollPaneBorder(String scrollPaneImagesLocation, String textFieldImagesLocation) {
        super(3, 3, 3, 3);
        this.scrollPaneImagesLocation = scrollPaneImagesLocation;
        this.textFieldImagesLocation = textFieldImagesLocation;
    }

    protected boolean isTextBorder(Component component) {
        return this.getViewportView(component) instanceof JTextComponent;
    }

    protected Component getViewportView(Component component) {
        JViewport viewport;
        if (component instanceof JScrollPane && (viewport = ((JScrollPane)component).getViewport()) != null) {
            return viewport.getView();
        }
        return null;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets = this.getVisualMargin(c, insets);
        Insets inner = this.isTextBorder(c) ? new Insets(5, 4, 4, 4) : new Insets(4, 4, 4, 4);
        InsetsUtil.addTo(inner, insets);
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets margin = this.getVisualMargin(c, new Insets(0, 0, 0, 0));
        Border border = this.getBorder(c);
        border.paintBorder(c, g, x + margin.left, y + margin.top, width - margin.left - margin.right, height - margin.top - margin.bottom);
        if (c instanceof JTextComponent) {
            Debug.paint(g, (JTextComponent)c, ((JTextComponent)c).getUI());
        }
    }

    private Border getBorder(Component c) {
        Border[] borders;
        if (this.isTextBorder(c)) {
            if (this.textFieldBorders == null) {
                this.textFieldBorders = (Border[])QuaquaBorderFactory.create(this.textFieldImagesLocation, new Insets(6, 6, 6, 6), 3, true, true, false);
            }
            borders = this.textFieldBorders;
        } else {
            if (this.scrollPaneBorders == null) {
                this.scrollPaneBorders = (Border[])QuaquaBorderFactory.create(this.textFieldImagesLocation, new Insets(6, 6, 5, 6), 3, true, true, false);
            }
            borders = this.scrollPaneBorders;
        }
        Component viewportView = this.getViewportView(c);
        if (viewportView == null) {
            viewportView = c;
        }
        boolean isEditable = viewportView instanceof JTextComponent ? ((JTextComponent)viewportView).isEditable() : true;
        if (viewportView.isEnabled() && (QuaquaUtilities.isFocused(viewportView) || viewportView instanceof JComponent && ((JComponent)viewportView).getClientProperty("Quaqua.drawFocusBorder") == Boolean.TRUE)) {
            return borders[2];
        }
        if (c.isEnabled() && viewportView.isEnabled() && isEditable) {
            return borders[0];
        }
        return borders[1];
    }

    public static class UIResource
    extends QuaquaScrollPaneBorder
    implements javax.swing.plaf.UIResource {
        public UIResource(String scrollPaneImagesLocation, String textFieldImagesLocation) {
            super(scrollPaneImagesLocation, textFieldImagesLocation);
        }
    }
}

