/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.AttributedCharacterIterator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SpinnerUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;
import javax.swing.text.InternationalFormatter;

public class Quaqua14SpinnerUI
extends BasicSpinnerUI
implements VisuallyLayoutable {
    private static final PropertyChangeListener propertyChangeListener = new PropertyChangeHandler();
    private static final ArrowButtonHandler nextButtonHandler = new ArrowButtonHandler("increment", true);
    private static final ArrowButtonHandler previousButtonHandler = new ArrowButtonHandler("decrement", false);
    private static final Dimension zeroSize = new Dimension(0, 0);

    public static ComponentUI createUI(JComponent c) {
        return new Quaqua14SpinnerUI();
    }

    protected Component createPreviousButton() {
        JButton button = this.createArrowButton(1, previousButtonHandler);
        button.setIcon(UIManager.getIcon("Spinner.south"));
        return button;
    }

    protected Component createNextButton() {
        JButton button = this.createArrowButton(1, nextButtonHandler);
        button.setIcon(UIManager.getIcon("Spinner.north"));
        return button;
    }

    private JButton createArrowButton(int direction, ArrowButtonHandler handler) {
        JButton b = new JButton();
        b.setBorderPainted(false);
        b.setMargin(new Insets(0, 0, 0, 0));
        b.addActionListener(handler);
        b.addMouseListener(handler);
        b.setFocusable(false);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            b.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            b.setBorder(buttonBorder);
        }
        b.putClientProperty("Quaqua.Component.visualMargin", new Insets(0, 0, 0, 3));
        return b;
    }

    protected LayoutManager createLayout() {
        return new SpinnerLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private void updateEnabledState() {
        this.updateEnabledState(this.spinner, this.spinner.isEnabled());
    }

    private void updateEnabledState(Container c, boolean enabled) {
        for (int counter = c.getComponentCount() - 1; counter >= 0; --counter) {
            Component child = c.getComponent(counter);
            child.setEnabled(enabled);
            if (!(child instanceof Container)) continue;
            this.updateEnabledState((Container)child, enabled);
        }
    }

    private void updateFont() {
        Font f = this.spinner.getFont();
        JComponent editor = this.spinner.getEditor();
        editor.setFont(f);
        for (int i = 0; i < editor.getComponentCount(); ++i) {
            editor.getComponent(i).setFont(f);
        }
        if (f.getSize() <= 11) {
            this.getNextButton().setIcon(UIManager.getIcon("Spinner.smallNorth"));
            this.getPreviousButton().setIcon(UIManager.getIcon("Spinner.smallSouth"));
        } else {
            this.getNextButton().setIcon(UIManager.getIcon("Spinner.north"));
            this.getPreviousButton().setIcon(UIManager.getIcon("Spinner.south"));
        }
    }

    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        this.maybeRemoveEditorBorder(editor);
        this.installEditorBorderListener(editor);
        this.installEditorFocusInputMap(editor);
        return editor;
    }

    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        this.maybeRemoveEditorBorder(newEditor);
        this.installEditorBorderListener(newEditor);
        this.installEditorFocusInputMap(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private void installEditorBorderListener(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null && (editor.getBorder() == null || editor.getBorder() instanceof UIResource)) {
                editor.addPropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void removeEditorBorderListener(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null) {
                editor.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }

    private void installEditorFocusInputMap(JComponent editor) {
        if (editor instanceof JPanel && editor.getComponentCount() > 0) {
            editor = (JComponent)editor.getComponent(0);
        }
        if (editor != null) {
            InputMap iMap = this.getInputMap(0);
            SwingUtilities.replaceUIInputMap(editor, 0, iMap);
        }
    }

    private InputMap getInputMap(int condition) {
        switch (condition) {
            case 1: {
                return (InputMap)UIManager.get("Spinner.ancestorInputMap");
            }
            case 0: {
                return (InputMap)UIManager.get("Spinner.focusInputMap");
            }
        }
        return null;
    }

    private JButton getNextButton() {
        return (JButton)((SpinnerLayout)this.spinner.getLayout()).nextButton;
    }

    private JButton getPreviousButton() {
        return (JButton)((SpinnerLayout)this.spinner.getLayout()).previousButton;
    }

    private JComponent getEditor() {
        return (JComponent)((SpinnerLayout)this.spinner.getLayout()).editor;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Debug.paint(g, c, this);
    }

    private void maybeRemoveEditorBorder(JComponent editor) {
        if (!UIManager.getBoolean("Spinner.editorBorderPainted")) {
            if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
                editor = (JComponent)editor.getComponent(0);
            }
            if (editor != null && editor.getBorder() instanceof UIResource) {
                editor.setBorder(null);
            }
        }
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        QuaquaUtilities.installProperty(c, "opaque", UIManager.get("Spinner.opaque"));
        this.updateFont();
    }

    protected void installListeners() {
        this.spinner.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.spinner.removePropertyChangeListener(propertyChangeListener);
        this.removeEditorBorderListener(this.spinner.getEditor());
    }

    protected Insets getMargin() {
        Insets margin = (Insets)this.spinner.getClientProperty("Quaqua.Component.visualMargin");
        if (margin == null) {
            margin = UIManager.getInsets("Component.visualMargin");
        }
        return (Insets)margin.clone();
    }

    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    public Rectangle getVisualBounds(JComponent c, int layoutType, int width, int height) {
        Rectangle bounds = new Rectangle(0, 0, width, height);
        if (layoutType == 0) {
            return bounds;
        }
        switch (layoutType) {
            case 1: {
                Insets margin = this.getMargin();
                bounds.x += margin.left;
                bounds.y += margin.top;
                bounds.width -= margin.left + margin.right;
                bounds.height -= margin.top + margin.bottom;
                break;
            }
            case 2: {
                int editorWidth;
                JComponent editor = this.getEditor();
                if (editor instanceof JPanel) {
                    editor = (JComponent)editor.getComponent(0);
                }
                Object ui = Methods.invokeGetter((Object)editor, "getUI", null);
                Insets insets = this.spinner.getInsets();
                int editorHeight = height - (insets.top + insets.bottom);
                Dimension nextD = this.getNextButton().getPreferredSize();
                Dimension previousD = this.getPreviousButton().getPreferredSize();
                int buttonsWidth = Math.max(nextD.width, previousD.width);
                Insets buttonInsets = new Insets(0, 0, 0, 0);
                if (this.spinner.getComponentOrientation().isLeftToRight()) {
                    int editorX = insets.left;
                    editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                    int buttonsX = width - buttonsWidth - buttonInsets.right;
                } else {
                    int buttonsX = buttonInsets.left;
                    int editorX = buttonsX + buttonsWidth;
                    editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
                }
                int previousY = insets.top + editorHeight / 2;
                int nextY = previousY - nextD.height;
                if (!(ui instanceof VisuallyLayoutable)) break;
                Rectangle editorBounds = ((VisuallyLayoutable)ui).getVisualBounds(editor, layoutType, editorWidth, editorHeight);
                bounds.x += editorBounds.x;
                bounds.y += editorBounds.y;
                bounds.width = editorBounds.width;
                bounds.height = editorBounds.height;
            }
        }
        return bounds;
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JSpinner spinner;
            SpinnerUI spinnerUI;
            JComponent c;
            String name = e.getPropertyName();
            if (e.getSource() instanceof JSpinner) {
                JSpinner spinner2 = (JSpinner)e.getSource();
                SpinnerUI spinnerUI2 = spinner2.getUI();
                if (spinnerUI2 instanceof Quaqua14SpinnerUI) {
                    Quaqua14SpinnerUI ui = (Quaqua14SpinnerUI)spinnerUI2;
                    if ("editor".equals(name)) {
                        JComponent oldEditor = (JComponent)e.getOldValue();
                        JComponent newEditor = (JComponent)e.getNewValue();
                        ui.replaceEditor(oldEditor, newEditor);
                        ui.updateEnabledState();
                        ui.updateFont();
                    } else if ("enabled".equals(name)) {
                        ui.updateEnabledState();
                    } else if ("font".equals(name)) {
                        ui.updateFont();
                    } else if (name.equals("JComponent.sizeVariant")) {
                        QuaquaUtilities.applySizeVariant(spinner2);
                    }
                }
            } else if (e.getSource() instanceof JComponent && (c = (JComponent)e.getSource()).getParent() instanceof JPanel && c.getParent().getParent() instanceof JSpinner && "border".equals(name) && (spinnerUI = (spinner = (JSpinner)c.getParent().getParent()).getUI()) instanceof BasicSpinnerUI) {
                Quaqua14SpinnerUI ui = (Quaqua14SpinnerUI)spinnerUI;
                ui.maybeRemoveEditorBorder(c);
            }
        }
    }

    private static class SpinnerLayout
    implements LayoutManager {
        Component nextButton = null;
        Component previousButton = null;
        Component editor = null;

        private SpinnerLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
            if ("Next".equals(name)) {
                this.nextButton = c;
            } else if ("Previous".equals(name)) {
                this.previousButton = c;
            } else if ("Editor".equals(name)) {
                this.editor = c;
            }
        }

        public void removeLayoutComponent(Component c) {
            if (c == this.nextButton) {
                c = null;
            } else if (c == this.previousButton) {
                this.previousButton = null;
            } else if (c == this.editor) {
                this.editor = null;
            }
        }

        private Dimension preferredSize(Component c) {
            return c == null ? zeroSize : c.getPreferredSize();
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            Dimension editorD = this.preferredSize(this.editor);
            Dimension size = new Dimension(editorD.width, editorD.height);
            size.width += Math.max(nextD.width, previousD.width) - 1;
            Insets insets = parent.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        private void setBounds(Component c, int x, int y, int width, int height) {
            if (c != null) {
                c.setBounds(x, y, width, height);
            }
        }

        public void layoutContainer(Container parent) {
            int buttonsX;
            int editorWidth;
            int editorX;
            int width = parent.getWidth();
            int height = parent.getHeight();
            Insets insets = parent.getInsets();
            Dimension nextD = this.preferredSize(this.nextButton);
            Dimension previousD = this.preferredSize(this.previousButton);
            int buttonsWidth = Math.max(nextD.width, previousD.width);
            int editorHeight = height - (insets.top + insets.bottom);
            Insets buttonInsets = UIManager.getInsets("Spinner.arrowButtonInsets");
            if (buttonInsets == null) {
                buttonInsets = insets;
            }
            if (parent.getComponentOrientation().isLeftToRight()) {
                editorX = insets.left;
                editorWidth = width - insets.left - buttonsWidth - buttonInsets.right;
                buttonsX = width - buttonsWidth - buttonInsets.right;
            } else {
                buttonsX = buttonInsets.left;
                editorX = buttonsX + buttonsWidth;
                editorWidth = width - buttonInsets.left - buttonsWidth - insets.right;
            }
            int previousY = insets.top + editorHeight / 2;
            int nextY = previousY - nextD.height;
            this.setBounds(this.editor, editorX, insets.top, editorWidth + 1, editorHeight);
            this.setBounds(this.nextButton, buttonsX, nextY, nextD.width, nextD.height);
            this.setBounds(this.previousButton, buttonsX, previousY, previousD.width, previousD.height);
        }
    }

    private static class ArrowButtonHandler
    extends AbstractAction
    implements MouseListener,
    UIResource {
        final Timer autoRepeatTimer;
        final boolean isNext;
        JSpinner spinner = null;

        ArrowButtonHandler(String name, boolean isNext) {
            super(name);
            this.isNext = isNext;
            this.autoRepeatTimer = new Timer(60, this);
            this.autoRepeatTimer.setInitialDelay(300);
        }

        private JSpinner eventToSpinner(AWTEvent e) {
            Object src = e.getSource();
            while (src instanceof Component && !(src instanceof JSpinner)) {
                src = ((Component)src).getParent();
            }
            return src instanceof JSpinner ? (JSpinner)src : null;
        }

        public void actionPerformed(ActionEvent e) {
            JSpinner spinner = this.spinner;
            if (!(e.getSource() instanceof Timer)) {
                spinner = this.eventToSpinner(e);
            }
            if (spinner != null) {
                try {
                    Object value;
                    int calendarField = this.getCalendarField(spinner);
                    spinner.commitEdit();
                    if (calendarField != -1) {
                        ((SpinnerDateModel)spinner.getModel()).setCalendarField(calendarField);
                    }
                    Object object = value = this.isNext ? spinner.getNextValue() : spinner.getPreviousValue();
                    if (value != null) {
                        spinner.setValue(value);
                        this.select(spinner);
                    }
                }
                catch (IllegalArgumentException iae) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
                catch (ParseException pe) {
                    UIManager.getLookAndFeel().provideErrorFeedback(spinner);
                }
            }
        }

        private void select(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                SpinnerDateModel model;
                DateFormat.Field field;
                Object value;
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                SimpleDateFormat format = dateEditor.getFormat();
                if (format != null && (value = spinner.getValue()) != null && (field = DateFormat.Field.ofCalendarField((model = dateEditor.getModel()).getCalendarField())) != null) {
                    try {
                        AttributedCharacterIterator iterator = ((Format)format).formatToCharacterIterator(value);
                        if (!this.select(ftf, iterator, field) && field == DateFormat.Field.HOUR0) {
                            this.select(ftf, iterator, DateFormat.Field.HOUR1);
                        }
                    }
                    catch (IllegalArgumentException iae) {
                        // empty catch block
                    }
                }
            }
        }

        private boolean select(JFormattedTextField ftf, AttributedCharacterIterator iterator, DateFormat.Field field) {
            int max = ftf.getDocument().getLength();
            iterator.first();
            do {
                Map<AttributedCharacterIterator.Attribute, Object> attrs;
                if ((attrs = iterator.getAttributes()) == null || !attrs.containsKey(field)) continue;
                int start = iterator.getRunStart(field);
                int end = iterator.getRunLimit(field);
                if (start != -1 && end != -1 && start <= max && end <= max) {
                    ftf.select(start, end);
                }
                return true;
            } while (iterator.next() != '\uffff');
            return false;
        }

        private int getCalendarField(JSpinner spinner) {
            JComponent editor = spinner.getEditor();
            if (editor instanceof JSpinner.DateEditor) {
                JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)editor;
                JFormattedTextField ftf = dateEditor.getTextField();
                int start = ftf.getSelectionStart();
                JFormattedTextField.AbstractFormatter formatter = ftf.getFormatter();
                if (formatter instanceof InternationalFormatter) {
                    Format.Field[] fields = ((InternationalFormatter)formatter).getFields(start);
                    for (int counter = 0; counter < fields.length; ++counter) {
                        int calendarField;
                        if (!(fields[counter] instanceof DateFormat.Field) || (calendarField = fields[counter] == DateFormat.Field.HOUR1 ? 10 : ((DateFormat.Field)fields[counter]).getCalendarField()) == -1) continue;
                        return calendarField;
                    }
                }
            }
            return -1;
        }

        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getComponent().isEnabled()) {
                this.spinner = this.eventToSpinner(e);
                this.autoRepeatTimer.start();
                this.focusSpinnerIfNecessary();
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.autoRepeatTimer.stop();
            this.spinner = null;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void focusSpinnerIfNecessary() {
            Component fo = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (this.spinner.isRequestFocusEnabled() && (fo == null || !SwingUtilities.isDescendingFrom(fo, this.spinner))) {
                FocusTraversalPolicy ftp;
                Component child;
                Container root = this.spinner;
                if (!root.isFocusCycleRoot()) {
                    root = root.getFocusCycleRootAncestor();
                }
                if (root != null && (child = (ftp = root.getFocusTraversalPolicy()).getComponentAfter(root, this.spinner)) != null && SwingUtilities.isDescendingFrom(child, this.spinner)) {
                    child.requestFocus();
                }
            }
        }
    }
}

