/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.Theme;
import processing.app.debug.MessageConsumer;

public class SerialMonitor
extends JFrame
implements MessageConsumer {
    private Serial serial;
    private String port;
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private JTextField textField;
    private JButton sendButton;
    private JCheckBox autoscrollBox;
    private JComboBox lineEndings;
    private JComboBox serialRates;
    private int serialRate;

    public SerialMonitor(String string) {
        super(string);
        this.port = string;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SerialMonitor.this.closeSerialPort();
            }
        });
        KeyStroke keyStroke = Editor.WINDOW_CLOSE_KEYSTROKE;
        this.getRootPane().getInputMap(1).put(keyStroke, "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.closeSerialPort();
                SerialMonitor.this.setVisible(false);
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        Font font = Theme.getFont("console.font");
        this.textArea = new JTextArea(16, 40);
        this.textArea.setEditable(false);
        this.textArea.setFont(font);
        ((DefaultCaret)this.textArea.getCaret()).setUpdatePolicy(1);
        this.scrollPane = new JScrollPane(this.textArea);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.textField = new JTextField(40);
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        this.sendButton = new JButton("Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SerialMonitor.this.send(SerialMonitor.this.textField.getText());
                SerialMonitor.this.textField.setText("");
            }
        });
        jPanel.add(this.textField);
        jPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        jPanel.add(this.sendButton);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.autoscrollBox = new JCheckBox("Autoscroll", true);
        this.lineEndings = new JComboBox<String>(new String[]{"No line ending", "Newline", "Carriage return", "Both NL & CR"});
        this.lineEndings.setMaximumSize(this.lineEndings.getMinimumSize());
        String[] stringArray = new String[]{"300", "1200", "2400", "4800", "9600", "14400", "19200", "28800", "38400", "57600", "115200"};
        this.serialRates = new JComboBox();
        for (int i = 0; i < stringArray.length; ++i) {
            this.serialRates.addItem(stringArray[i] + " baud");
        }
        this.serialRate = Preferences.getInteger("serial.debug_rate");
        this.serialRates.setSelectedItem(this.serialRate + " baud");
        this.serialRates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)SerialMonitor.this.serialRates.getSelectedItem();
                String string2 = string.substring(0, string.indexOf(32));
                SerialMonitor.this.serialRate = Integer.parseInt(string2);
                Preferences.set("serial.debug_rate", string2);
                SerialMonitor.this.closeSerialPort();
                try {
                    SerialMonitor.this.openSerialPort();
                }
                catch (SerialException serialException) {
                    System.err.println(serialException);
                }
            }
        });
        this.serialRates.setMaximumSize(this.serialRates.getMinimumSize());
        jPanel.add(this.autoscrollBox);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.lineEndings);
        jPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        jPanel.add(this.serialRates);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
    }

    private void send(String string) {
        if (this.serial != null) {
            switch (this.lineEndings.getSelectedIndex()) {
                case 1: {
                    string = string + "\n";
                    break;
                }
                case 2: {
                    string = string + "\r";
                    break;
                }
                case 3: {
                    string = string + "\r\n";
                }
            }
            this.serial.write(string);
        }
    }

    public void openSerialPort() throws SerialException {
        if (this.serial != null) {
            return;
        }
        this.serial = new Serial(this.port, this.serialRate);
        this.serial.addListener(this);
    }

    public void closeSerialPort() {
        if (this.serial != null) {
            this.textArea.setText("");
            this.serial.dispose();
            this.serial = null;
        }
    }

    public void message(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SerialMonitor.this.textArea.append(string);
                if (SerialMonitor.this.autoscrollBox.isSelected()) {
                    SerialMonitor.this.textArea.setCaretPosition(SerialMonitor.this.textArea.getDocument().getLength());
                }
            }
        });
    }
}

