/* $Id: SampleConfigXMLMapperTest.java,v 1.4 2005/04/09 05:16:10 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.consumer.util.configuration;


import junit.framework.TestCase;

/**
 * 
 */
public class SampleConfigXMLMapperTest extends TestCase{
	
	private SampleConfigXMLMapper explParser;
	private SampleConfigXMLMapper implParser;
	private SpecSamplingConfig explConf;	
	private SpecSamplingConfig implConf;
	
	public final static String REF_EXPLICITCONFIG_PATH =  "classpath:tsp/consumer/util/configuration/explicit.xml";
	
	public void setUp() throws Exception {
		
		explParser = new SampleConfigXMLMapper();		
		//explConf  = explParser.createSpecSamplingConfig(getClass().getResourceAsStream("explicit.xml"));
		explConf  = explParser.createSpecSamplingConfig(REF_EXPLICITCONFIG_PATH);
		
		/*implParser = new SampleConfigXMLMapper();		
		implConf  = explParser.createSpecSamplingConfig(getClass().getResourceAsStream("implicit.xml"));*/
		
		
	}
	
		
	
	public void testReadSampleConfigInfo() throws Exception{			
		assertEquals("TSPcfg-1.0", explConf.getVersion());
		assertTrue(explConf.getComment().indexOf("This") != -1);
		assertTrue(explConf.getComment().indexOf("Consumer") != -1);
	}
	
	public void testReadProviderLists() throws Exception{			
		assertEquals(explConf.getProviderLists().size(),1);
		SpecProviderList pList = (SpecProviderList)explConf.getProviderLists().get(0);
		assertEquals(pList.getImplicitProvider(), ImplicitProviderEnum.NONE );
		
		assertEquals(pList.getProviders().size(),3);
		
		SpecProvider p = (SpecProvider)pList.getProviders().get(0);
		assertEquals("Stub1", p.getName() );
		assertEquals( "rpc://localhost/Stubber", p.getUrl());
		assertNull(p.getImplicitPeriod());
		assertTrue(p.getDescription().indexOf("You may describe") != -1);
		
		p = (SpecProvider)pList.getProviders().get(1);
		assertEquals("Stub2", p.getName() );
		assertEquals( "xmlrpc://localhost/Stubber", p.getUrl());
		assertEquals(new Integer(2), p.getImplicitPeriod());
		assertEquals("", p.getDescription());
		
		p = (SpecProvider)pList.getProviders().get(2);
		assertEquals("BB1", p.getName() );
		assertEquals( "rpc://localhost/BB_provider", p.getUrl());
		assertNull(p.getImplicitPeriod());
		assertTrue(p.getDescription().indexOf("great") != -1);
	}
	
	public void testReadSampleLists() throws Exception{			
		assertEquals(explConf.getSampleLists().size(),1);
		SpecSampleList sList = (SpecSampleList)explConf.getSampleLists().get(0);
		assertEquals(sList.getImplicitPeriod(), new Integer(1));
		
		SpecSample s = (SpecSample)sList.getSamples().get(0);
		assertEquals("Symbol1", s.getName());
		assertEquals("S1", s.getReNamed());
		assertEquals(VarTypeEnum.DOUBLE, s.getType());
		assertEquals("Stub1", s.getProvider().getName());
		assertEquals(2, s.getPeriod());
		assertTrue(s.getDescription().indexOf("Stub1") != -1);
		
		s = (SpecSample)sList.getSamples().get(1);
		assertEquals("Symbol3", s.getName());
		assertNull(s.getReNamed());
		assertNull(s.getType());
		assertEquals("Stub2", s.getProvider().getName());
		assertEquals(1, s.getPeriod());
		assertTrue(s.getDescription().indexOf("forever") != -1);
		
		s = (SpecSample)sList.getSamples().get(2);
		assertEquals("bb_test_Titi", s.getName());
		assertNull(s.getReNamed());
		assertNull(s.getType());
		assertEquals("BB1", s.getProvider().getName());
		assertEquals(1, s.getPeriod());
		assertEquals("",s.getDescription());
		
		
	}

	
}
