/* $Id: TspSimpleSession.java,v 1.4 2005/10/05 00:11:47 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.consumer.simple;

import java.util.NoSuchElementException;


import tsp.core.consumer.TspConsumerException;


public interface TspSimpleSession {
	public TspSimpleAnswerSample requestInfos() throws TspConsumerException;

	/**
	 * Send a TSP request sample on an opened session.
	 * @req the TSP request Sample
	 */
	public TspSimpleAnswerSample requestSample(TspSimpleRequestSample req)
			throws TspConsumerException;

	/**
	 * Send a TSP request sample Init on an opened session.
	 * This ask for beginning the sample process and 
	 * to open the socket for receiving sample.
	 */
	public void requestSampleInit() throws TspConsumerException;

	public void requestSampleFinalize() throws TspConsumerException;

	public void fetchSample(TspSimpleSample sample) throws NoSuchElementException;

	public void waitForData();

	public boolean isDataAvailable();

	/**
	 * Close the session
	 * @throws TspConsumerException
	 */
	public void close() throws TspConsumerException;
}