/* $Id: TspAnswerSample.java,v 1.3 2006/06/04 16:39:42 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.common;

import java.io.PrintStream;
import java.util.Hashtable;

import tsp.core.rpc.TSP_answer_sample_t;
import tsp.core.rpc.TSP_sample_symbol_info_t;

public class TspAnswerSample  extends TspAnswer {

    public TSP_answer_sample_t theAnswer;
    private TspSampleSymbols   samples;
    private Hashtable          pgiHash;


    public TspAnswerSample(TSP_answer_sample_t answer) {
	   theAnswer = answer;
       samples = new TspSampleSymbols(answer.symbols.value);
       pgiHash = new Hashtable();
       for (int i=0;i<answer.symbols.value.length;++i) {
           pgiHash.put(new Integer(answer.symbols.value[i].provider_global_index),
                   answer.symbols.value[i]);
       }
    }
    
    public int getTspStatus() {	
		return theAnswer.status;
	}


	public int getTspVersion() {
		return theAnswer.version_id;
	}

    public TSP_sample_symbol_info_t[] getTspSSIArray() {
	return theAnswer.symbols.value;
    }
    
    public int[] getTspPGIArray() {

    	int[] pgiArray = new int[theAnswer.symbols.value.length];
    	for (int i=0;i<theAnswer.symbols.value.length;i++)
    		pgiArray[i] = theAnswer.symbols.value[i].provider_global_index;
  
    	return pgiArray;
    }
    

    public TSP_sample_symbol_info_t getSSIByPGI(int pgi) throws TspException {
       TSP_sample_symbol_info_t retval;
       retval = (TSP_sample_symbol_info_t) pgiHash.get(new Integer(pgi));
       if (null==retval) {
           throw new TspException("Invalid PGI  <"+pgi+">");
       }
       return retval;
    }
    /**
     * Print the contents of the answer 
     * on a PrintStream.
     */ 
    public void print(PrintStream printStream)  {
	
// 	String prefix ="";
// 	String prefix1;
// 	for (int i=0; i<tsp.util.FieldPrinter.level; ++i) {
// 	    prefix = prefix+tsp.util.FieldPrinter.tab;
// 	}       
// 	prefix1 = prefix;
// 	printStream.println(prefix1+"<class name=tsp.core.rpc.TspAnswerSample>");
// 	printStream.println(prefix+"<field name=theAnswer type=TSP_answer_sample_t>");
// 	prefix = prefix+tsp.util.FieldPrinter.tab;
// 	printStream.println(prefix+"<class name=tsp.core.rpc.TSP_sample_symbol_info_t>");
// 	printStream.println(prefix+"<field name=name value="
	
	tsp.util.FieldPrinter.printField(this, printStream);
// 	printStream.println(prefix+"</class>");	
// 	printStream.println(prefix1+"</class>");
			    
    }
}
// End of TspAnswerSample.java
