/* $Id: TspAnswerOpen.java,v 1.2 2006/06/04 16:39:42 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.common;

import java.io.PrintStream;

import tsp.core.rpc.TSP_answer_open_t;

public class TspAnswerOpen  extends TspAnswer {

    public TSP_answer_open_t theAnswer;

    public TspAnswerOpen(TSP_answer_open_t answer) {
	   theAnswer = answer;
    }

    
    public int getTspStatus() {	
		return theAnswer.status;
	}


	public int getTspVersion() {
		return theAnswer.version_id;
	}


	/**
     * Print the contents of the answer 
     * on a PrintStream.
     */ 
    public void print(PrintStream printStream)  {

	tsp.util.FieldPrinter.printField(this, printStream);
    }
}
// End of TspAnswerOpen.java
