/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.input.DefaultInputHandler;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Main {
    public static final String DEFAULT_BUILD_FILENAME = "build.xml";
    private int msgOutputLevel = 2;
    private File buildFile;
    private static PrintStream out;
    private static PrintStream err;
    private Vector targets = new Vector<E>(5);
    private Properties definedProps = new Properties();
    private Vector listeners = new Vector<E>(5);
    private Vector propertyFiles = new Vector<E>(5);
    private String loggerClassname = null;
    private String inputHandlerClassname = null;
    private boolean emacsMode = false;
    private boolean readyToRun = false;
    private boolean projectHelp = false;
    private static boolean isLogFileUsed;
    private static String antVersion;
    static /* synthetic */ Class class$org$apache$tools$ant$Main;

    private static void printMessage(Throwable t) {
        String message = t.getMessage();
        if (message != null) {
            System.err.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void start(String[] args, Properties additionalUserProperties, ClassLoader coreLoader) {
        block28: {
            Exception e3222;
            block29: {
                Main m = null;
                try {
                    Diagnostics.validateVersion();
                    m = new Main(args);
                }
                catch (Throwable exc) {
                    Main.printMessage(exc);
                    System.exit(1);
                }
                if (additionalUserProperties != null) {
                    Enumeration e2 = ((Hashtable)additionalUserProperties).keys();
                    while (e2.hasMoreElements()) {
                        String key = (String)e2.nextElement();
                        String property = additionalUserProperties.getProperty(key);
                        ((Hashtable)m.definedProps).put(key, property);
                    }
                }
                m.runBuild(coreLoader);
                System.exit(0);
                Object var8_10 = null;
                if (!isLogFileUsed) break block28;
                if (out == null) break block29;
                try {
                    out.close();
                }
                catch (Exception e3222) {
                    // empty catch block
                }
            }
            if (err != null) {
                try {
                    err.close();
                }
                catch (Exception e3222) {}
            }
            break block28;
            {
                catch (BuildException be) {
                    Exception e3222;
                    if (err != System.err) {
                        Main.printMessage(be);
                    }
                    System.exit(1);
                    Object var8_11 = null;
                    if (!isLogFileUsed) break block28;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e3222) {
                            // empty catch block
                        }
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Exception e3222) {}
                    }
                    break block28;
                }
                catch (Throwable exc) {
                    Exception e3222;
                    exc.printStackTrace();
                    Main.printMessage(exc);
                    System.exit(1);
                    Object var8_12 = null;
                    if (!isLogFileUsed) break block28;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e3222) {
                            // empty catch block
                        }
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Exception e3222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (isLogFileUsed) {
                    Exception e3222;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e3222) {
                            // empty catch block
                        }
                    }
                    if (err != null) {
                        try {
                            err.close();
                        }
                        catch (Exception e3222) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        Main.start(args, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Main(String[] args) throws BuildException {
        super();
        searchForThis = null;
        logTo = null;
        i = 0;
        while (i < args.length) {
            arg = args[i];
            if (arg.equals("-help")) {
                Main.printUsage();
                return;
            }
            if (arg.equals("-version")) {
                Main.printVersion();
                return;
            }
            if (arg.equals("-diagnostics")) {
                Diagnostics.doReport(System.out);
                return;
            }
            if (arg.equals("-quiet") || arg.equals("-q")) {
                this.msgOutputLevel = 1;
            } else if (arg.equals("-verbose") || arg.equals("-v")) {
                Main.printVersion();
                this.msgOutputLevel = 3;
            } else if (arg.equals("-debug")) {
                Main.printVersion();
                this.msgOutputLevel = 4;
            } else if (arg.equals("-logfile") || arg.equals("-l")) {
                try {
                    logFile = new File(args[i + 1]);
                    ++i;
                    logTo = new PrintStream(new FileOutputStream(logFile));
                    Main.isLogFileUsed = true;
                }
                catch (IOException ioe) {
                    msg = "Cannot write on the specified log file. Make sure the path exists and you have write permissions.";
                    System.out.println(msg);
                    return;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a log file when using the -log argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-buildfile") || arg.equals("-file") || arg.equals("-f")) {
                try {
                    this.buildFile = new File(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a buildfile when using the -buildfile argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.equals("-listener")) {
                try {
                    this.listeners.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a classname when using the -listener argument";
                    System.out.println(msg);
                    return;
                }
            } else if (arg.startsWith("-D")) {
                name = arg.substring(2, arg.length());
                value = null;
                posEq = name.indexOf("=");
                if (posEq > 0) {
                    value = name.substring(posEq + 1);
                    name = name.substring(0, posEq);
                } else if (i < args.length - 1) {
                    value = args[++i];
                }
                this.definedProps.put(name, value);
            } else if (arg.equals("-logger")) {
                if (this.loggerClassname != null) {
                    System.out.println("Only one logger class may  be specified.");
                    return;
                }
                try {
                    this.loggerClassname = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("You must specify a classname when using the -logger argument");
                    return;
                }
            } else if (arg.equals("-inputhandler")) {
                if (this.inputHandlerClassname != null) {
                    System.out.println("Only one input handler class may be specified.");
                    return;
                }
                try {
                    this.inputHandlerClassname = args[++i];
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("You must specify a classname when using the -inputhandler argument");
                    return;
                }
            } else if (arg.equals("-emacs")) {
                this.emacsMode = true;
            } else if (arg.equals("-projecthelp")) {
                this.projectHelp = true;
            } else if (arg.equals("-find")) {
                searchForThis = i < args.length - 1 ? args[++i] : "build.xml";
            } else if (arg.startsWith("-propertyfile")) {
                try {
                    this.propertyFiles.addElement(args[i + 1]);
                    ++i;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    msg = "You must specify a property filename when using the -propertyfile argument";
                    System.out.println(msg);
                    return;
                }
            } else {
                if (arg.startsWith("-")) {
                    msg = "Unknown argument: " + arg;
                    System.out.println(msg);
                    Main.printUsage();
                    return;
                }
                this.targets.addElement(arg);
            }
            ++i;
        }
        if (this.buildFile == null) {
            this.buildFile = searchForThis != null ? this.findBuildFile(System.getProperty("user.dir"), searchForThis) : new File("build.xml");
        }
        if (!this.buildFile.exists()) {
            System.out.println("Buildfile: " + this.buildFile + " does not exist!");
            throw new BuildException("Build failed");
        }
        if (this.buildFile.isDirectory()) {
            System.out.println("What? Buildfile: " + this.buildFile + " is a dir!");
            throw new BuildException("Build failed");
        }
        propertyFileIndex = 0;
        while (propertyFileIndex < this.propertyFiles.size()) {
            block67: {
                filename = (String)this.propertyFiles.elementAt(propertyFileIndex);
                props = new Properties();
                fis = null;
                try {
                    fis = new FileInputStream(filename);
                    props.load(fis);
                    var11_23 = null;
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var10_22) {
                    var11_23 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    throw var10_22;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block67;
                    catch (IOException e) {
                        System.out.println("Could not load property file " + filename + ": " + e.getMessage());
                        var11_23 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
            }
            propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                name = (String)propertyNames.nextElement();
                if (this.definedProps.getProperty(name) != null) continue;
                this.definedProps.put(name, props.getProperty(name));
            }
            ++propertyFileIndex;
        }
        if (this.msgOutputLevel >= 2) {
            System.out.println("Buildfile: " + this.buildFile);
        }
        if (logTo != null) {
            Main.out = Main.err = logTo;
            System.setOut(Main.out);
            System.setErr(Main.out);
        }
        this.readyToRun = true;
    }

    private File getParentFile(File file) {
        String filename = file.getAbsolutePath();
        file = new File(filename);
        if ((filename = file.getParent()) != null && this.msgOutputLevel >= 3) {
            System.out.println("Searching in " + filename);
        }
        return filename == null ? null : new File(filename);
    }

    private File findBuildFile(String start, String suffix) throws BuildException {
        if (this.msgOutputLevel >= 2) {
            System.out.println("Searching for " + suffix + " ...");
        }
        File parent = new File(new File(start).getAbsolutePath());
        File file = new File(parent, suffix);
        while (!file.exists()) {
            if ((parent = this.getParentFile(parent)) == null) {
                throw new BuildException("Could not locate a build file!");
            }
            file = new File(parent, suffix);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void runBuild(ClassLoader coreLoader) throws BuildException {
        if (!this.readyToRun) {
            return;
        }
        Project project = new Project();
        project.setCoreLoader(coreLoader);
        Throwable throwable = null;
        try {
            SecurityManager oldsm;
            PrintStream out;
            PrintStream err;
            try {
                block15: {
                    this.addBuildListeners(project);
                    this.addInputHandler(project);
                    err = System.err;
                    out = System.out;
                    oldsm = null;
                    if (!JavaEnvUtils.isJavaVersion("1.0") && !JavaEnvUtils.isJavaVersion("1.1")) {
                        oldsm = System.getSecurityManager();
                    }
                    System.setOut(new PrintStream(new DemuxOutputStream(project, false)));
                    System.setErr(new PrintStream(new DemuxOutputStream(project, true)));
                    if (!this.projectHelp) {
                        project.fireBuildStarted();
                    }
                    project.init();
                    project.setUserProperty("ant.version", Main.getAntVersion());
                    Enumeration e = ((Hashtable)this.definedProps).keys();
                    while (e.hasMoreElements()) {
                        String arg = (String)e.nextElement();
                        String value = (String)((Hashtable)this.definedProps).get(arg);
                        project.setUserProperty(arg, value);
                    }
                    project.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
                    ProjectHelper.configureProject(project, this.buildFile);
                    if (!this.projectHelp) break block14;
                    Main.printDescription(project);
                    Main.printTargets(project, this.msgOutputLevel > 2);
                    Object var11_14 = null;
                    if (oldsm == null) break block15;
                    System.setSecurityManager(oldsm);
                }
                System.setOut(out);
                System.setErr(err);
                Object var13_17 = null;
                if (this.projectHelp) return;
            }
            catch (RuntimeException exc) {
                RuntimeException runtimeException = exc;
                throw exc;
            }
            catch (Error err2) {
                Error error = err2;
                throw err2;
            }
            project.fireBuildFinished(throwable);
            {
                block16: {
                    block14: {
                        return;
                    }
                    try {
                        if (this.targets.size() == 0) {
                            this.targets.addElement(project.getDefaultTarget());
                        }
                        project.executeTargets(this.targets);
                        Object var11_15 = null;
                        if (oldsm == null) break block16;
                    }
                    catch (Throwable throwable2) {
                        Object var11_16 = null;
                        if (oldsm != null) {
                            System.setSecurityManager(oldsm);
                        }
                        System.setOut(out);
                        System.setErr(err);
                        throw throwable2;
                    }
                    System.setSecurityManager(oldsm);
                }
                System.setOut(out);
                System.setErr(err);
                {
                }
            }
        }
        catch (Throwable throwable3) {
            Object var13_19 = null;
            if (this.projectHelp) throw throwable3;
            project.fireBuildFinished(throwable);
            throw throwable3;
        }
        Object var13_18 = null;
        if (this.projectHelp) return;
        project.fireBuildFinished(throwable);
    }

    protected void addBuildListeners(Project project) {
        project.addBuildListener(this.createLogger());
        int i = 0;
        while (i < this.listeners.size()) {
            String className = (String)this.listeners.elementAt(i);
            try {
                BuildListener listener = (BuildListener)Class.forName(className).newInstance();
                project.addBuildListener(listener);
            }
            catch (Throwable exc) {
                throw new BuildException("Unable to instantiate listener " + className, exc);
            }
            ++i;
        }
    }

    private void addInputHandler(Project project) {
        InputHandler handler = null;
        if (this.inputHandlerClassname == null) {
            handler = new DefaultInputHandler();
        } else {
            try {
                handler = (InputHandler)Class.forName(this.inputHandlerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String msg = "The specified input handler class " + this.inputHandlerClassname + " does not implement the InputHandler interface";
                throw new BuildException(msg);
            }
            catch (Exception e) {
                String msg = "Unable to instantiate specified input handler class " + this.inputHandlerClassname + " : " + e.getClass().getName();
                throw new BuildException(msg);
            }
        }
        project.setInputHandler(handler);
    }

    private BuildLogger createLogger() {
        BuildLogger logger = null;
        if (this.loggerClassname != null) {
            try {
                logger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException e) {
                System.err.println("The specified logger class " + this.loggerClassname + " does not implement the BuildLogger interface");
                throw new RuntimeException();
            }
            catch (Exception e) {
                System.err.println("Unable to instantiate specified logger class " + this.loggerClassname + " : " + e.getClass().getName());
                throw new RuntimeException();
            }
        } else {
            logger = new DefaultLogger();
        }
        logger.setMessageOutputLevel(this.msgOutputLevel);
        logger.setOutputPrintStream(out);
        logger.setErrorPrintStream(err);
        logger.setEmacsMode(this.emacsMode);
        return logger;
    }

    private static void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [options] [target [target2 [target3] ...]]" + lSep);
        msg.append("Options: " + lSep);
        msg.append("  -help                  print this message" + lSep);
        msg.append("  -projecthelp           print project help information" + lSep);
        msg.append("  -version               print the version information and exit" + lSep);
        msg.append("  -diagnostics           print information that might be helpful to" + lSep);
        msg.append("                         diagnose or report problems." + lSep);
        msg.append("  -quiet, -q             be extra quiet" + lSep);
        msg.append("  -verbose, -v           be extra verbose" + lSep);
        msg.append("  -debug                 print debugging information" + lSep);
        msg.append("  -emacs                 produce logging information without adornments" + lSep);
        msg.append("  -logfile <file>        use given file for log" + lSep);
        msg.append("    -l     <file>                ''" + lSep);
        msg.append("  -logger <classname>    the class which is to perform logging" + lSep);
        msg.append("  -listener <classname>  add an instance of class as a project listener" + lSep);
        msg.append("  -buildfile <file>      use given buildfile" + lSep);
        msg.append("    -file    <file>              ''" + lSep);
        msg.append("    -f       <file>              ''" + lSep);
        msg.append("  -D<property>=<value>   use value for given property" + lSep);
        msg.append("  -propertyfile <name>   load all properties from file with -D" + lSep);
        msg.append("                         properties taking precedence" + lSep);
        msg.append("  -inputhandler <class>  the class which will handle input requests" + lSep);
        msg.append("  -find <file>           search for buildfile towards the root of the" + lSep);
        msg.append("                         filesystem and use it" + lSep);
        System.out.println(msg.toString());
    }

    private static void printVersion() throws BuildException {
        System.out.println(Main.getAntVersion());
    }

    public static synchronized String getAntVersion() throws BuildException {
        if (antVersion == null) {
            try {
                Properties props = new Properties();
                InputStream in = (class$org$apache$tools$ant$Main == null ? (class$org$apache$tools$ant$Main = Main.class$("org.apache.tools.ant.Main")) : class$org$apache$tools$ant$Main).getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                StringBuffer msg = new StringBuffer();
                msg.append("Apache Ant version ");
                msg.append(props.getProperty("VERSION"));
                msg.append(" compiled on ");
                msg.append(props.getProperty("DATE"));
                antVersion = msg.toString();
            }
            catch (IOException ioe) {
                throw new BuildException("Could not load the version information:" + ioe.getMessage());
            }
            catch (NullPointerException npe) {
                throw new BuildException("Could not load the version information.");
            }
        }
        return antVersion;
    }

    private static void printDescription(Project project) {
        if (project.getDescription() != null) {
            project.log(project.getDescription());
        }
    }

    private static void printTargets(Project project, boolean printSubTargets) {
        String defaultTarget;
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        Vector<String> topNames = new Vector<String>();
        Vector<String> topDescriptions = new Vector<String>();
        Vector<String> subNames = new Vector<String>();
        while (ptargets.hasMoreElements()) {
            int pos;
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                pos = Main.findTargetPosition(subNames, targetName);
                subNames.insertElementAt(targetName, pos);
                continue;
            }
            pos = Main.findTargetPosition(topNames, targetName);
            topNames.insertElementAt(targetName, pos);
            topDescriptions.insertElementAt(targetDescription, pos);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Main.printTargets(project, topNames, topDescriptions, "Main targets:", maxLength);
        if (topNames.size() == 0) {
            printSubTargets = true;
        }
        if (printSubTargets) {
            Main.printTargets(project, subNames, null, "Subtargets:", 0);
        }
        if ((defaultTarget = project.getDefaultTarget()) != null && !"".equals(defaultTarget)) {
            project.log("Default target: " + defaultTarget);
        }
    }

    private static int findTargetPosition(Vector names, String name) {
        int res = names.size();
        int i = 0;
        while (i < names.size() && res == names.size()) {
            if (name.compareTo((String)names.elementAt(i)) < 0) {
                res = i;
            }
            ++i;
        }
        return res;
    }

    private static void printTargets(Project project, Vector names, Vector descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = spaces + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(heading + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(" ");
            msg.append(names.elementAt(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.elementAt(i)).length() + 2));
                msg.append(descriptions.elementAt(i));
            }
            msg.append(lSep);
            ++i;
        }
        project.log(msg.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_BUILD_FILENAME = DEFAULT_BUILD_FILENAME;
        out = System.out;
        err = System.err;
        isLogFileUsed = false;
        antVersion = null;
    }
}

