/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import java.io.InputStream;
import java.util.TreeMap;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class LocaleDatabase
extends TreeMap {
    public LocaleDatabase(InputStream in) throws Exception {
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setReader(new StdXMLReader(in));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        if (!data.getName().equalsIgnoreCase("langpack")) {
            throw new Exception("this is not an IzPack XML langpack file");
        }
        Vector children = data.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            XMLElement e = (XMLElement)children.get(i);
            String text = e.getContent();
            if (text != null && !text.equals("")) {
                this.put(e.getAttribute("id"), text.trim());
                continue;
            }
            this.put(e.getAttribute("id"), e.getAttribute("txt"));
        }
    }

    public String getString(String key) {
        String val = (String)this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }
}

