/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Toolkit;
import javax.swing.JTextField;

public class NumberField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();

    public NumberField(int n) {
        super(n);
    }

    public NumberField(double d, int n) {
        this(n);
        this.setValue(d);
    }

    public NumberField(long l, int n) {
        this(n);
        this.setValue(l);
    }

    public NumberField(double d) {
        this.setValue(d);
    }

    public NumberField(long l) {
        this.setValue(l);
    }

    public boolean isEmpty() {
        return this.getText().trim().equals("");
    }

    public void setValue(double d) {
        this.setText(String.valueOf(d));
    }

    public void setValue(long l) {
        this.setText(String.valueOf(l));
    }

    public double getDoubleValue() throws NumberFormatException {
        double d = 0.0;
        try {
            d = Double.parseDouble(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.selectAll();
            this.requestFocus();
            this.toolkit.beep();
            throw numberFormatException;
        }
        return d;
    }

    public long getLongValue() throws NumberFormatException {
        long l = 0L;
        try {
            l = Long.decode(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.selectAll();
            this.requestFocus();
            this.toolkit.beep();
            throw numberFormatException;
        }
        return l;
    }
}

