/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes.test;

import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import simtools.data.AsciiFileDataSourceCollection;
import simtools.data.DataException;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.buffer.ResizeableBuffer;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.shapes.CurveShape;
import simtools.shapes.PlotShape;
import simtools.shapes.ShapesContainer;
import simtools.ui.DesktopCardPanel;
import simtools.ui.PrintDialog;

public class TestAscii
extends JFrame
implements ActionListener {
    private static Font _sFont = new Font("TimesRoman", 0, 10);
    private DesktopCardPanel _editorPanel = new DesktopCardPanel(true);
    private JButton _bPrint;
    private JButton _bAdjust;
    private JButton _bAlign;
    private JComboBox _cbZoom;
    private JComboBox _cbGrid;
    private JCheckBox _cbGridDisplay;

    public TestAscii(String[] stringArray) {
        super("DesktopCardPanel Test");
        this.getContentPane().add("Center", this._editorPanel);
        this.getContentPane().add("North", this.createToolBar());
        this.setJMenuBar(this.createMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        ShapesContainer shapesContainer = new ShapesContainer("plots");
        AsciiFileDataSourceCollection asciiFileDataSourceCollection = null;
        try {
            asciiFileDataSourceCollection = new AsciiFileDataSourceCollection(new File(stringArray[0]));
            asciiFileDataSourceCollection.bufferize(new ResizeableBuffer());
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        catch (DataException dataException) {
            System.err.println(dataException.toString());
            dataException.printStackTrace(System.err);
            System.exit(1);
        }
        DataSource dataSource = (DataSource)asciiFileDataSourceCollection.get(0);
        String string = DataInfo.getLabel(dataSource);
        PlotShape[] plotShapeArray = new PlotShape[asciiFileDataSourceCollection.size()];
        plotShapeArray[0] = new PlotShape(50, 250, 400, 200);
        plotShapeArray[0].setX(0.0, 10.0, 1.0);
        plotShapeArray[0].setY(0.0, 100.0, 10.0);
        plotShapeArray[0].setXLabel(string);
        for (int i = 1; i < asciiFileDataSourceCollection.size(); ++i) {
            plotShapeArray[i] = new PlotShape(50 + (i & 1) * 450, ((i >> 1) + 1) * 250, 400, 200);
            plotShapeArray[i].setX(0.0, 10.0, 1.0);
            plotShapeArray[i].setY(0.0, 100.0, 10.0);
            CurveShape curveShape = new CurveShape();
            DataSource dataSource2 = (DataSource)asciiFileDataSourceCollection.get(i);
            curveShape.setData(dataSource, dataSource2);
            plotShapeArray[i].insertCurve(curveShape);
            String string2 = DataInfo.getLabel(dataSource2);
            plotShapeArray[i].setYLabel(string2);
            plotShapeArray[i].setXLabel(string);
            Color color = new Color(255 - i * 30, i * 100 % 255, (i * 50 + 128) % 255);
            plotShapeArray[i].setCurveColor(curveShape, color);
            plotShapeArray[0].insertCurve(curveShape);
            plotShapeArray[0].setCurveColor(curveShape, color);
            plotShapeArray[0].setCurveLabel(curveShape, string2);
            shapesContainer.addElement(plotShapeArray[i]);
        }
        shapesContainer.addElement(plotShapeArray[0]);
        this._editorPanel.addComponent(shapesContainer.getComponent());
        DiagramClipboard.create();
        this.pack();
        this.show();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this._editorPanel.createMenu(null));
        return jMenuBar;
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setMargin(new Insets(1, 1, 1, 1));
        this._bPrint = new JButton("Print");
        this._bPrint.addActionListener(this);
        jToolBar.add(this._bPrint);
        this._bAdjust = new JButton("Adjust");
        this._bAdjust.addActionListener(this);
        jToolBar.add(this._bAdjust);
        this._bAlign = new JButton("Align");
        this._bAlign.addActionListener(this);
        jToolBar.add(this._bAlign);
        JLabel jLabel = new JLabel("Zoom", 4);
        jLabel.setAlignmentY(0.0f);
        jToolBar.add(jLabel);
        this._cbZoom = new JComboBox();
        this._cbZoom.setAlignmentY(0.0f);
        this._cbZoom.addItem("500%");
        this._cbZoom.addItem("200%");
        this._cbZoom.addItem("150%");
        this._cbZoom.addItem("100%");
        this._cbZoom.addItem("75%");
        this._cbZoom.addItem("50%");
        this._cbZoom.addItem("25%");
        this._cbZoom.addItem("10%");
        this._cbZoom.setSelectedItem("100%");
        this._cbZoom.setEditable(true);
        this._cbZoom.addActionListener(this);
        jToolBar.add(this._cbZoom);
        JLabel jLabel2 = new JLabel("Grid", 4);
        jLabel2.setAlignmentY(0.0f);
        jToolBar.add(jLabel2);
        this._cbGrid = new JComboBox();
        this._cbGrid.setAlignmentY(0.0f);
        this._cbGrid.addItem("0");
        this._cbGrid.addItem("5");
        this._cbGrid.addItem("10");
        this._cbGrid.addItem("20");
        this._cbGrid.addItem("40");
        this._cbGrid.setSelectedItem("0");
        this._cbGrid.setEditable(true);
        this._cbGrid.addActionListener(this);
        jToolBar.add(this._cbGrid);
        this._cbGridDisplay = new JCheckBox("Grid Display");
        this._cbGridDisplay.addActionListener(this);
        jToolBar.add(this._cbGridDisplay);
        return jToolBar;
    }

    private double getZoomValue() {
        try {
            String string = (String)this._cbZoom.getSelectedItem();
            if (string.endsWith("%")) {
                string = string.substring(0, string.length() - 1);
            }
            Double d = new Double(string);
            return d / 100.0;
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    private DiagramComponent getDiagram() {
        JComponent jComponent = this._editorPanel.getSelectedComponent();
        if (jComponent instanceof DiagramComponent) {
            return (DiagramComponent)jComponent;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._bPrint) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            PrintDialog printDialog = new PrintDialog("Hello");
            printDialog.show();
            if (!printDialog.getResult()) {
                return;
            }
            PrinterJob printerJob = printDialog.getPrinterJob();
            diagramComponent.setSelectionPrintMode(printDialog.printSelection());
            printerJob.setPrintable(diagramComponent, printDialog.getPageFormat());
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (actionEvent.getSource() == this._bAdjust) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.adjust();
        } else if (actionEvent.getSource() == this._bAlign) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.align();
        } else if (actionEvent.getSource() == this._cbZoom) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setZoom(this.getZoomValue());
        } else if (actionEvent.getSource() == this._cbGridDisplay) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            diagramComponent.setGridDisplay(this._cbGridDisplay.isSelected());
        } else if (actionEvent.getSource() == this._cbGrid) {
            DiagramComponent diagramComponent = this.getDiagram();
            if (diagramComponent == null) {
                return;
            }
            try {
                String string = (String)this._cbGrid.getSelectedItem();
                Integer n = new Integer(string);
                diagramComponent.setGrid(n);
            }
            catch (Exception exception) {
                diagramComponent.setGrid(0);
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Argument expected: data file.");
            System.exit(0);
        }
        TestAscii testAscii = null;
        testAscii = new TestAscii(stringArray);
    }
}

