/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.Format;
import java.util.Vector;
import simtools.data.EndNotificationListener;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.shapes.AxisShape;
import simtools.shapes.CurveShape;
import simtools.shapes.CurveShapeListener;
import simtools.shapes.LabelShape;

public class PlotShape
extends AbstractShape
implements Serializable,
Cloneable,
CurveShapeListener,
EndNotificationListener,
Resizable {
    static final long serialVersionUID = -7683803866479302545L;
    private static Font _defaultFont = new Font("TimesRoman", 0, 10);
    protected Font _font = null;
    protected Font titleFont;
    protected Color _color = null;
    protected AxisShape _asx1;
    protected AxisShape _asy1;
    protected AxisShape _asx2;
    protected AxisShape _asy2;
    protected boolean hasLegend;
    protected LabelShape title;
    protected Vector _curves;
    protected transient boolean optimize;
    protected transient int optimizeMode;
    protected transient BufferedImage image;
    protected transient Graphics2D imageGraphics;
    protected transient boolean dirty = false;
    protected transient Rectangle legendBounds;

    public PlotShape(int n, int n2, int n3, int n4) {
        super(n, n2);
        this._asx1 = new AxisShape(false, true, this._ox, this._oy, n3, n4);
        this._asy1 = new AxisShape(true, true, this._ox, this._oy, n3, n4);
        this._asx2 = null;
        this._asy2 = null;
        this._curves = new Vector();
        this.hasLegend = false;
        this.title = null;
        this.setColor(Color.black);
        this.setFont(_defaultFont);
        this.titleFont = this._font.deriveFont(this._font.getSize2D() * 2.0f);
        this.optimizeMode = 0;
        this.optimize = false;
        this.legendBounds = null;
    }

    protected AbstractShape cloneShape() {
        PlotShape plotShape = null;
        try {
            plotShape = (PlotShape)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        plotShape._asx1 = (AxisShape)plotShape._asx1.cloneShape();
        plotShape._asy1 = (AxisShape)plotShape._asy1.cloneShape();
        if (plotShape._asx2 != null) {
            plotShape._asx2 = (AxisShape)plotShape._asx2.cloneShape();
        }
        if (plotShape._asy2 != null) {
            plotShape._asy2 = (AxisShape)plotShape._asy2.cloneShape();
        }
        plotShape._curves = new Vector();
        for (int i = 0; i < this._curves.size(); ++i) {
            Object object = null;
            Curve curve = (Curve)this._curves.elementAt(i);
            object = curve.clone();
            plotShape._curves.addElement(object);
        }
        if (this.title != null) {
            plotShape.title = (LabelShape)this.title.cloneShape();
        }
        return plotShape;
    }

    public void setSecondaryAxis(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (this._asx2 != null) {
                    return;
                }
                this._asx2 = new AxisShape(false, false, this._ox, this._oy, this._asx1._lineWidth, this._asx1._lineHeight);
            } else {
                if (this._asx2 == null) {
                    return;
                }
                this._asx2 = null;
            }
        } else if (bl2) {
            if (this._asy2 != null) {
                return;
            }
            this._asy2 = new AxisShape(true, false, this._ox, this._oy, this._asx1._lineWidth, this._asx1._lineHeight);
        } else {
            if (this._asy2 == null) {
                return;
            }
            this._asy2 = null;
        }
        this.computeBounds();
    }

    public boolean isSecondaryAxis(boolean bl) {
        if (bl) {
            return this._asx2 != null;
        }
        return this._asy2 != null;
    }

    public int getCurveNumber() {
        return this._curves.size();
    }

    public Curve getCurve(int n) {
        return (Curve)this._curves.elementAt(n);
    }

    public Curve getCurve(CurveShape curveShape) {
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape != curveShape) continue;
            return curve;
        }
        return null;
    }

    public void insertCurve(CurveShape curveShape, boolean bl, boolean bl2, int n) {
        Curve curve = new Curve(curveShape, bl, bl2);
        if (this._curves.size() == 0) {
            this.optimizeMode = curveShape.getXSource().sortedOrder();
        } else if (this.optimizeMode != curveShape.getXSource().sortedOrder()) {
            this.optimizeMode = 0;
        }
        if (n < 0) {
            this._curves.addElement(curve);
        } else {
            this._curves.insertElementAt(curve, n);
        }
        curveShape.addListener(this);
        if (curveShape._xSource != null) {
            curveShape._xSource.addEndNotificationListener(this);
        }
        if (curveShape._ySource != null) {
            curveShape._ySource.addEndNotificationListener(this);
        }
        if (this.optimize && this.optimizeMode != 0) {
            curveShape.tryDrawNewOnly();
        }
    }

    public void insertCurve(CurveShape curveShape) {
        this.insertCurve(curveShape, false);
    }

    public void insertCurve(CurveShape curveShape, boolean bl) {
        this.insertCurve(curveShape, bl, false);
    }

    public void insertCurve(CurveShape curveShape, boolean bl, boolean bl2) {
        this.insertCurve(curveShape, bl, bl2, -1);
    }

    public void removeCurve(CurveShape curveShape) {
        int n = -2;
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape == curveShape) {
                curveShape.removeListener(this);
                if (curveShape._xSource != null) {
                    curveShape._xSource.removeEndNotificationListener(this);
                }
                if (curveShape._ySource != null) {
                    curveShape._ySource.removeEndNotificationListener(this);
                }
                this._curves.removeElementAt(i);
                continue;
            }
            if (n == -2) {
                n = curve.shape.getXSource().sortedOrder();
                continue;
            }
            if (n == curve.shape.getXSource().sortedOrder()) continue;
            n = 0;
        }
        this.optimizeMode = n;
    }

    public void setCurveColor(CurveShape curveShape, Color color) {
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape != curveShape) continue;
            curve.color = color;
        }
    }

    public void setCurveLabel(CurveShape curveShape, String string) {
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            if (curve.shape != curveShape) continue;
            curve.setLabel(string);
        }
    }

    public void setFont(Font font) {
        if (font != this._font) {
            this._font = font;
            this._asx1.setFont(font);
            this._asy1.setFont(font);
            if (this._asx2 != null) {
                this._asx2.setFont(font);
            }
            if (this._asy2 != null) {
                this._asy2.setFont(font);
            }
            this.computeLegendBounds();
            this.updateBounds();
        }
    }

    public void setTitleFont(Font font) {
        if (font != this.titleFont) {
            this.titleFont = font;
            this.computeLegendBounds();
            this.updateBounds();
        }
    }

    public boolean isLegendVisible() {
        return this.hasLegend;
    }

    public void setLegendVisible(boolean bl) {
        this.hasLegend = bl;
    }

    public String getTitle() {
        return this.title == null ? null : this.title.getString();
    }

    public void setTitle(String string) {
        if (string == null || string.trim().equals("")) {
            if (this.title != null) {
                this.title = null;
                this.computeBounds();
            }
        } else if (this.title == null) {
            this.title = new LabelShape(string, 0, 0, 10, false);
            this.computeBounds();
        } else {
            this.title.setString(string);
            this.computeBounds();
        }
    }

    public void set(double d, double d2, double d3, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                this.setSecondaryAxis(true, true);
                this._asx2.set(d, d2, d3);
            } else {
                this._asx1.set(d, d2, d3);
            }
        } else if (bl2) {
            this.setSecondaryAxis(false, true);
            this._asy2.set(d, d2, d3);
        } else {
            this._asy1.set(d, d2, d3);
        }
        this.computeLegendBounds();
        this.updateBounds();
    }

    public void setX(double d, double d2, double d3) {
        this.set(d, d2, d3, true, false);
    }

    public void setSecondaryX(double d, double d2, double d3) {
        this.set(d, d2, d3, true, true);
    }

    public void setY(double d, double d2, double d3) {
        this.set(d, d2, d3, false, false);
    }

    public void setSecondaryY(double d, double d2, double d3) {
        this.set(d, d2, d3, false, true);
    }

    public void setLabel(String string, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (this._asx2 != null) {
                    this._asx2.setLabel(string);
                }
            } else {
                this._asx1.setLabel(string);
            }
        } else if (bl2) {
            if (this._asy2 != null) {
                this._asy2.setLabel(string);
            }
        } else {
            this._asy1.setLabel(string);
        }
        this.computeLegendBounds();
        this.updateBounds();
    }

    public void setXLabel(String string, boolean bl) {
        this.setLabel(string, true, bl);
    }

    public void setXLabel(String string) {
        this.setXLabel(string, false);
    }

    public void setYLabel(String string, boolean bl) {
        this.setLabel(string, false, bl);
    }

    public void setYLabel(String string) {
        this.setYLabel(string, false);
    }

    public void setFormat(Format format, boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                this._asx2.setFormat(format);
            } else {
                this._asx1.setFormat(format);
            }
        } else if (bl2) {
            this._asy2.setFormat(format);
        } else {
            this._asy1.setFormat(format);
        }
        this.computeLegendBounds();
        this.updateBounds();
    }

    public void setColor(Color color) {
        if (this._color != color) {
            this._color = color;
            this._asx1.setColor(this._color);
            this._asy1.setColor(this._color);
            if (this._asx2 != null) {
                this._asx2.setColor(this._color);
            }
            if (this._asy2 != null) {
                this._asy2.setColor(this._color);
            }
        }
    }

    public void setAnchor(Point point) {
        int n = point.x - this._ox;
        int n2 = point.y - this._oy;
        this.translate(n, n2);
    }

    public void resize(int n, int n2) {
        this._asx1.resize(n, n2);
        this._asy1.resize(n, n2);
        if (this._asx2 != null) {
            this._asx2.resize(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.resize(n, n2);
        }
        this.computeLegendBounds();
        this.updateBounds();
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        this._asx1.translate(n, n2);
        this._asy1.translate(n, n2);
        if (this._asx2 != null) {
            this._asx2.translate(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.translate(n, n2);
        }
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        this._asx1.setAnchor(n, n2);
        this._asy1.setAnchor(n, n2);
        if (this._asx2 != null) {
            this._asx2.setAnchor(n, n2);
        }
        if (this._asy2 != null) {
            this._asy2.setAnchor(n, n2);
        }
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        if (this.optimize && this.optimizeMode != 0) {
            if (this.image == null) {
                this.image = graphics2D.getDeviceConfiguration().createCompatibleImage(this._asx1._lineWidth, this._asx1._lineHeight);
                this.imageGraphics = this.image.createGraphics();
                this.imageGraphics.setBackground(graphics2D.getBackground());
                this.imageGraphics.setColor(Color.white);
                this.imageGraphics.fillRect(0, 0, this._asx1._lineWidth, this._asx1._lineHeight);
                this.imageGraphics.translate(0, this._asx1._lineHeight);
                this.drawCurves(this.imageGraphics);
            }
            graphics2D.drawImage(this.image, null, this._ox, this._oy - this._asx1._lineHeight);
        }
        this._asx1.draw(graphics2D);
        this._asy1.draw(graphics2D);
        if (this._asx2 != null) {
            this._asx2.draw(graphics2D);
        }
        if (this._asy2 != null) {
            this._asy2.draw(graphics2D);
        }
        if (!this.optimize || this.optimizeMode == 0) {
            Stroke stroke = graphics2D.getStroke();
            Color color2 = graphics2D.getColor();
            AffineTransform affineTransform = graphics2D.getTransform();
            Shape shape = graphics2D.getClip();
            graphics2D.translate(this._ox, this._oy);
            graphics2D.setClip(0, -this._asx1._lineHeight, this._asx1._lineWidth, this._asx1._lineHeight);
            this.drawCurves(graphics2D);
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            graphics2D.setStroke(stroke);
            graphics2D.setColor(color2);
        }
        this.drawLegend(graphics2D);
        graphics2D.setColor(color);
    }

    protected Rectangle drawLegendAndGetBounds(Graphics2D graphics2D, Rectangle rectangle) {
        Rectangle rectangle2;
        int n = rectangle.x;
        int n2 = rectangle.y + rectangle.height;
        Rectangle rectangle3 = new Rectangle(n, n2, 0, 0);
        if (this.title != null) {
            this.title.setAnchor(n + rectangle.width / 2, n2);
            this.title.setBounds(this.titleFont);
            if (graphics2D != null) {
                this.title.draw(graphics2D);
            }
            rectangle2 = this.title.getBounds();
            n2 += rectangle2.height;
            rectangle3.add(rectangle2);
        }
        if (this.hasLegend) {
            int n3 = rectangle.width / 10;
            int n4 = n;
            int n5 = n + rectangle.width;
            int n6 = 0;
            for (int i = 0; i < this._curves.size(); ++i) {
                Curve curve = (Curve)this._curves.elementAt(i);
                if (curve.label == null) continue;
                curve.label.anchorSide = 9;
                curve.label.setAnchor(n4, n2);
                curve.label.setBounds(this._font);
                rectangle2 = curve.label.getBounds();
                int n7 = rectangle2.x + rectangle2.width + 2;
                if (n7 + n3 > n5 && n4 != n) {
                    n4 = n;
                    curve.label.setAnchor(n4, n2 += n6);
                    curve.label.setBounds(this._font);
                    rectangle2 = curve.label.getBounds();
                    n7 = rectangle2.x + rectangle2.width + 2;
                }
                int n8 = n2 + rectangle2.height;
                if (graphics2D != null) {
                    graphics2D.setColor(curve.color);
                    curve.label.draw(graphics2D);
                    Stroke stroke = graphics2D.getStroke();
                    if (curve.stroke != null) {
                        graphics2D.setStroke(curve.stroke);
                    }
                    graphics2D.drawLine(n7, n8, n7 + n3, n8);
                    graphics2D.setStroke(stroke);
                }
                rectangle3.add(new Rectangle(n7, n8, n3, 2));
                n6 = rectangle2.height;
                n4 = n7 + n3 + rectangle.width / 20;
                rectangle3.add(rectangle2);
            }
        }
        return rectangle3;
    }

    public void drawLegend(Graphics2D graphics2D) {
        this.drawLegendAndGetBounds(graphics2D, this._asx1.getBounds());
    }

    public void computeLegendBounds() {
        this.legendBounds = this.drawLegendAndGetBounds(null, this._asx1.getBounds());
    }

    protected void drawCurves(Graphics2D graphics2D) {
        AxisShape axisShape = null;
        AxisShape axisShape2 = null;
        for (int i = 0; i < this._curves.size(); ++i) {
            Curve curve = (Curve)this._curves.elementAt(i);
            graphics2D.setColor(curve.color);
            axisShape = curve.secondaryXaxis ? this._asx2 : this._asx1;
            AxisShape axisShape3 = axisShape2 = curve.secondaryYaxis ? this._asy2 : this._asy1;
            if (axisShape == null) {
                axisShape = this._asx1;
            }
            if (axisShape2 == null) {
                axisShape2 = this._asy1;
            }
            Stroke stroke = null;
            if (curve.stroke != null) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(curve.stroke);
            }
            curve.shape.draw(graphics2D, axisShape.getMin(), axisShape2.getMin(), axisShape.getMax(), axisShape2.getMax(), axisShape.getScale(), axisShape2.getScale(), curve.showPoints);
            if (curve.stroke == null) continue;
            graphics2D.setStroke(stroke);
        }
    }

    protected void computeBounds() {
        this._asx1.computeBounds();
        this._asy1.computeBounds();
        if (this._asx2 != null) {
            this._asx2.computeBounds();
        }
        if (this._asy2 != null) {
            this._asy2.computeBounds();
        }
        this.computeLegendBounds();
        this.updateBounds();
    }

    protected void updateBounds() {
        Rectangle rectangle = this._asx1.getBounds();
        rectangle.add(this._asy1.getBounds());
        if (this._asx2 != null) {
            rectangle.add(this._asx2.getBounds());
        }
        if (this._asy2 != null) {
            rectangle.add(this._asy2.getBounds());
        }
        rectangle.add(this.legendBounds);
        this._w = rectangle.width;
        this._h = rectangle.height;
        this._x = rectangle.x - this._ox;
        this._y = rectangle.y + this._h - this._oy;
    }

    public static Stroke createStroke(float f, float f2) {
        if (f < 0.0f || f2 < 0.0f) {
            return null;
        }
        float[] fArray = new float[]{f, f2};
        return new BasicStroke(1.0f, 2, 0, 1.0f, fArray, 0.0f);
    }

    public void shapeChanged(CurveShape curveShape) {
        this.dirty = true;
    }

    public boolean isOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean bl) {
        this.optimize = bl;
    }

    public void notificationEnd(Object object) {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        if (this.image != null) {
            this.drawCurves(this.imageGraphics);
        }
        this.notifyChange();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        for (int i = 0; i < this._curves.size(); ++i) {
            CurveShape curveShape = ((Curve)this._curves.elementAt((int)i)).shape;
            if (curveShape._xSource != null) {
                curveShape._xSource.addEndNotificationListener(this);
            }
            if (curveShape._ySource == null) continue;
            curveShape._ySource.addEndNotificationListener(this);
        }
    }

    public class Curve
    implements Cloneable,
    Serializable {
        static final long serialVersionUID = 6915530284384638195L;
        public CurveShape shape;
        LabelShape label;
        public boolean secondaryXaxis;
        public boolean secondaryYaxis;
        public Color color;
        transient Stroke stroke;
        public float dashParam1;
        public float dashParam2;
        public boolean showPoints;

        public Curve(CurveShape curveShape, boolean bl, boolean bl2) {
            this.shape = curveShape;
            this.label = null;
            this.secondaryXaxis = bl;
            this.secondaryYaxis = bl2;
            this.color = Color.black;
            this.dashParam1 = -1.0f;
            this.dashParam2 = -1.0f;
            this.stroke = PlotShape.createStroke(this.dashParam1, this.dashParam2);
            this.showPoints = false;
        }

        public Object clone() {
            Curve curve = null;
            try {
                curve = (Curve)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
            if (curve.label != null) {
                curve.label = (LabelShape)curve.label.cloneShape();
            }
            try {
                curve.shape = (CurveShape)this.shape.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                curve.shape = this.shape;
            }
            if (curve.shape != null) {
                curve.shape.addListener(PlotShape.this);
                curve.shape._xSource.addEndNotificationListener(PlotShape.this);
                curve.shape._ySource.addEndNotificationListener(PlotShape.this);
            }
            curve.stroke = PlotShape.createStroke(this.dashParam1, this.dashParam2);
            return curve;
        }

        public void setLabel(String string) {
            if (string == null || string.trim().equals("")) {
                if (this.label != null) {
                    this.label = null;
                }
            } else if (this.label == null) {
                this.label = new LabelShape(string, 0, 0, 9, false);
            } else {
                this.label.setString(string);
            }
        }

        public String getLabel() {
            if (this.label == null) {
                return null;
            }
            return this.label.getString();
        }

        public String toString() {
            if (this.label == null) {
                return "";
            }
            return this.label.getString();
        }

        public void setDashParameters(float f, float f2) {
            this.dashParam1 = f;
            this.dashParam2 = f2;
            this.stroke = PlotShape.createStroke(this.dashParam1, this.dashParam2);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.stroke = PlotShape.createStroke(this.dashParam1, this.dashParam2);
        }

        public boolean isShowPoints() {
            return this.showPoints;
        }

        public void setShowPoints(boolean bl) {
            this.showPoints = bl;
        }
    }
}

