/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.async;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourceProvider;
import simtools.data.DuplicateIdException;
import simtools.data.async.TimeStampedDataSourceCollection;

public abstract class TimeStampedDataSourceProvider
implements DataSourceProvider {
    private boolean chooseAgain = false;
    protected String marker = "TimeStamped:";

    protected void setChooseFileAgain(boolean bl) {
        this.chooseAgain = bl;
    }

    protected boolean getChooseFileAgain() {
        return this.chooseAgain;
    }

    public File chooseFile(String string, String string2) {
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean chooseUseCollection(DataSourceCollection dataSourceCollection, String string, String string2) {
        return false;
    }

    public Object getOptionalInformation(DataSource dataSource, DataSourceCollection dataSourceCollection) {
        return null;
    }

    public DataSource provide(String string, String string2, Object object, DataSourcePool dataSourcePool) {
        Object object2;
        Object object3;
        DataSourceCollection dataSourceCollection;
        block17: {
            if (string == null || string2 == null || !string2.startsWith(this.marker)) {
                return null;
            }
            dataSourceCollection = null;
            if (dataSourcePool != null) {
                try {
                    dataSourceCollection = dataSourcePool.getCollectionForDataSourceId(string);
                }
                catch (DuplicateIdException duplicateIdException) {
                    object3 = duplicateIdException.conflicts.iterator();
                    while (object3.hasNext()) {
                        object2 = (DataSourceCollection)object3.next();
                        if (object2 instanceof TimeStampedDataSourceCollection) continue;
                        object3.remove();
                    }
                    if (duplicateIdException.conflicts.size() == 0) {
                        dataSourceCollection = null;
                    }
                    if (duplicateIdException.conflicts.size() <= 0) break block17;
                    dataSourceCollection = (TimeStampedDataSourceCollection)duplicateIdException.conflicts.get(0);
                }
            }
        }
        if (dataSourceCollection instanceof TimeStampedDataSourceCollection && this.chooseUseCollection(dataSourceCollection, string2, string)) {
            return dataSourceCollection.get(string);
        }
        Date date = null;
        object3 = null;
        if (object != null) {
            date = ((Date[])object)[0];
            object3 = ((Date[])object)[1];
        }
        object2 = string2.substring(this.marker.length());
        DataSource dataSource = null;
        TimeStampedDataSourceCollection timeStampedDataSourceCollection = null;
        block5: do {
            File file;
            if ((file = this.chooseFile((String)object2, string)) == null) {
                return null;
            }
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                return null;
            }
            try {
                timeStampedDataSourceCollection = this.createCollection(file, date, (Date)object3);
                if (timeStampedDataSourceCollection == null) {
                    return null;
                }
                for (int i = 0; i < timeStampedDataSourceCollection.size(); ++i) {
                    if (!string.equals(timeStampedDataSourceCollection.getInformation((int)i).id)) continue;
                    dataSource = (DataSource)timeStampedDataSourceCollection.get(i);
                    continue block5;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (this.chooseAgain && dataSource == null);
        if (dataSource == null) {
            return null;
        }
        if (dataSourcePool != null) {
            dataSourcePool.addDataSourceCollection(timeStampedDataSourceCollection);
        }
        return dataSource;
    }

    protected abstract TimeStampedDataSourceCollection createCollection(File var1, Date var2, Date var3) throws IOException, TimeStampedDataSourceCollection.InvalidFormatException;
}

