/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.builtin.PolygonShape;
import jsynoptic.builtin.ui.LinePropertiesPanel;
import jsynoptic.ui.JSynoptic;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;

public class LinesShape
extends Abstract1DShape {
    static final long serialVersionUID = -1496833631942194369L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$LinesShape == null ? (class$jsynoptic$builtin$LinesShape = LinesShape.class$("jsynoptic.builtin.LinesShape")) : class$jsynoptic$builtin$LinesShape);
    protected double[] x;
    protected double[] y;
    protected boolean closed;
    protected boolean selecting;
    static /* synthetic */ Class class$jsynoptic$builtin$LinesShape;

    public LinesShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.x = new double[]{-1.0, 1.0};
        this.y = new double[]{-1.0, 1.0};
        this.allowResize = true;
        this.fixedRatio = false;
    }

    public LinesShape(int n, int n2, int n3, int n4, double[] dArray, double[] dArray2, boolean bl, boolean bl2, double d) {
        super(n, n2, n3, n4);
        this.allowResize = bl;
        this.fixedRatio = bl2;
        this.ratio = d;
        this.x = dArray;
        this.y = dArray2;
        this.closed = true;
    }

    protected Shape getDelegateShape() {
        return this;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new LineIterator(affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new LineIterator(affineTransform);
    }

    public JPropertiesPanel createPanel() {
        return new LinePropertiesPanel();
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            if (this.selecting) {
                return new String[]{"mouseOver"};
            }
            return null;
        }
        if (n == 4) {
            if (this.selecting) {
                return new String[]{"mouseOut"};
            }
            return null;
        }
        if (n == 5) {
            if (!this.selecting) {
                return null;
            }
            MouseEvent mouseEvent = (MouseEvent)object;
            if ((mouseEvent.getModifiers() & 0x10) == 16) {
                return new String[]{"leftClick"};
            }
            if ((mouseEvent.getModifiers() & 4) == 4) {
                return new String[]{"rightClick"};
            }
            return null;
        }
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getActions(d, d2, object, n);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        if (n == 1) {
            vector.add(resources.getString("EditPoints"));
            if (this.x.length >= 3) {
                vector.add(resources.getString("ConvertToPolygon"));
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals("mouseOver")) {
            JSynoptic.setStatus(resources.getString("ClickLeftMouseButtonToAddAPoint,RightMouseButtonToFinish"));
            return true;
        }
        if (string.equals("mouseOut")) {
            JSynoptic.setStatus("");
            return true;
        }
        if (string.equals(resources.getString("EditPoints"))) {
            JSynoptic.setStatus(resources.getString("ClickLeftMouseButtonToAddAPoint,RightMouseButtonToFinish"));
            this.selecting = true;
            this.x = new double[0];
            this.y = new double[0];
            this.notifyChange();
            return true;
        }
        if (string.equals("leftClick")) {
            int n = this.x.length;
            double[] dArray = new double[n + 1];
            double[] dArray2 = new double[n + 1];
            if (n > 0) {
                System.arraycopy(this.x, 0, dArray, 0, n);
                System.arraycopy(this.y, 0, dArray2, 0, n);
            }
            dArray[n] = (d - (double)this._ox) * 2.0 / (double)this._w - 1.0;
            dArray2[n] = ((double)this._oy - d2) * 2.0 / (double)this._h - 1.0;
            if (dArray[n] < -1.0) {
                dArray[n] = -1.0;
            }
            if (dArray2[n] < -1.0) {
                dArray2[n] = -1.0;
            }
            if (dArray[n] > 1.0) {
                dArray[n] = 1.0;
            }
            if (dArray2[n] > 1.0) {
                dArray2[n] = 1.0;
            }
            this.x = dArray;
            this.y = dArray2;
            this.notifyChange();
            return true;
        }
        if (string.equals("rightClick")) {
            this.selecting = false;
            JSynoptic.setStatus("");
            this.notifyChange();
            return true;
        }
        if (string.equals(resources.getString("ConvertToPolygon"))) {
            PolygonShape polygonShape = new PolygonShape(this._ox, this._oy, this._w, this._h, this.x, this.y, this.allowResize, this.fixedRatio, this.ratio);
            JSynoptic.gui.getActiveContainer().remove(this);
            JSynoptic.gui.getActiveContainer().add(polygonShape);
            JSynoptic.gui.getActiveContainer().getComponent().getDiagramSelection().unselect();
            JSynoptic.gui.getActiveContainer().getComponent().repaint(this.getBounds());
            return true;
        }
        return super.doAction(d, d2, object, string);
    }

    public void draw(Graphics2D graphics2D) {
        if (this.selecting) {
            graphics2D.drawRect(this._ox + this._x, this._oy + this._y - this._h, this._w, this._h);
        }
        super.draw(graphics2D);
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("POINTS")) {
            String string2 = "";
            for (int i = 0; i < this.x.length; ++i) {
                string2 = string2 + Math.round((this.x[i] + 1.0) * (double)this._w / 2.0);
                string2 = string2 + " ";
                string2 = string2 + Math.round((this.y[i] + 1.0) * (double)this._h / 2.0);
                string2 = string2 + "\n";
            }
            object = string2;
        } else if (string.equalsIgnoreCase("CLOSED")) {
            object = new Boolean(this.closed);
        }
        return object;
    }

    public void setPropertyValue(String string, Object object) {
        if (string.equalsIgnoreCase("POINTS")) {
            if (object instanceof String) {
                String string2 = (String)object;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ()[]{}'\"\n\t:;,/");
                boolean bl = true;
                Vector<Object> vector = new Vector<Object>();
                Vector<Object> vector2 = new Vector<Object>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (bl) {
                        vector.add(string3);
                    } else {
                        vector2.add(string3);
                    }
                    bl = !bl;
                }
                int n = vector2.size();
                if (vector.size() != n) {
                    vector.remove(n);
                }
                double d = Double.POSITIVE_INFINITY;
                double d2 = Double.NEGATIVE_INFINITY;
                double d3 = Double.POSITIVE_INFINITY;
                double d4 = Double.NEGATIVE_INFINITY;
                int n2 = 0;
                while (n2 < n) {
                    double d5;
                    double d6;
                    try {
                        d6 = Double.parseDouble((String)vector.get(n2));
                        d5 = Double.parseDouble((String)vector2.get(n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        vector.remove(n2);
                        vector2.remove(n2);
                        --n;
                        continue;
                    }
                    vector.set(n2, new Double(d6));
                    vector2.set(n2, new Double(d5));
                    if (d6 < d) {
                        d = d6;
                    }
                    if (d5 < d3) {
                        d3 = d5;
                    }
                    if (d6 > d2) {
                        d2 = d6;
                    }
                    if (d5 > d4) {
                        d4 = d5;
                    }
                    ++n2;
                }
                double d7 = d2 - d;
                double d8 = d4 - d3;
                if (d7 == 0.0) {
                    d7 = MIN_SIZE;
                }
                if (d8 == 0.0) {
                    d8 = MIN_SIZE;
                }
                if (this.allowResize) {
                    this._w = (int)d7;
                    this._h = (int)d8;
                    if (this._w < MIN_SIZE) {
                        this._w = MIN_SIZE;
                    }
                    if (this._h < MIN_SIZE) {
                        this._h = MIN_SIZE;
                    }
                }
                this.x = new double[n];
                this.y = new double[n];
                for (int i = 0; i < n; ++i) {
                    this.x[i] = ((Double)vector.get(i) - d) * 2.0 / (double)this._w - 1.0;
                    this.y[i] = ((Double)vector2.get(i) - d3) * 2.0 / (double)this._h - 1.0;
                }
                this.ratio = (double)this._w / (double)this._h;
            }
        } else if (string.equalsIgnoreCase("CLOSED") && object instanceof Boolean) {
            this.closed = (Boolean)object;
        }
        super.setPropertyValue(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class LineIterator
    implements PathIterator {
        int index = 0;
        AffineTransform aff;

        LineIterator(AffineTransform affineTransform) {
            this.aff = affineTransform;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            if (LinesShape.this.closed && LinesShape.this.x.length >= 3) {
                return this.index > LinesShape.this.x.length;
            }
            return this.index >= LinesShape.this.x.length;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= LinesShape.this.x.length) {
                return 4;
            }
            fArray[0] = (long)(LinesShape.this._ox + LinesShape.this._x) + Math.round((LinesShape.this.x[this.index] + 1.0) * (double)(LinesShape.this._w - 1) / 2.0);
            fArray[1] = (long)(LinesShape.this._oy + LinesShape.this._y - 1) - Math.round((LinesShape.this.y[this.index] + 1.0) * (double)(LinesShape.this._h - 1) / 2.0);
            if (this.aff != null) {
                this.aff.transform(fArray, 0, fArray, 0, 1);
            }
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= LinesShape.this.x.length) {
                return 4;
            }
            dArray[0] = (long)(LinesShape.this._ox + LinesShape.this._x) + Math.round((LinesShape.this.x[this.index] + 1.0) * (double)(LinesShape.this._w - 1) / 2.0);
            dArray[1] = (long)(LinesShape.this._oy + LinesShape.this._y - 1) - Math.round((LinesShape.this.y[this.index] + 1.0) * (double)(LinesShape.this._h - 1) / 2.0);
            if (this.aff != null) {
                this.aff.transform(dArray, 0, dArray, 0, 1);
            }
            if (this.index == 0) {
                return 0;
            }
            return 1;
        }
    }
}

