/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.ClipPath;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.Marker;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ContourEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.ContourToolTipGenerator;
import org.jfree.chart.labels.StandardContourToolTipGenerator;
import org.jfree.chart.plot.ContourValuePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.ContourDataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.DefaultContourDataset;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public class ContourPlot
extends Plot
implements ContourValuePlot,
ValueAxisPlot,
PropertyChangeListener,
Serializable,
Cloneable {
    protected static final Insets DEFAULT_INSETS = new Insets(2, 2, 100, 10);
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private ContourDataset dataset;
    private ColorBar colorBar = null;
    private RectangleEdge colorBarLocation;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;
    private ContourToolTipGenerator toolTipGenerator;
    private XYURLGenerator urlGenerator;
    private boolean renderAsPoints = false;
    private double ptSizePct = 0.05;
    private transient ClipPath clipPath = null;
    private transient Paint missingPaint = null;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public ContourPlot(ContourDataset contourDataset, ValueAxis valueAxis, ValueAxis valueAxis2, ColorBar colorBar) {
        this.dataset = contourDataset;
        if (contourDataset != null) {
            contourDataset.addChangeListener(this);
        }
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.colorBar = colorBar;
        if (colorBar != null) {
            colorBar.getAxis().setPlot(this);
            colorBar.getAxis().addChangeListener(this);
            colorBar.configure(this);
        }
        this.colorBarLocation = RectangleEdge.LEFT;
        this.toolTipGenerator = new StandardContourToolTipGenerator();
    }

    public RectangleEdge getColorBarLocation() {
        return this.colorBarLocation;
    }

    public void setColorBarLocation(RectangleEdge rectangleEdge) {
        this.colorBarLocation = rectangleEdge;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ContourDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(ContourDataset contourDataset) {
        ContourDataset contourDataset2 = this.dataset;
        if (contourDataset2 != null) {
            contourDataset2.removeChangeListener(this);
        }
        this.dataset = contourDataset;
        if (contourDataset != null) {
            this.setDatasetGroup(contourDataset.getGroup());
            contourDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, contourDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public ContourDataset getContourDataset() {
        return this.getDataset();
    }

    public ValueAxis getDomainAxis() {
        ValueAxis valueAxis = this.domainAxis;
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        if (this.isCompatibleDomainAxis(valueAxis)) {
            if (valueAxis != null) {
                valueAxis.setPlot(this);
                valueAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
            this.domainAxis = valueAxis;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public ValueAxis getRangeAxis() {
        ValueAxis valueAxis = this.rangeAxis;
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.removeChangeListener(this);
        }
        this.rangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setColorBarAxis(ColorBar colorBar) {
        this.colorBar = colorBar;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        if (this.domainMarkers == null) {
            this.domainMarkers = new ArrayList();
        }
        this.domainMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.domainMarkers != null) {
            this.domainMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(xYAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCompatibleDomainAxis(ValueAxis valueAxis) {
        return true;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Marker marker;
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.BOTTOM, axisSpace);
        axisSpace = this.rangeAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.LEFT, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        AxisSpace axisSpace2 = new AxisSpace();
        axisSpace2 = this.colorBar.reserveSpace(graphics2D, this, rectangle2D, rectangle2D2, this.colorBarLocation, axisSpace2);
        Rectangle2D rectangle2D3 = axisSpace2.shrink(rectangle2D, null);
        Rectangle2D rectangle2D4 = axisSpace.shrink(rectangle2D3, null);
        Rectangle2D rectangle2D5 = axisSpace2.reserved(rectangle2D, this.colorBarLocation);
        if (this.getDataAreaRatio() != 0.0) {
            double d = this.getDataAreaRatio();
            Rectangle2D rectangle2D6 = (Rectangle2D)rectangle2D4.clone();
            double d2 = rectangle2D6.getHeight();
            double d3 = rectangle2D6.getWidth();
            if (d > 0.0) {
                if (d3 * d <= d2) {
                    d2 = d * d3;
                } else {
                    d3 = d2 / d;
                }
            } else {
                d *= -1.0;
                double d4 = this.getDomainAxis().getRange().getLength();
                double d5 = this.getRangeAxis().getRange().getLength();
                double d6 = d5 / d4;
                d = d6 * d;
                if (d3 * d <= d2) {
                    d2 = d * d3;
                } else {
                    d3 = d2 / d;
                }
            }
            rectangle2D4.setRect(rectangle2D6.getX() + rectangle2D6.getWidth() / 2.0 - d3 / 2.0, rectangle2D6.getY(), d3, d2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D4);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        this.drawBackground(graphics2D, rectangle2D4);
        double d = rectangle2D4.getMaxY();
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, d, rectangle2D3, rectangle2D4, RectangleEdge.BOTTOM);
        }
        if (this.rangeAxis != null) {
            d = rectangle2D4.getMinX();
            this.rangeAxis.draw(graphics2D, d, rectangle2D3, rectangle2D4, RectangleEdge.LEFT);
        }
        if (this.colorBar != null) {
            d = 0.0;
            d = this.colorBar.draw(graphics2D, d, rectangle2D3, rectangle2D4, rectangle2D5, this.colorBarLocation);
        }
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip(rectangle2D4);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, rectangle2D4, plotRenderingInfo, crosshairInfo);
        if (this.domainMarkers != null) {
            Iterator iterator = this.domainMarkers.iterator();
            while (iterator.hasNext()) {
                marker = (Marker)iterator.next();
                this.drawDomainMarker(graphics2D, this, this.getDomainAxis(), marker, rectangle2D4);
            }
        }
        if (this.rangeMarkers != null) {
            Iterator iterator = this.rangeMarkers.iterator();
            while (iterator.hasNext()) {
                marker = (Marker)iterator.next();
                this.drawRangeMarker(graphics2D, this, this.getRangeAxis(), marker, rectangle2D4);
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D4);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, CrosshairInfo crosshairInfo) {
        ContourDataset contourDataset = this.getContourDataset();
        if (contourDataset != null) {
            ColorBar colorBar = this.getColorBar();
            if (this.clipPath != null) {
                GeneralPath generalPath = this.getClipPath().draw(graphics2D, rectangle2D, this.domainAxis, this.rangeAxis);
                if (this.clipPath.isClip()) {
                    graphics2D.clip(generalPath);
                }
            }
            if (this.renderAsPoints) {
                this.pointRenderer(graphics2D, rectangle2D, plotRenderingInfo, this, this.domainAxis, this.rangeAxis, colorBar, contourDataset, crosshairInfo);
            } else {
                this.contourRenderer(graphics2D, rectangle2D, plotRenderingInfo, this, this.domainAxis, this.rangeAxis, colorBar, contourDataset, crosshairInfo);
            }
            this.setDomainCrosshairValue(crosshairInfo.getCrosshairX(), false);
            if (this.isDomainCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, this.getDomainCrosshairValue(), this.getDomainCrosshairStroke(), this.getDomainCrosshairPaint());
            }
            this.setRangeCrosshairValue(crosshairInfo.getCrosshairY(), false);
            if (this.isRangeCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
            }
        } else if (this.clipPath != null) {
            this.getClipPath().draw(graphics2D, rectangle2D, this.domainAxis, this.rangeAxis);
        }
    }

    public void contourRenderer(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, ContourPlot contourPlot, ValueAxis valueAxis, ValueAxis valueAxis2, ColorBar colorBar, ContourDataset contourDataset, CrosshairInfo crosshairInfo) {
        Rectangle2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Rectangle2D.Double double_2 = null;
        double_2 = new Rectangle2D.Double();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Number[] numberArray = contourDataset.getXValues();
        Number[] numberArray2 = contourDataset.getYValues();
        Number[] numberArray3 = contourDataset.getZValues();
        double[] dArray = new double[numberArray.length];
        double[] dArray2 = new double[numberArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = numberArray[i].doubleValue();
            dArray2[i] = numberArray2[i].doubleValue();
        }
        int[] nArray = ((DefaultContourDataset)contourDataset).indexX();
        int[] nArray2 = ((DefaultContourDataset)contourDataset).getXIndices();
        boolean bl = ((NumberAxis)valueAxis2).isInverted();
        boolean bl2 = false;
        if (valueAxis instanceof NumberAxis) {
            bl2 = ((NumberAxis)valueAxis).isInverted();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        int n = nArray[nArray.length - 1];
        for (int i = 0; i < dArray.length; ++i) {
            int n2 = nArray[i];
            if (nArray2[n2] == i) {
                if (n2 == 0) {
                    d2 = d = valueAxis.translateValueToJava2D(dArray[i], rectangle2D, RectangleEdge.BOTTOM);
                    d3 = valueAxis.translateValueToJava2D(dArray[nArray2[n2 + 1]], rectangle2D, RectangleEdge.BOTTOM);
                    d4 = Math.abs(0.5 * (d - d2));
                    d5 = Math.abs(0.5 * (d - d3));
                } else if (n2 == n) {
                    d = valueAxis.translateValueToJava2D(dArray[i], rectangle2D, RectangleEdge.BOTTOM);
                    d2 = valueAxis.translateValueToJava2D(dArray[nArray2[n2 - 1]], rectangle2D, RectangleEdge.BOTTOM);
                    d3 = d;
                    d4 = Math.abs(0.5 * (d - d2));
                    d5 = Math.abs(0.5 * (d - d3));
                } else {
                    d = valueAxis.translateValueToJava2D(dArray[i], rectangle2D, RectangleEdge.BOTTOM);
                    d3 = valueAxis.translateValueToJava2D(dArray[nArray2[n2 + 1]], rectangle2D, RectangleEdge.BOTTOM);
                    d4 = d5;
                    d5 = Math.abs(0.5 * (d - d3));
                }
                d = bl2 ? (d -= d5) : (d -= d4);
                d6 = d4 + d5;
                d8 = d7 = valueAxis2.translateValueToJava2D(dArray2[i], rectangle2D, RectangleEdge.LEFT);
                if (i + 1 == dArray2.length) continue;
                d9 = valueAxis2.translateValueToJava2D(dArray2[i + 1], rectangle2D, RectangleEdge.LEFT);
                d10 = Math.abs(0.5 * (d7 - d8));
                d11 = Math.abs(0.5 * (d7 - d9));
            } else if (n2 < nArray2.length - 1 && nArray2[n2 + 1] - 1 == i || i == dArray.length - 1) {
                d7 = valueAxis2.translateValueToJava2D(dArray2[i], rectangle2D, RectangleEdge.LEFT);
                d8 = valueAxis2.translateValueToJava2D(dArray2[i - 1], rectangle2D, RectangleEdge.LEFT);
                d9 = d7;
                d10 = Math.abs(0.5 * (d7 - d8));
                d11 = Math.abs(0.5 * (d7 - d9));
            } else {
                d7 = valueAxis2.translateValueToJava2D(dArray2[i], rectangle2D, RectangleEdge.LEFT);
                d9 = valueAxis2.translateValueToJava2D(dArray2[i + 1], rectangle2D, RectangleEdge.LEFT);
                d10 = d11;
                d11 = Math.abs(0.5 * (d7 - d9));
            }
            d7 = bl ? (d7 -= d10) : (d7 -= d11);
            d12 = d10 + d11;
            double_2.setRect(d, d7, d6, d12);
            if (numberArray3[i] != null) {
                graphics2D.setPaint(colorBar.getPaint(numberArray3[i].doubleValue()));
                graphics2D.fill(double_2);
            } else if (this.missingPaint != null) {
                graphics2D.setPaint(this.missingPaint);
                graphics2D.fill(double_2);
            }
            double_ = double_2;
            if (entityCollection != null) {
                String string = "";
                if (this.getToolTipGenerator() != null) {
                    string = this.toolTipGenerator.generateToolTip(contourDataset, i);
                }
                String string2 = null;
                ContourEntity contourEntity = new ContourEntity((Rectangle2D.Double)double_.clone(), string, string2);
                contourEntity.setIndex(i);
                entityCollection.addEntity(contourEntity);
            }
            if (contourPlot.isDomainCrosshairLockedOnData()) {
                if (contourPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(dArray[i], dArray2[i], d, d7);
                    continue;
                }
                crosshairInfo.updateCrosshairX(d);
                continue;
            }
            if (!contourPlot.isRangeCrosshairLockedOnData()) continue;
            crosshairInfo.updateCrosshairY(d7);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    public void pointRenderer(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, ContourPlot contourPlot, ValueAxis valueAxis, ValueAxis valueAxis2, ColorBar colorBar, ContourDataset contourDataset, CrosshairInfo crosshairInfo) {
        Ellipse2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Ellipse2D.Double double_2 = new Ellipse2D.Double();
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Number[] numberArray = contourDataset.getXValues();
        Number[] numberArray2 = contourDataset.getYValues();
        Number[] numberArray3 = contourDataset.getZValues();
        double[] dArray = new double[numberArray.length];
        double[] dArray2 = new double[numberArray2.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = numberArray[i].doubleValue();
            dArray2[i] = numberArray2[i].doubleValue();
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = rectangle2D.getWidth() * this.ptSizePct;
        for (int i = 0; i < dArray.length; ++i) {
            d = valueAxis.translateValueToJava2D(dArray[i], rectangle2D, RectangleEdge.BOTTOM) - 0.5 * d5;
            d3 = valueAxis2.translateValueToJava2D(dArray2[i], rectangle2D, RectangleEdge.LEFT) - 0.5 * d5;
            d2 = d5;
            d4 = d5;
            ((RectangularShape)double_2).setFrame(d, d3, d2, d4);
            if (numberArray3[i] != null) {
                graphics2D.setPaint(colorBar.getPaint(numberArray3[i].doubleValue()));
                graphics2D.fill(double_2);
            } else if (this.missingPaint != null) {
                graphics2D.setPaint(this.missingPaint);
                graphics2D.fill(double_2);
            }
            double_ = double_2;
            if (entityCollection != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.toolTipGenerator.generateToolTip(contourDataset, i);
                }
                String string2 = null;
                ContourEntity contourEntity = new ContourEntity((RectangularShape)double_.clone(), string, string2);
                contourEntity.setIndex(i);
                entityCollection.addEntity(contourEntity);
            }
            if (contourPlot.isDomainCrosshairLockedOnData()) {
                if (contourPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(dArray[i], dArray2[i], d, d3);
                    continue;
                }
                crosshairInfo.updateCrosshairX(d);
                continue;
            }
            if (!contourPlot.isRangeCrosshairLockedOnData()) continue;
            crosshairInfo.updateCrosshairY(d3);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D, RectangleEdge.BOTTOM);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D, RectangleEdge.LEFT);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
    }

    public void zoom(double d) {
        if (!(d > 0.0)) {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Contour_Plot");
    }

    public Range getDataRange(ValueAxis valueAxis) {
        if (this.dataset == null) {
            return null;
        }
        Range range = null;
        if (valueAxis == this.getDomainAxis()) {
            range = DatasetUtilities.getDomainExtent(this.dataset);
        } else if (valueAxis == this.getRangeAxis()) {
            range = DatasetUtilities.getRangeExtent(this.dataset);
        }
        return range;
    }

    public Range getContourDataRange() {
        Range range = null;
        ContourDataset contourDataset = this.getDataset();
        if (contourDataset != null) {
            Range range2 = this.getDomainAxis().getRange();
            Range range3 = this.getRangeAxis().getRange();
            range = this.visibleRange(contourDataset, range2, range3);
        }
        return range;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.colorBar != null) {
            this.colorBar.configure(this);
        }
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    public ColorBar getColorBar() {
        return this.colorBar;
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ContourToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(ContourToolTipGenerator contourToolTipGenerator) {
        this.toolTipGenerator = contourToolTipGenerator;
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        this.urlGenerator = xYURLGenerator;
    }

    public void drawDomainMarker(Graphics2D graphics2D, ContourPlot contourPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D, RectangleEdge.BOTTOM);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, ContourPlot contourPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D, RectangleEdge.LEFT);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public ClipPath getClipPath() {
        return this.clipPath;
    }

    public void setClipPath(ClipPath clipPath) {
        this.clipPath = clipPath;
    }

    public double getPtSizePct() {
        return this.ptSizePct;
    }

    public boolean isRenderAsPoints() {
        return this.renderAsPoints;
    }

    public void setPtSizePct(double d) {
        this.ptSizePct = d;
    }

    public void setRenderAsPoints(boolean bl) {
        this.renderAsPoints = bl;
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        Object object = axisChangeEvent.getSource();
        if (object.equals(this.rangeAxis) || object.equals(this.domainAxis)) {
            ColorBar colorBar = this.colorBar;
            if (this.colorBar.getAxis().isAutoRange()) {
                colorBar.getAxis().configure();
            }
        }
        super.axisChanged(axisChangeEvent);
    }

    public Range visibleRange(ContourDataset contourDataset, Range range, Range range2) {
        Range range3 = null;
        range3 = ((DefaultContourDataset)contourDataset).getZValueRange(range, range2);
        return range3;
    }

    public Paint getMissingPaint() {
        return this.missingPaint;
    }

    public void setMissingPaint(Paint paint) {
        this.missingPaint = paint;
    }

    public void zoomHorizontalAxes(double d) {
    }

    public void zoomHorizontalAxes(double d, double d2) {
    }

    public void zoomVerticalAxes(double d) {
    }

    public void zoomVerticalAxes(double d, double d2) {
    }

    public Object clone() throws CloneNotSupportedException {
        ContourPlot contourPlot = (ContourPlot)super.clone();
        if (this.domainAxis != null) {
            contourPlot.domainAxis = (ValueAxis)this.domainAxis.clone();
            contourPlot.domainAxis.setPlot(contourPlot);
            contourPlot.domainAxis.addChangeListener(contourPlot);
        }
        if (this.rangeAxis != null) {
            contourPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            contourPlot.rangeAxis.setPlot(contourPlot);
            contourPlot.rangeAxis.addChangeListener(contourPlot);
        }
        if (contourPlot.dataset != null) {
            contourPlot.dataset.addChangeListener(contourPlot);
        }
        if (this.colorBar != null) {
            contourPlot.colorBar = (ColorBar)this.colorBar.clone();
        }
        contourPlot.domainMarkers = ObjectUtils.clone((List)this.domainMarkers);
        contourPlot.rangeMarkers = ObjectUtils.clone((List)this.rangeMarkers);
        contourPlot.annotations = ObjectUtils.clone((List)this.annotations);
        if (this.clipPath != null) {
            contourPlot.clipPath = (ClipPath)this.clipPath.clone();
        }
        return contourPlot;
    }
}

