/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.plugins.jfreechart;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import javax.swing.JTabbedPane;
import jsynoptic.base.Linkable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import simtools.diagram.Resizable;
import simtools.shapes.AbstractShape;
import simtools.shapes.ShapeListener;

public class ChartShape
extends AbstractShape
implements Serializable,
Resizable,
ChartChangeListener,
ObjectInputValidation,
Linkable {
    static final long serialVersionUID = -5954721943791327034L;
    protected JFreeChart chart;
    protected transient ChartRenderingInfo chartRenderingInfo;
    protected String link;

    public String getLink() {
        return this.link;
    }

    public void setLink(String string) {
        this.link = string;
    }

    public synchronized void removeListener(ShapeListener shapeListener) {
        super.removeListener(shapeListener);
        if (this.listeners.size() == 0 && this.chart != null) {
            this.chart.removeChangeListener((ChartChangeListener)this);
        }
    }

    public ChartShape(JFreeChart jFreeChart, int n, int n2, int n3, int n4) {
        super(n, n2);
        this.chart = jFreeChart;
        this._w = n3;
        this._h = n4;
        if (jFreeChart != null) {
            jFreeChart.addChangeListener((ChartChangeListener)this);
        }
    }

    public void draw(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        if (this.chartRenderingInfo == null) {
            this.chartRenderingInfo = new ChartRenderingInfo();
        }
        this.chart.draw(graphics2D, (Rectangle2D)new Rectangle2D.Double(this._ox, this._oy - this._h, this._w, this._h), this.chartRenderingInfo);
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public void resize(int n, int n2) {
        this._w += n;
        this._h += n2;
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.notifyChange();
    }

    protected AbstractShape cloneShape() {
        ChartShape chartShape = (ChartShape)super.cloneShape();
        try {
            chartShape.chart = (JFreeChart)this.chart.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            chartShape.chart = this.chart;
        }
        if (chartShape.chart != null) {
            chartShape.chart.addChangeListener((ChartChangeListener)chartShape);
        }
        return chartShape;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        objectInputStream.registerValidation(this, 15);
    }

    public void validateObject() throws InvalidObjectException {
        if (this.chart != null) {
            this.chart.addChangeListener((ChartChangeListener)this);
        }
    }

    protected JTabbedPane findTab(Container container) {
        int n;
        Component[] componentArray = container.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            if (!(componentArray[n] instanceof JTabbedPane)) continue;
            return (JTabbedPane)componentArray[n];
        }
        for (n = 0; n < componentArray.length; ++n) {
            JTabbedPane jTabbedPane = null;
            if (componentArray[n] instanceof Container) {
                jTabbedPane = this.findTab((Container)componentArray[n]);
            }
            if (jTabbedPane == null) continue;
            return jTabbedPane;
        }
        return null;
    }

    public void debugContainer(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            System.out.println(componentArray[i]);
            if (!(componentArray[i] instanceof Container)) continue;
            this.debugContainer((Container)componentArray[i]);
        }
    }
}

