/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class KunststoffMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new KunststoffMenuUI();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        Container container = this.menuItem.getParent();
        if (jComponent.isOpaque() && container != null && container instanceof JMenuBar) {
            Rectangle rectangle;
            Serializable serializable;
            Color color;
            Point point = jComponent.getLocation();
            Graphics2D graphics2D = (Graphics2D)graphics;
            ColorUIResource colorUIResource = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorUIResource != null) {
                color = KunststoffUtilities.getTranslucentColor(colorUIResource, 0);
                serializable = new Rectangle(0, 0, container.getWidth(), container.getHeight() / 2);
                rectangle = new Rectangle(0, -point.y, container.getWidth(), container.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, colorUIResource, color, (Rectangle)serializable, rectangle, true);
            }
            if ((color = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                serializable = KunststoffUtilities.getTranslucentColor(color, 0);
                rectangle = new Rectangle(0, container.getHeight() / 2, container.getWidth(), container.getHeight() / 2);
                Rectangle rectangle2 = new Rectangle(0, container.getHeight() / 2 - point.y, container.getWidth(), container.getHeight() / 2);
                KunststoffUtilities.drawGradient(graphics, serializable, color, rectangle, rectangle2, true);
            }
        }
    }
}

