/*
 * Decompiled with CFR 0.152.
 */
package kawa;

import gnu.expr.Compilation;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.kawa.util.FString;
import gnu.kawa.util.FVector;
import gnu.mapping.Environment;
import gnu.mapping.Future;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure0or1;
import gnu.mapping.TtyInPort;
import gnu.text.SourceMessages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import kawa.Shell;
import kawa.SocketRepl;
import kawa.Telnet;
import kawa.TelnetInputStream;
import kawa.TelnetOutputStream;
import kawa.Version;
import kawa.lang.CompileFile;

public class repl
extends Procedure0or1 {
    public static String compilationDirectory = null;
    public static String compilationTopname = null;
    public static String compilationPrefix = null;
    Interpreter interp;
    public static FVector commandLineArguments;
    public static String homeDirectory;

    public repl(Interpreter interpreter) {
        this.interp = interpreter;
    }

    public Object apply0() {
        Shell.run(this.interp, Environment.getCurrent());
        return Interpreter.voidObject;
    }

    public Object apply1(Object object2) {
        Shell.run(this.interp, (Environment)object2);
        return Interpreter.voidObject;
    }

    static void bad_option(String string) {
        System.err.println("kawa: bad option `" + string + "'");
        System.exit(-1);
    }

    static void checkInitFile() {
        if (homeDirectory == null) {
            Serializable serializable;
            homeDirectory = System.getProperty("user.home");
            if (homeDirectory != null) {
                serializable = new FString(homeDirectory);
                String string = System.getProperty("file.separator");
                String string2 = "/".equals(string) ? ".kawarc.scm" : "kawarc.scm";
                File file = new File(homeDirectory, string2);
                if (file.exists()) {
                    Shell.runFile(file.getPath());
                }
            } else {
                serializable = Interpreter.falseObject;
            }
            Environment.define_global("home-directory", serializable);
        }
    }

    public static Interpreter getInterpreter() {
        if (Interpreter.defaultInterpreter == null) {
            Interpreter.defaultInterpreter = Interpreter.getInstance(null);
            Environment.setCurrent(Interpreter.defaultInterpreter.getEnvironment());
        }
        return Interpreter.defaultInterpreter;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (string.equals("-c") || string.equals("-e")) {
                if (++n == stringArray.length) {
                    repl.bad_option(string);
                }
                repl.getInterpreter();
                repl.setArgs(stringArray, n + 1);
                if (string.equals("-c")) {
                    repl.checkInitFile();
                }
                Shell.runString(stringArray[n], Interpreter.defaultInterpreter, Environment.getCurrent());
                bl = true;
            } else if (string.equals("-f")) {
                if (++n == stringArray.length) {
                    repl.bad_option(string);
                }
                repl.getInterpreter();
                repl.setArgs(stringArray, n + 1);
                repl.checkInitFile();
                Shell.runFile(stringArray[n]);
                bl = true;
            } else {
                if (string.equals("-s") || string.equals("--")) {
                    repl.getInterpreter();
                    repl.setArgs(stringArray, ++n);
                    repl.checkInitFile();
                    Shell.run(Interpreter.defaultInterpreter, Environment.getCurrent());
                    return;
                }
                if (string.equals("-w")) {
                    repl.getInterpreter();
                    repl.setArgs(stringArray, n);
                    repl.checkInitFile();
                    try {
                        Class.forName("kawa.GuiConsole").newInstance();
                    }
                    catch (Exception exception) {
                        System.err.println("failed to create Kawa window: " + exception);
                        System.exit(-1);
                    }
                    bl = true;
                } else if (string.equals("-d")) {
                    if (++n == stringArray.length) {
                        repl.bad_option(string);
                    }
                    compilationDirectory = stringArray[n];
                } else if (string.equals("-P")) {
                    if (++n == stringArray.length) {
                        repl.bad_option(string);
                    }
                    compilationPrefix = stringArray[n];
                } else if (string.equals("-T")) {
                    if (++n == stringArray.length) {
                        repl.bad_option(string);
                    }
                    compilationTopname = stringArray[n];
                } else {
                    Object object2;
                    Object object3;
                    if (string.equals("-C")) {
                        repl.getInterpreter();
                        if (++n == stringArray.length) {
                            repl.bad_option(string);
                        }
                        while (n < stringArray.length) {
                            string = stringArray[n];
                            try {
                                System.err.println("(compiling " + string + ")");
                                SourceMessages sourceMessages = new SourceMessages();
                                CompileFile.compile_to_files(string, compilationDirectory, compilationPrefix, compilationTopname, sourceMessages);
                                boolean bl2 = sourceMessages.seenErrors();
                                sourceMessages.checkErrors(System.err, 50);
                                if (bl2) {
                                    System.exit(-1);
                                }
                            }
                            catch (Throwable throwable) {
                                System.err.println("Internal error while compiling " + string);
                                throwable.printStackTrace(System.err);
                                System.exit(-1);
                            }
                            ++n;
                        }
                        return;
                    }
                    if (string.equals("--connect")) {
                        int n2;
                        repl.getInterpreter();
                        if (++n == stringArray.length) {
                            repl.bad_option(string);
                        }
                        if (stringArray[n].equals("-")) {
                            n2 = 0;
                        } else {
                            try {
                                n2 = Integer.parseInt(stringArray[n]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                repl.bad_option("--connect port#");
                                n2 = -1;
                            }
                        }
                        try {
                            object3 = new Socket("localhost", n2);
                            object2 = new Telnet((Socket)object3, true);
                            TelnetInputStream telnetInputStream = ((Telnet)object2).getInputStream();
                            TelnetOutputStream telnetOutputStream = ((Telnet)object2).getOutputStream();
                            PrintStream printStream = new PrintStream(telnetOutputStream, true);
                            System.setIn(telnetInputStream);
                            System.setOut(printStream);
                            System.setErr(printStream);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace(System.err);
                            throw new Error(iOException.toString());
                        }
                    }
                    if (string.equals("--server")) {
                        int n3;
                        repl.getInterpreter();
                        if (++n == stringArray.length) {
                            repl.bad_option(string);
                        }
                        if (stringArray[n].equals("-")) {
                            n3 = 0;
                        } else {
                            try {
                                n3 = Integer.parseInt(stringArray[n]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                repl.bad_option("--server port#");
                                n3 = -1;
                            }
                        }
                        try {
                            object3 = new ServerSocket(n3);
                            n3 = ((ServerSocket)object3).getLocalPort();
                            System.err.println("Listening on port " + n3);
                            while (true) {
                                System.err.print("waiting ... ");
                                System.err.flush();
                                object2 = ((ServerSocket)object3).accept();
                                System.err.println("got connection from " + ((Socket)object2).getInetAddress() + " port:" + ((Socket)object2).getPort());
                                repl.serveTelnet(Interpreter.defaultInterpreter, (Socket)object2);
                            }
                        }
                        catch (IOException iOException) {
                            throw new Error(iOException.toString());
                        }
                    }
                    if (string.equals("--main")) {
                        Compilation.generateMainDefault = true;
                    } else if (string.equals("--applet")) {
                        Compilation.generateAppletDefault = true;
                    } else if (string.equals("--debug-dump-zip")) {
                        LambdaExp.dumpZipPrefix = "kawa-zip-dump-";
                    } else if (string.equals("--module-static")) {
                        Compilation.moduleStatic = 1;
                    } else if (string.equals("--fewer-classes")) {
                        Compilation.fewerClasses = true;
                    } else if (string.equals("--cps")) {
                        Compilation.fewerClasses = true;
                        Compilation.usingCPStyle = true;
                    } else if (string.equals("--full-tailcalls")) {
                        Compilation.usingTailCalls = true;
                    } else if (string.equals("--no-full-tailcalls")) {
                        Compilation.usingTailCalls = false;
                    } else if (string.equals("--version")) {
                        System.out.print("Kawa ");
                        System.out.print(Version.getVersion());
                        System.out.println();
                        System.out.println("Copyright (C) 2000 Per Bothner");
                        bl = true;
                    } else {
                        if (string.length() <= 0 || string.charAt(0) != '-') break;
                        Interpreter interpreter = Interpreter.defaultInterpreter;
                        object3 = string;
                        if (((String)object3).length() > 2 && ((String)object3).charAt(0) == '-') {
                            object3 = ((String)object3).substring(((String)object3).charAt(1) == '-' ? 2 : 1);
                        }
                        if ((object2 = Interpreter.getInstance((String)object3)) == null) {
                            repl.bad_option(string);
                        } else {
                            Interpreter.defaultInterpreter = object2;
                            if (interpreter == null) {
                                Environment.setCurrent(((Interpreter)object2).getEnvironment());
                            }
                        }
                    }
                }
            }
            ++n;
        }
        if (bl) {
            return;
        }
        repl.getInterpreter();
        if (n < stringArray.length) {
            repl.setArgs(stringArray, n + 1);
            repl.checkInitFile();
            Shell.runFile(stringArray[n]);
        } else {
            repl.setArgs(stringArray, n);
            repl.checkInitFile();
            Shell.run(Interpreter.defaultInterpreter);
        }
    }

    static void serveTelnet(Interpreter interpreter, Socket socket) throws IOException {
        Telnet telnet = new Telnet(socket, true);
        TelnetOutputStream telnetOutputStream = telnet.getOutputStream();
        TelnetInputStream telnetInputStream = telnet.getInputStream();
        OutPort outPort = new OutPort(telnetOutputStream);
        TtyInPort ttyInPort = new TtyInPort((InputStream)telnetInputStream, "<stdin>", outPort);
        Future future = new Future(new SocketRepl(interpreter, socket), interpreter.getEnvironment(), ttyInPort, outPort, outPort);
        future.start();
    }

    public static void setArgs(String[] stringArray, int n) {
        Object[] objectArray = new Object[stringArray.length - n];
        int n2 = n;
        while (n2 < stringArray.length) {
            objectArray[n2 - n] = new FString(stringArray[n2]);
            ++n2;
        }
        commandLineArguments = new FVector(objectArray);
        Environment.define_global("command-line-arguments", commandLineArguments);
    }
}

