/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Binding;
import gnu.mapping.Binding2;
import gnu.mapping.BindingEnumeration;
import gnu.mapping.Constraint;
import gnu.mapping.Future;
import gnu.mapping.NameMap;
import gnu.mapping.TrivialConstraint;
import gnu.mapping.UnboundConstraint;
import gnu.mapping.UnboundSymbol;

public class Environment
extends NameMap {
    Binding[] table;
    int log2Size = 4;
    private int mask;
    int num_bindings;
    private static Environment global;
    Environment previous;
    protected TrivialConstraint trivialConstraint = new TrivialConstraint(this);
    protected Constraint unboundConstraint = new UnboundConstraint(this);

    public Environment() {
        this(64);
    }

    public Environment(int n) {
        while (n > 1 << this.log2Size) {
            ++this.log2Size;
        }
        n = 1 << this.log2Size;
        this.table = new Binding[n];
        this.mask = n - 1;
    }

    public Environment(Environment environment) {
        this();
        this.previous = environment;
    }

    public void addBinding(Binding binding) {
        if (3 * this.num_bindings >= 2 * this.table.length) {
            this.rehash();
        }
        if (Binding.hashSet(this.table, this.log2Size, binding) == null) {
            ++this.num_bindings;
        }
    }

    public Binding addBinding(String string, Object object2) {
        Binding binding = new Binding(string);
        binding.constraint = this.trivialConstraint;
        binding.value = object2;
        this.addBinding(binding);
        return binding;
    }

    public static Environment current() {
        return Environment.getCurrent();
    }

    public Binding define(String string, Object object2) {
        return this.defineValue(string, object2);
    }

    public static void defineFunction(Environment environment, String string, Object object2) {
        Binding2 binding2 = Binding2.getBinding2(environment, string);
        binding2.functionValue = object2;
    }

    public static void defineFunction(String string, Object object2) {
        Environment.defineFunction(Environment.user(), string, object2);
    }

    public Binding defineValue(String string, Object object2) {
        Binding binding = this.getBinding(string);
        binding.constraint = this.trivialConstraint;
        binding.value = object2;
        return binding;
    }

    public static void define_global(String string, Object object2) {
        Environment.user().defineValue(string, object2);
    }

    public BindingEnumeration enumerateAllBindings() {
        return new BindingEnumeration(this);
    }

    public BindingEnumeration enumerateBindings() {
        return new BindingEnumeration(this.table, 1 << this.log2Size);
    }

    public Binding getBinding(String string) {
        Binding binding = this.lookup(string);
        if (binding != null) {
            return binding;
        }
        binding = this.addBinding(string, null);
        binding.constraint = this.unboundConstraint;
        return binding;
    }

    public Object getChecked(String string) {
        Binding binding = this.lookup(string);
        if (binding == null) {
            throw new UnboundSymbol(string);
        }
        return binding.get();
    }

    public static Environment getCurrent() {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            return ((Future)thread2).environment;
        }
        return global;
    }

    public static Binding getCurrentBinding(String string) {
        return Environment.getCurrent().getBinding(string);
    }

    public Object getFunction(String string) {
        return this.getChecked(string);
    }

    public Binding lookup(String string) {
        return this.lookup(string, System.identityHashCode(string));
    }

    private Binding lookup(String string, int n) {
        Environment environment = this;
        while (environment != null) {
            int n2 = Binding.hashSearch(environment.table, environment.log2Size, environment.mask, string, n);
            Binding binding = environment.table[n2];
            if (binding != null && binding != Binding.hashDELETED) {
                return binding;
            }
            environment = environment.previous;
        }
        return null;
    }

    public static Object lookup_global(String string) throws UnboundSymbol {
        Binding binding = Environment.user().lookup(string);
        if (binding == null) {
            throw new UnboundSymbol(string);
        }
        return binding.get();
    }

    public Object put(Object object2, Object object3) {
        return this.put((String)object2, object3);
    }

    public Object put(String string, Object object2) {
        Binding binding = this.lookup(string);
        if (binding == null) {
            this.define(string, object2);
            return null;
        }
        if (!binding.isBound()) {
            binding.set(object2);
            return null;
        }
        Object object3 = binding.get();
        binding.set(object2);
        return object3;
    }

    public void putFunction(String string, Object object2) {
        this.put(string, object2);
    }

    public static void put_global(String string, Object object2) {
        Environment.user().put(string, object2);
    }

    void rehash() {
        int n = 2 * this.table.length;
        Binding[] bindingArray = new Binding[n];
        Binding.hashInsertAll(bindingArray, this.log2Size + 1, this.table, this.log2Size);
        this.table = bindingArray;
        ++this.log2Size;
        this.mask = this.mask << 1 | 1;
    }

    public void remove(Binding binding) {
        Binding.hashDelete(this.table, this.log2Size, binding.getName());
    }

    public Object remove(Object object2) {
        return this.remove((String)object2);
    }

    public Object remove(String string) {
        Environment environment = this;
        while (environment != null) {
            Binding[] bindingArray = environment.table;
            Binding binding = Binding.hashDelete(environment.table, environment.log2Size, string);
            if (binding != null) {
                return binding;
            }
            environment = environment.previous;
        }
        return null;
    }

    public static void setCurrent(Environment environment) {
        Thread thread2 = Thread.currentThread();
        if (thread2 instanceof Future) {
            ((Future)thread2).environment = environment;
        } else {
            global = environment;
        }
    }

    public String toString() {
        String string = this.getName();
        if (string == null) {
            string = super.toString();
        }
        return "#<environment " + string + '>';
    }

    public static Environment user() {
        return Environment.current();
    }
}

