/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.util;

import gnu.kawa.util.AbstractString;
import java.io.IOException;
import java.io.Writer;

public class CharBuffer
extends AbstractString {
    static final int START_POSITION = 0;
    static final int END_POSITION = 1;
    public char[] array;
    public int gapStart;
    public int gapEnd;
    static final int[] noInts = new int[0];
    protected int[] positions = noInts;

    public CharBuffer(int n) {
        this.array = new char[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public CharBuffer(int n, char c) {
        this(n, c, n);
    }

    public CharBuffer(int n, char c, int n2) {
        if (n > n2) {
            n2 = n;
        }
        this.array = new char[n2];
        this.gapStart = n;
        this.gapEnd = n2;
        int n3 = n;
        while (--n3 >= 0) {
            this.array[n3] = c;
        }
    }

    public CharBuffer(char[] cArray, int n, int n2) {
        this(cArray, n, n2, n2);
    }

    public CharBuffer(char[] cArray, int n, int n2, int n3) {
        if (n2 > n3) {
            n3 = n2;
        }
        this.array = new char[n3];
        this.gapStart = 0;
        this.gapEnd = n2;
        System.arraycopy(cArray, n, this.array, 0, n2);
    }

    public final char charAt(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        return this.array[n];
    }

    public int copyPosition(int n) {
        if (n == 0) {
            return n;
        }
        return this.createPosition(this.getPositionOffset(n), this.getPositionKind(n));
    }

    public synchronized int createPosition(int n, int n2) {
        int n3 = this.positions.length;
        if (n3 == 0) {
            n3 = 10;
            this.positions = new int[n3];
            this.positions[0] = 0;
            this.positions[1] = this.length() << 2 | 2;
        }
        if (n2 == 0 && n == 0) {
            return 0;
        }
        if (n2 == 2 && n == this.length()) {
            return 1;
        }
        int n4 = 2;
        while (n4 < n3) {
            if (this.positions[n4] == 0) break;
            ++n4;
        }
        if (n4 >= n3) {
            int[] nArray = new int[n3 * 2];
            System.arraycopy(this.positions, 0, nArray, 0, n3);
            this.positions = nArray;
        }
        this.positions[n4] = (n << 2) + n2;
        return n4;
    }

    public void delete(int n, int n2) {
        int n3 = n2 << 2;
        int n4 = n << 2;
        int n5 = n + 1 << 2;
        int n6 = n + n2 << 2;
        int n7 = this.positions.length;
        while (--n7 >= 0) {
            int n8 = this.positions[n7];
            if (n8 < n5) continue;
            this.positions[n7] = n8 >= n6 ? n8 - n3 : n4 | n8 & 3;
        }
        if (n != this.gapStart) {
            this.shiftGap(n);
        }
        this.gapEnd += n2;
    }

    public final void fill(char c) {
        int n = this.array.length;
        while (--n >= this.gapEnd) {
            this.array[n] = c;
        }
        int n2 = this.gapStart;
        while (--n2 >= 0) {
            this.array[n2] = c;
        }
    }

    protected void gapReserve(int n, int n2) {
        int n3 = this.length();
        if (n3 + n2 > this.array.length) {
            int n4 = n3 + n2 + 100;
            int n5 = n3 < 20000 ? 2 * n3 : n3 + 4000;
            if (n4 > n5) {
                n5 = n4 + 500;
            }
            char[] cArray = new char[n5];
            if (n <= this.gapStart) {
                System.arraycopy(this.array, 0, cArray, 0, n);
                int n6 = this.gapStart - n;
                int n7 = this.array.length - this.gapEnd;
                int n8 = n5 - n7 - n6;
                System.arraycopy(this.array, n, cArray, n8, n6);
                System.arraycopy(this.array, this.gapEnd, cArray, n5 - n7, n7);
                this.gapEnd = n8;
            } else {
                System.arraycopy(this.array, 0, cArray, 0, this.gapStart);
                System.arraycopy(this.array, this.gapEnd, cArray, this.gapStart, n - this.gapStart);
                int n9 = n + (this.gapEnd - this.gapStart);
                int n10 = this.array.length - n9;
                this.gapEnd = n5 - n10;
                System.arraycopy(this.array, n9, cArray, this.gapEnd, n10);
            }
            this.array = cArray;
            this.gapStart = n;
        } else if (n != this.gapStart) {
            this.shiftGap(n);
        }
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        int n4 = n2 - n;
        if (n < this.gapStart) {
            int n5 = this.gapStart - n;
            if (n5 > n4) {
                n5 = n4;
            }
            n4 -= n5;
            System.arraycopy(this.array, n, cArray, n3, n5);
            n3 += n5;
            n += n5;
        }
        if ((n += this.gapEnd - this.gapStart) >= this.gapEnd && n4 != 0) {
            System.arraycopy(this.array, n, cArray, n3, n4);
        }
    }

    public int getPositionKind(int n) {
        return this.positions[n] & 3;
    }

    public int getPositionOffset(int n) {
        return this.positions[n] >> 2;
    }

    protected void insert(int n, int n2, boolean bl) {
        int n3 = n << 2;
        if (!bl) {
            ++n3;
        }
        int n4 = n2 << 2;
        int n5 = this.positions.length;
        while (--n5 >= 0) {
            int n6 = this.positions[n5];
            if (n6 <= n3) continue;
            this.positions[n5] = n6 + n4;
        }
        this.gapReserve(n, n2);
        this.gapStart += n2;
    }

    public final int length() {
        return this.array.length - (this.gapEnd - this.gapStart);
    }

    public void releasePosition(int n) {
        if (n > 1) {
            this.positions[n] = 0;
        }
    }

    public void replace(int n, String string) {
        int n2 = string.length();
        if (n + n2 > this.gapStart) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            } else {
                this.shiftGap(n + n2);
            }
        }
        string.getChars(0, n2, this.array, n);
    }

    public void replace(int n, char[] cArray, int n2, int n3) {
        if (n + n3 > this.gapStart) {
            if (n >= this.gapStart) {
                n += this.gapEnd - this.gapStart;
            } else {
                this.shiftGap(n + n3);
            }
        }
        System.arraycopy(cArray, n2, this.array, n, n3);
    }

    public void setCharAt(int n, char c) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        this.array[n] = c;
    }

    protected void shiftGap(int n) {
        int n2 = n - this.gapStart;
        if (n2 > 0) {
            System.arraycopy(this.array, this.gapEnd, this.array, this.gapStart, n2);
        } else if (n2 < 0) {
            System.arraycopy(this.array, n, this.array, this.gapEnd + n2, -n2);
        }
        this.gapEnd += n2;
        this.gapStart = n;
    }

    public String toString() {
        if (this.gapStart == 0) {
            return new String(this.array, this.gapEnd, this.array.length - this.gapEnd);
        }
        int n = this.array.length - this.gapEnd;
        if (n != 0) {
            this.shiftGap(n + this.gapStart);
        }
        return new String(this.array, 0, this.gapStart);
    }

    public void writeTo(int n, int n2, Writer writer) throws IOException {
        int n3;
        if (n < this.gapStart) {
            n3 = this.gapStart - n;
            if (n2 != -1) {
                if (n3 > n2) {
                    n3 = n2;
                }
                n2 -= n3;
            }
            writer.write(this.array, n, n3);
            n += n3;
        }
        if ((n += this.gapEnd - this.gapStart) >= this.gapEnd) {
            n3 = this.array.length - n;
            if (n2 != -1 && n3 > n2) {
                n3 = n2;
            }
            writer.write(this.array, n, n3);
        }
    }
}

