/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpFullWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ObjectExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;

public class FindTailCalls
extends ExpFullWalker {
    boolean inTailContext = true;

    public static void findTailCalls(Expression expression) {
        FindTailCalls findTailCalls = new FindTailCalls();
        expression.walk(findTailCalls);
    }

    public Object walkApplyExp(ApplyExp applyExp) {
        if (this.inTailContext) {
            applyExp.setTailCall(true);
        }
        applyExp.context = this.currentLambda;
        boolean bl = this.inTailContext;
        LambdaExp lambdaExp = null;
        try {
            this.inTailContext = false;
            if (applyExp.func instanceof ReferenceExp) {
                ReferenceExp referenceExp = (ReferenceExp)applyExp.func;
                Declaration declaration = Declaration.followAliases(referenceExp.binding);
                if (declaration != null) {
                    applyExp.nextCall = declaration.firstCall;
                    declaration.firstCall = applyExp;
                    declaration.setCanCall();
                    Expression expression = declaration.getValue();
                    if (expression instanceof LambdaExp) {
                        lambdaExp = (LambdaExp)expression;
                    }
                }
            } else if (applyExp.func instanceof LambdaExp) {
                lambdaExp = (LambdaExp)applyExp.func;
                this.walkLambdaExp(lambdaExp, false);
                lambdaExp.setCanCall(true);
            } else {
                applyExp.func = (Expression)applyExp.func.walk(this);
            }
            if (!(lambdaExp == null || lambdaExp.returnContinuation == applyExp || lambdaExp == this.currentLambda && bl)) {
                lambdaExp.returnContinuation = lambdaExp.returnContinuation == null ? applyExp : LambdaExp.unknownContinuation;
            }
            applyExp.args = this.walkExps(applyExp.args);
            ApplyExp applyExp2 = applyExp;
            Object var6_8 = null;
            this.inTailContext = bl;
            return applyExp2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            this.inTailContext = bl;
            throw throwable;
        }
    }

    public Object walkBeginExp(BeginExp beginExp) {
        boolean bl = this.inTailContext;
        try {
            int n = beginExp.exps.length - 1;
            int n2 = 0;
            while (n2 <= n) {
                this.inTailContext = n2 == n && bl;
                beginExp.exps[n2] = (Expression)beginExp.exps[n2].walk(this);
                ++n2;
            }
            BeginExp beginExp2 = beginExp;
            Object var5_6 = null;
            this.inTailContext = bl;
            return beginExp2;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.inTailContext = bl;
            throw throwable;
        }
    }

    public void walkDecls(ScopeExp scopeExp) {
        Declaration declaration = scopeExp.firstDecl();
        while (declaration != null) {
            Expression expression = declaration.getValue();
            if (expression != null && expression instanceof LambdaExp) {
                LambdaExp lambdaExp = (LambdaExp)expression;
                if (declaration.getCanRead()) {
                    lambdaExp.setCanRead(true);
                }
                if (declaration.getCanCall()) {
                    lambdaExp.setCanCall(true);
                }
            }
            declaration = declaration.nextDecl();
        }
    }

    public Object walkFluidLetExp(FluidLetExp fluidLetExp) {
        Declaration declaration = fluidLetExp.firstDecl();
        while (declaration != null) {
            declaration.setCanRead(true);
            declaration.setCanWrite(true);
            declaration = declaration.nextDecl();
        }
        return super.walkFluidLetExp(fluidLetExp);
    }

    public Object walkIfExp(IfExp ifExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            ifExp.test = (Expression)ifExp.test.walk(this);
        }
        finally {
            Object var4_3 = null;
            this.inTailContext = bl;
        }
        ifExp.then_clause = (Expression)ifExp.then_clause.walk(this);
        Expression expression = ifExp.else_clause;
        if (expression != null) {
            ifExp.else_clause = (Expression)expression.walk(this);
        }
        return ifExp;
    }

    public Object walkLambdaExp(LambdaExp lambdaExp) {
        this.walkLambdaExp(lambdaExp, true);
        return lambdaExp;
    }

    final void walkLambdaExp(LambdaExp lambdaExp, boolean bl) {
        LambdaExp lambdaExp2;
        boolean bl2;
        block10: {
            bl2 = this.inTailContext;
            lambdaExp2 = this.currentLambda;
            this.currentLambda = lambdaExp;
            if (bl) {
                lambdaExp.setCanRead(true);
            }
            try {
                this.inTailContext = false;
                if (lambdaExp.defaultArgs != null) {
                    lambdaExp.defaultArgs = this.walkExps(lambdaExp.defaultArgs);
                }
                this.inTailContext = true;
                if (this.exitValue != null || lambdaExp.body == null) break block10;
                lambdaExp.body = (Expression)lambdaExp.body.walk(this);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.inTailContext = bl2;
                this.currentLambda = lambdaExp2;
                throw throwable;
            }
        }
        Expression expression = null;
        this.inTailContext = bl2;
        this.currentLambda = lambdaExp2;
        LambdaExp lambdaExp3 = lambdaExp.firstChild;
        while (lambdaExp3 != null) {
            if (lambdaExp3.getCanRead() || lambdaExp3.min_args != lambdaExp3.max_args) {
                lambdaExp3.flags |= 0x20;
            } else {
                expression = lambdaExp3.returnContinuation;
                if (expression != LambdaExp.unknownContinuation && !Compilation.usingCPStyle()) {
                    lambdaExp3.setInlineOnly(true);
                }
            }
            lambdaExp3 = lambdaExp3.nextSibling;
        }
        expression = lambdaExp.firstChild;
        while (expression != null) {
            if ((expression.flags & 0x21) != 0) {
                // empty if block
            }
            expression = expression.nextSibling;
        }
    }

    public Object walkLetExp(LetExp letExp) {
        int n = letExp.inits.length;
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration declaration = letExp.firstDecl();
            int n2 = 0;
            while (n2 < n) {
                letExp.inits[n2] = this.walkSetExp(declaration, letExp.inits[n2]);
                ++n2;
                declaration = declaration.nextDecl();
            }
        }
        finally {
            Object var6_6 = null;
            this.inTailContext = bl;
        }
        letExp.body = (Expression)letExp.body.walk(this);
        this.walkDecls(letExp);
        return letExp;
    }

    public Object walkModuleExp(ModuleExp moduleExp) {
        super.walkLambdaExp(moduleExp);
        this.walkDecls(moduleExp);
        return moduleExp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object walkObjectExp(ObjectExp objectExp) {
        boolean bl = this.inTailContext;
        LambdaExp lambdaExp = this.currentLambda;
        this.currentLambda = objectExp;
        objectExp.setCanRead(true);
        try {
            this.inTailContext = false;
            LambdaExp lambdaExp2 = objectExp.firstChild;
            while (lambdaExp2 != null && this.exitValue == null) {
                this.walkLambdaExp(lambdaExp2, false);
                lambdaExp2 = lambdaExp2.nextSibling;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.inTailContext = bl;
            this.currentLambda = lambdaExp;
            throw throwable;
        }
        Object var5_5 = null;
        this.inTailContext = bl;
        this.currentLambda = lambdaExp;
        return objectExp;
    }

    public Object walkReferenceExp(ReferenceExp referenceExp) {
        Declaration declaration = Declaration.followAliases(referenceExp.binding);
        if (declaration != null) {
            declaration.setCanRead(true);
        }
        return referenceExp;
    }

    final Expression walkSetExp(Declaration declaration, Expression expression) {
        if (declaration != null) {
            declaration.setCanWrite(true);
        }
        if (declaration != null && declaration.getValue() == expression && expression instanceof LambdaExp && !(expression instanceof ObjectExp) && !declaration.isPublic()) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            this.walkLambdaExp(lambdaExp, false);
            return lambdaExp;
        }
        return (Expression)expression.walk(this);
    }

    public Object walkSetExp(SetExp setExp) {
        SetExp setExp2;
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Declaration declaration = setExp.binding;
            if (declaration != null && declaration.isAlias()) {
                if (setExp.isDefining()) {
                    SetExp setExp3 = setExp;
                    Object var5_6 = null;
                    this.inTailContext = bl;
                    return setExp3;
                }
                declaration = Declaration.followAliases(declaration);
            }
            setExp.new_value = this.walkSetExp(declaration, setExp.new_value);
            setExp2 = setExp;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.inTailContext = bl;
            throw throwable;
        }
        Object var5_7 = null;
        this.inTailContext = bl;
        return setExp2;
    }

    public Object walkSynchronizedExp(SynchronizedExp synchronizedExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Object object2 = super.walkSynchronizedExp(synchronizedExp);
            Object var5_4 = null;
            this.inTailContext = bl;
            return object2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inTailContext = bl;
            throw throwable;
        }
    }

    public Object walkTryExp(TryExp tryExp) {
        boolean bl = this.inTailContext;
        try {
            this.inTailContext = false;
            Object object2 = super.walkTryExp(tryExp);
            Object var5_4 = null;
            this.inTailContext = bl;
            return object2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inTailContext = bl;
            throw throwable;
        }
    }
}

