/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;

public class ObjectType
extends Type {
    static final int ADD_FIELDS_DONE = 1;
    static final int ADD_METHODS_DONE = 2;
    static final int EXISTING_CLASS = 4;
    int flags;

    protected ObjectType() {
        this.size = 4;
    }

    ObjectType(String name) {
        this.this_name = name;
        this.size = 4;
    }

    public Object coerceFromObject(Object obj) {
        if (this == Type.string_type) {
            return obj.toString();
        }
        if (obj == null || this.getReflectClass().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        throw new ClassCastException("don't know how to coerce " + obj.getClass().getName() + " to " + this.getName());
    }

    public int compare(Type other) {
        return other == Type.nullType ? 0 : -1;
    }

    public void emitCoerceFromObject(CodeAttr code) {
        if (this == Type.string_type) {
            code.emitInvokeVirtual(Type.toString_method);
        } else if (this != Type.pointer_type) {
            code.emitCheckcast(this);
        }
    }

    public String getNameOrSignature() {
        return this.getName();
    }

    public Class getReflectClass() {
        block3: {
            try {
                if (this.reflectClass == null) {
                    this.reflectClass = Class.forName(this.getNameOrSignature().replace('/', '.'));
                }
                this.flags |= 4;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ((this.flags & 4) == 0) break block3;
                throw new RuntimeException("no such class: " + this.getName());
            }
        }
        return this.reflectClass;
    }
}

