###--- >>> `complex' <<<----- Complex Vectors

	## alias	 help(complex)
	## alias	 help(as.complex)
	## alias	 help(as.complex.default)
	## alias	 help(is.complex)
	## alias	 help(Re)
	## alias	 help(Im)
	## alias	 help(Mod)
	## alias	 help(Arg)
	## alias	 help(Conj)

##___ Examples ___:

( z <- 0i ^ (-3:3) )
all(Re(z) == 0 ^ (-3:3))
matrix(1i^ (-6:5), nr=4)#- all columns are the same
0 ^ 1i # a complex NaN

## create a complex normal vector
z <- complex(real = rnorm(100), imag = rnorm(100))
## or also (less efficiently):
z2 <- 1:2 + 1i*(8:9)

all(Mod ( 1 -  sin(z) / ( (exp(1i*z)-exp(-1i*z))/(2*1i) ))
    < 100*.Machine$double.eps)
## The Arg(.) is an angle:
zz <- (rep(1:4,len=9) + 1i*(9:1))/10
zz.shift <- complex(modulus = Mod(zz), argument= Arg(zz) + pi)
plot(zz, xlim=c(-1,1), ylim=c(-1,1), col="red", asp = 1,
     main = expression(paste("Rotation by "," ", pi == 180^o)))
abline(h=0,v=0, col="blue", lty=3)
points(zz.shift, col="orange")

## Keywords: 'complex'.


