###--- >>> `smooth.spline' <<<----- Fit a Smoothing Spline

	## alias	 help(smooth.spline)
	## alias	 help(predict.smooth.spline.fit)
	## alias	 help(print.smooth.spline)

##___ Examples ___:

data(cars)
attach(cars)
plot(speed, dist, main = "data(cars)  &  smoothing splines")
cars.spl <- smooth.spline(speed, dist)
(cars.spl)
all(cars.spl $ w == table(speed)) # TRUE (weights = multiplicities)

  str(cars.spl, digits=5, vec.len=6)
  cars.spl$fit

lines(cars.spl, col = "blue")
lines(smooth.spline(speed, dist, df=10), lty=2, col = "red")
legend(5,120,c(paste("default [C.V.] => df =",round(cars.spl$df,1)),
               "s( * , df = 10)"), col = c("blue","red"), lty = 1:2,
       bg='bisque')
detach()

## Keywords: 'smooth'.


