<?xml version="1.0" encoding="UTF-8"?>
<!--
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <xsl:param name="letter" select="substring(//sdx:document/sdx:parameters/sdx:parameter[@name='v']/@value, 1, 1)"/>
    <xsl:template name="onload">
    <!-- pris par skin.xsl pour ajouter du code à /html/body/@onload -->
        if (document &amp;&amp; document.forms &amp;&amp; document.forms['letter'] &amp;&amp; document.forms['letter'].v) document.forms['letter'].v.focus(); 
    </xsl:template>
    <!-- list of terms -->
    <xsl:template match="sdx:terms">
        <form action="{//sdx:document/@url}" name="letter">
            <h2>Index des mots cités 
                    <input type="hidden" name="hpp" value="-1"/>
                <input type="hidden" name="f" value="contenu"/>
                <select name="v" onchange="this.form.submit()">
                    <xsl:apply-templates select="document('')/xsl:stylesheet/sdx:select/option"/>
                </select>
                <input style="font-size:60%; font-weight:900" type="submit" value=">"/>
            </h2>
        </form>
        <xsl:apply-templates/>
    </xsl:template>
    <!-- terms indexed from plain text field -->
    <xsl:template match="sdx:term">
        <xsl:choose>
            <xsl:when test="@id">
                <a href="document.xsp?id={@id}&amp;base={@base}&amp;app={@app}">
                    <xsl:value-of select="@value"/>
                </a>
                <xsl:text> - </xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <a href="results.xsp?q={@escapedValue}">
                    <xsl:value-of select="@value"/>
                </a>
                <xsl:text> - </xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <!-- used to iterate on the list below -->
    <xsl:template match="option">
        <option value="{.}*">
            <xsl:if test=". = $letter">
                <xsl:attribute name="selected">selected</xsl:attribute>
            </xsl:if>
            <xsl:value-of select="."/>
        </option>
    </xsl:template>
    <sdx:select>
        <option>a</option>
        <option>b</option>
        <option>c</option>
        <option>d</option>
        <option>e</option>
        <option>f</option>
        <option>g</option>
        <option>h</option>
        <option>i</option>
        <option>j</option>
        <option>k</option>
        <option>l</option>
        <option>m</option>
        <option>n</option>
        <option>o</option>
        <option>p</option>
        <option>q</option>
        <option>r</option>
        <option>s</option>
        <option>t</option>
        <option>u</option>
        <option>v</option>
        <option>w</option>
        <option>x</option>
        <option>y</option>
        <option>z</option>
    </sdx:select>
</xsl:stylesheet>
