/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.database;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.AbstractJDBCDatabase;
import fr.gouv.culture.sdx.utils.database.DatabaseConnection;
import fr.gouv.culture.sdx.utils.database.SQLDatabaseConnection;
import fr.gouv.culture.sdx.utils.rdbms.JDBC;
import fr.gouv.culture.sdx.utils.rdbms.hsql.HSQLDB;
import fr.gouv.culture.sdx.utils.save.SaveParameters;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;

public class HSQLDatabase
extends AbstractJDBCDatabase {
    protected String dbDirPath = null;
    protected HSQLDB hsqldb = null;
    protected String DATABASE_DIR_NAME = "_hsql";

    public String getDatabaseDirectoryName() {
        return this.DATABASE_DIR_NAME;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        if (Utilities.checkString(this.dsi)) {
            return;
        }
        try {
            this.hsqldb = (HSQLDB)Utilities.getObjectFromContext("sdx.application.hsqldb", (Context)this.getContext());
            if (this.hsqldb == null) {
                throw new SDXException(super.getLog(), 305, null, null);
            }
            if (!Utilities.checkString(this.hsqldb.getDbDirPath())) {
                String basePath = Utilities.getStringFromContext("sdx.application.databaseDirPath", (Context)super.getContext());
                if (Utilities.checkString(basePath)) {
                    this.dbDirPath = basePath + this.getDatabaseDirectoryName() + File.separator;
                }
                if (Utilities.checkString(this.dbDirPath)) {
                    Utilities.checkDirectory(this.dbDirPath, super.getLog());
                    this.hsqldb.setDbDirPath(this.dbDirPath);
                }
            }
            this.tableName = super.getId();
        }
        catch (SDXException e) {
            throw new ConfigurationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private synchronized Connection getSQLConnection() throws SDXException {
        if (this.hsqldb == null) {
            throw new SDXException(super.getLog(), 305, null, null);
        }
        return this.hsqldb.getSQLConnection();
    }

    public DatabaseConnection getConnection() throws SDXException {
        if (Utilities.checkString(this.dsi)) {
            return super.getConnection();
        }
        SQLDatabaseConnection dbConn = new SQLDatabaseConnection(this.getSQLConnection());
        dbConn.enableLogging(super.getLog());
        dbConn.setAutoCommit(false);
        return dbConn;
    }

    public void releaseConnection(DatabaseConnection conn) throws SDXException {
        if (Utilities.checkString(this.dsi)) {
            super.releaseConnection(conn);
        }
    }

    protected String getOptimizeQuery() {
        return "CHECKPOINT";
    }

    public synchronized void optimize() throws SDXException {
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = this.getOptimizeQuery();
        try {
            try {
                JDBC.Template template = new JDBC.Template(conn, queryString);
                template.execute(new JDBC.QueryExecutor(){}, 1);
            }
            catch (SDXException e) {
                String[] args = new String[]{super.getId()};
                throw new SDXException(super.getLog(), 314, args, (Throwable)((Object)e));
            }
            Object var7_6 = null;
            this.releaseConnection(sqlDbConn);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.releaseConnection(sqlDbConn);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init() throws SDXException {
        ResultSet rs;
        DatabaseConnection sqldbConn;
        block22: {
            if (this.hsqldb != null) {
                this.hsqldb.registerTableName(this.getTableName());
            }
            sqldbConn = this.getConnection();
            Connection conn = null;
            rs = null;
            Statement ps = null;
            try {
                block21: {
                    try {
                        conn = sqldbConn.getConnection();
                        DatabaseMetaData dbmd = conn.getMetaData();
                        String tableNamePat = "%" + this.getTableName().toUpperCase();
                        rs = dbmd.getTables(null, null, tableNamePat.toUpperCase(), null);
                        if (!rs.next()) {
                            this.createTable(conn);
                            break block21;
                        }
                        String existingTableName = "";
                        boolean tableExists = false;
                        do {
                            int indxTableName;
                            if ((existingTableName = rs.getString("TABLE_NAME")).equals(this.getTableName().toUpperCase())) {
                                tableExists = true;
                                break;
                            }
                            String l_tableName = this.getTableName().toUpperCase();
                            int indxUnderScore = existingTableName.indexOf("_" + l_tableName);
                            int endIndx = existingTableName.lastIndexOf("_" + l_tableName);
                            if (existingTableName.startsWith("sdx_") || indxUnderScore <= 0 || endIndx != existingTableName.length() || indxUnderScore != (indxTableName = existingTableName.indexOf(l_tableName)) - 1) continue;
                            ps = conn.prepareStatement(this.getAlterTableNameQuery(existingTableName));
                            ps.executeUpdate();
                            tableExists = true;
                        } while (rs.next());
                        if (!tableExists) {
                            this.createTable(conn);
                        }
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId()};
                        throw new SDXException(super.getLog(), 301, args, e);
                    }
                }
                Object var14_15 = null;
                if (ps == null) break block22;
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (ps != null) {
                    try {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(super.getLog(), 3203, args, e);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        String[] args = new String[]{this.getId(), e.getMessage()};
                        throw new SDXException(super.getLog(), 3200, args, e);
                    }
                }
                sqldbConn.commit();
                this.releaseConnection(sqldbConn);
                throw throwable;
            }
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3203, args, e);
            }
            if (ps != null) {
                ps.close();
            }
        }
        if (rs != null) {
            try {}
            catch (SQLException e) {
                String[] args = new String[]{this.getId(), e.getMessage()};
                throw new SDXException(super.getLog(), 3200, args, e);
            }
            rs.close();
        }
        sqldbConn.commit();
        this.releaseConnection(sqldbConn);
    }

    protected String getTableCreationQuery() {
        return "CREATE CACHED TABLE " + this.getTableName() + " ( " + "id" + " VARCHAR(255) NOT NULL, " + "propertyName" + " VARCHAR(255) NOT NULL, " + "propertyValue" + " VARCHAR(255) NOT NULL, " + "PRIMARY KEY (" + "id" + ", " + "propertyName" + ", " + "propertyValue" + "))";
    }

    protected String getTableName() {
        return this.handleUnsupportedTokens(super.getTableName());
    }

    protected String getAlterTableNameQuery(String oldName) {
        return "ALTER TABLE " + this.handleUnsupportedTokens(oldName) + " RENAME TO " + this.getTableName();
    }

    protected void finalize() throws Throwable {
        this.optimize();
        super.finalize();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] search(final Parameters params, int mode) throws SDXException {
        String[] template22;
        if (mode != 0 && mode != 1 && mode != 2) {
            return new String[0];
        }
        String modeString = _searchModes[mode];
        if (params == null) {
            return new String[0];
        }
        String[] entities = new String[]{};
        DatabaseConnection sqlDbConn = this.getConnection();
        Connection conn = sqlDbConn.getConnection();
        String queryString = "";
        final String[] paramNames = params.getNames();
        String tempTableName = "";
        try {
            try {
                for (int i = 0; i < paramNames.length; ++i) {
                    if (i == 0) {
                        final String paramName = paramNames[0];
                        final String paramValue = params.getParameter(paramNames[0]);
                        if (!Utilities.checkString(paramName) || !Utilities.checkString(paramValue)) continue;
                        tempTableName = this.getTableName() + "_search_" + new DefaultIDGenerator().generate();
                        queryString = queryString + "SELECT id INTO TEMP " + tempTableName + " FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?";
                        JDBC.Template template = new JDBC.Template(conn, queryString);
                        JDBC.QueryExecutor qe = new JDBC.QueryExecutor(){

                            public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                                ps.setString(1, paramName);
                                ps.setString(2, paramValue);
                            }
                        };
                        template.execute(qe, 1);
                        continue;
                    }
                    if (i > 1) {
                        queryString = queryString + " " + modeString + " ";
                    }
                    queryString = mode != 1 ? queryString + "SELECT id INTO TEMP " + tempTableName + " FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ?" : queryString + "SELECT id FROM " + tempTableName + " WHERE " + "id" + " IN (SELECT DISTINCT " + "id" + " FROM " + this.getTableName() + " WHERE " + "propertyName" + " = ? AND " + "propertyValue" + " = ? " + _searchModes[1] + " SELECT DISTINCT " + "id" + " FROM " + tempTableName + " WHERE " + "id" + " IN (SELECT " + "id" + " FROM " + tempTableName + "))";
                }
                if (paramNames.length == 1) {
                    queryString = "SELECT * FROM " + tempTableName;
                }
                if (Utilities.checkString(queryString)) {
                    JDBC.Template template22 = new JDBC.Template(conn, queryString);
                    JDBC.QueryExecutor qe2 = new JDBC.QueryExecutor(){
                        String[] l_dbes = null;

                        public void prepare(PreparedStatement ps) throws SQLException, SDXException {
                            if (paramNames.length > 1) {
                                int indx = 0;
                                for (int j = 1; j < paramNames.length; ++j) {
                                    ps.setString(++indx, paramNames[j]);
                                    try {
                                        ps.setString(++indx, params.getParameter(paramNames[j]));
                                        continue;
                                    }
                                    catch (ParameterException e) {
                                        throw new SDXException(HSQLDatabase.this.getLog(), 114, null, e);
                                    }
                                }
                            }
                        }

                        public void collect(ResultSet rs) throws SQLException, SDXException {
                            this.l_dbes = HSQLDatabase.this.getEntityIds(rs);
                        }

                        public Object get() {
                            return this.l_dbes;
                        }
                    };
                    template22.execute(qe2, 0);
                    entities = (String[])qe2.get();
                }
                template22 = entities;
                Object var16_20 = null;
            }
            catch (SDXException e) {
                String[] args = new String[]{this.getId()};
                throw new SDXException(super.getLog(), 306, args, (Throwable)((Object)e));
            }
            catch (ParameterException e) {
                throw new SDXException(super.getLog(), 114, null, e);
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            try {
                if (Utilities.checkString(tempTableName)) {
                    queryString = "DROP TABLE " + tempTableName + " IF EXISTS";
                    JDBC.Template template = new JDBC.Template(conn, queryString);
                    template.execute(new JDBC.QueryExecutor(){}, 1);
                }
            }
            catch (SDXException e) {
                String[] args = new String[]{this.getId()};
                throw new SDXException(super.getLog(), 306, args, (Throwable)((Object)e));
            }
            this.releaseConnection(sqlDbConn);
            throw throwable;
        }
        try {}
        catch (SDXException e) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(super.getLog(), 306, args, (Throwable)((Object)e));
        }
        if (Utilities.checkString(tempTableName)) {
            queryString = "DROP TABLE " + tempTableName + " IF EXISTS";
            JDBC.Template template = new JDBC.Template(conn, queryString);
            template.execute(new /* invalid duplicate definition of identical inner class */, 1);
        }
        this.releaseConnection(sqlDbConn);
        return template22;
    }

    protected boolean initToSax() {
        this._xmlizable_objects.put("Database_Type", "HSQLDatabase");
        this._xmlizable_objects.put("JDBC_Table_Name", this.tableName);
        this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
        this._xmlizable_objects.put("Database_Directory_Path", this.dbDirPath);
        this._xmlizable_objects.put("Data_Source_Identifier", this.dsi);
        return true;
    }

    protected void initVolatileObjectsToSax() {
        this._xmlizable_objects.put("Document_Count", String.valueOf(this.size()));
    }

    public void backup(SaveParameters save_config) throws SDXException {
        super.backup(save_config);
        if (save_config != null && save_config.getAttributeAsBoolean("all", false)) {
            save_config.setAttribute("type", "HSQL");
        }
    }

    protected String getEntriesWithLimitQuery(long offset, long number) {
        String query = "SELECT LIMIT " + String.valueOf(offset) + " " + String.valueOf(number);
        query = query + " * FROM " + this.getTableName() + ";";
        return query;
    }

    public void restore(SaveParameters save_config) throws SDXException {
        super.restore(save_config);
    }
}

