/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.search.lucene.query.Terms;
import fr.gouv.culture.sdx.utils.Bits;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import java.io.IOException;
import java.text.Collator;
import java.util.BitSet;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.regex.JavaUtilRegexCapabilities;
import org.apache.lucene.search.regex.RegexCapabilities;
import org.apache.lucene.search.regex.RegexTermEnum;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.REUtil;

public class RegexTerms
extends Terms {
    private RegexCapabilities m_regexImpl;
    private String m_prefix = "";
    private String m_field = "";
    private String m_value = "";
    private String m_regex;
    private String m_internalFieldName = "";
    private IndexReader m_reader;

    public void setRegexCapabilities(RegexCapabilities regexCapabilities) {
        this.m_regexImpl = regexCapabilities;
        if (null == this.m_regexImpl) {
            this.m_regexImpl = new JavaUtilRegexCapabilities();
        }
    }

    public void setSearchLocations(SearchLocations searchLocations) {
        super.setSearchLocations(searchLocations);
        if (this._searchLocations.size() > 1) {
            this._searchLocations.getFirstDocumentBase().getId();
            SDXException sdx_e = new SDXException(4504, null);
            LoggingUtils.logWarn(this._logger, sdx_e.getMessage(this._locale));
        }
    }

    public void setField(String field) throws SDXException {
        if (!Utilities.checkString(field)) {
            throw new SDXException(super.getLog(), 4200, null, null);
        }
        this.m_field = field;
        this.m_internalFieldName = field.intern();
        this.setFieldFilter(field);
    }

    public void setIndexReader(IndexReader reader) {
        this.m_reader = reader;
    }

    public void setRegex(String value) throws SDXException {
        this.m_value = value;
        if (!Utilities.checkString(value)) {
            SDXException sdx_e = new SDXException(4702, null);
            LoggingUtils.logWarn(this._logger, sdx_e.getMessage(this._locale));
        }
        try {
            RE _testRegex = REUtil.createRE((String)value);
            this.m_regex = value;
        }
        catch (RESyntaxException e) {
            String[] args = new String[]{value};
            throw new SDXException(this._logger, 4111, args, e);
        }
    }

    public void setUp(SearchLocations sLocs, Results sdxResults, String field, String value) throws SDXException {
        this.setUp(sLocs, sdxResults.getQuery(), field, value);
    }

    public void setUp(SearchLocations sLocs, Query sdxQuery, String field, String value) throws SDXException {
        if (sdxQuery == null || sdxQuery.getLuceneQuery() == null) {
            throw new SDXException(null, 4100, null, null);
        }
        this.setUp(sLocs, sdxQuery.getLuceneQuery(), field, value);
    }

    public void setUp(SearchLocations sLocs, Query sdxQuery, String field, String value, RegexCapabilities regexCapabilities) throws SDXException {
        if (sdxQuery == null || sdxQuery.getLuceneQuery() == null) {
            throw new SDXException(null, 4100, null, null);
        }
        this.setUp(sLocs, sdxQuery.getLuceneQuery(), field, value, regexCapabilities);
    }

    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query luceneQuery, String field, String value) throws SDXException {
        this.setUp(sLocs, luceneQuery, field, value, null);
    }

    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query luceneQuery, String field, String value, RegexCapabilities regexCapabilities) throws SDXException {
        QueryWrapperFilter qwf;
        if (sLocs == null) {
            throw new SDXException(super.getLog(), 4000, null, null);
        }
        this.setField(field);
        this.setRegex(value);
        this.setRegexCapabilities(regexCapabilities);
        this.setSearchLocations(sLocs);
        this.setIndexReader(sLocs.getReader());
        this.initCollator(this._searchLocations.getField(field));
        this.termList = new TreeMap(sortCollator);
        try {
            try {
                qwf = new QueryWrapperFilter(luceneQuery);
            }
            catch (Exception e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 218, args, e);
            }
            Object var10_7 = null;
            luceneQuery = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            luceneQuery = null;
            throw throwable;
        }
        try {
            try {
                this.termList = this.getRegexTerms(qwf.bits(this.m_reader));
            }
            catch (RESyntaxException res) {
                String[] args = new String[]{this.m_value};
                throw new SDXException(this._logger, 4111, args, res);
            }
            catch (Exception e) {
                String[] args = new String[]{sLocs.getReader().directory().toString(), e.getMessage()};
                throw new SDXException(null, 200, args, e);
            }
            Object var12_16 = null;
            this.closeReader();
            qwf = null;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.closeReader();
            qwf = null;
            throw throwable;
        }
        super.setNbPages(this.countPages());
    }

    public void setUp(SearchLocations sLocs, String field, String value) throws SDXException {
        this.setUp(sLocs, field, value, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setUp(SearchLocations sLocs, String field, String value, RegexCapabilities regexCapabilities) throws SDXException {
        if (sLocs == null) {
            throw new SDXException(super.getLog(), 4000, null, null);
        }
        this.setField(field);
        this.setRegex(value);
        this.setRegexCapabilities(regexCapabilities);
        this.setSearchLocations(sLocs);
        this.setIndexReader(sLocs.getReader());
        Field _field = this._searchLocations.getField(this.m_field);
        this.initCollator(_field);
        this.termList = new TreeMap(sortCollator);
        RegexTermEnum m_regexTermEnum = null;
        try {
            try {
                m_regexTermEnum = new RegexTermEnum(this.m_reader, new Term(field, value), this.m_regexImpl);
                this.buildTermList(m_regexTermEnum);
            }
            catch (RESyntaxException res) {
                String[] args = new String[]{this.m_value};
                throw new SDXException(this._logger, 4111, args, res);
            }
            catch (SDXException sdx_e) {
                throw sdx_e;
            }
            catch (Exception e) {
                String[] args = new String[]{sLocs.getReader().directory().toString(), e.getMessage()};
                throw new SDXException(null, 200, args, e);
            }
            Object var10_7 = null;
            this.closeReader();
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.closeReader();
            try {
                if (m_regexTermEnum == null) throw throwable;
                m_regexTermEnum.close();
                throw throwable;
            }
            catch (IOException e) {
                String[] args = new String[]{_field.getCode(), e.getMessage()};
                throw new SDXException(null, 210, args, e);
            }
        }
        try {}
        catch (IOException e) {
            String[] args = new String[]{_field.getCode(), e.getMessage()};
            throw new SDXException(null, 210, args, e);
        }
        if (m_regexTermEnum != null) {
            m_regexTermEnum.close();
        }
        super.setNbPages(this.countPages());
    }

    private void buildTermList(RegexTermEnum _regexTermEnum) throws SDXException {
        block7: {
            try {
                Term t = null;
                boolean collecting = false;
                if (_regexTermEnum == null) break block7;
                do {
                    if (_regexTermEnum.term() != null) {
                        t = _regexTermEnum.term();
                    }
                    if (t != null && t.field() == this.m_internalFieldName) {
                        collecting = true;
                        String text = t.text();
                        TermInfo ti = (TermInfo)this.termList.get(text);
                        if (ti != null) {
                            ti.update(this.m_reader, _regexTermEnum.term());
                            continue;
                        }
                        ti = new TermInfo();
                        ti.enableLogging(super.getLog());
                        ti.setUp(this.m_reader, _regexTermEnum.term());
                        this.termList.put(text, ti);
                        continue;
                    }
                    if (collecting) break;
                } while (_regexTermEnum.next());
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4202, args, e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TreeMap getRegexTerms(BitSet docs) throws SDXException {
        TreeMap<Object, TermInfo> treeMap;
        Field _field;
        TreeMap m_return = new TreeMap();
        if (null == this.m_regexImpl) return m_return;
        if (null == this.m_reader) {
            return m_return;
        }
        this.setRegexCapabilities(this.m_regexImpl);
        this.m_regexImpl.compile(this.m_regex);
        String m_regexPrefix = this.m_regexImpl.prefix();
        if (m_regexPrefix == null) {
            m_regexPrefix = "";
        }
        m_return = (_field = this._searchLocations.getField(this.m_field)).getCollator() == null ? new TreeMap(Collator.getInstance(new Locale("fr", "FR"))) : new TreeMap(_field.getCollator());
        RegexTermEnum m_regexTermEnum = null;
        try {
            try {
                m_regexTermEnum = new RegexTermEnum(this.m_reader, new Term(this.m_internalFieldName, this.m_regex), this.m_regexImpl);
                boolean collecting = false;
                do {
                    if (m_regexTermEnum.term() != null && this.m_internalFieldName == m_regexTermEnum.term().field()) {
                        int nbDocs;
                        collecting = true;
                        BitSet termDocumentSet = RegexTerms.getDocumentSet(this.m_reader, m_regexTermEnum.term());
                        if (null != docs) {
                            termDocumentSet.and(docs);
                        }
                        if ((nbDocs = Bits.countBits(termDocumentSet)) > 0) {
                            String text = m_regexTermEnum.term().text();
                            TermInfo ti = (TermInfo)m_return.get(m_regexTermEnum.term().text());
                            if (null != ti) {
                                ti.update(this.m_reader, m_regexTermEnum.term());
                            } else {
                                ti = new TermInfo();
                                ti.enableLogging(super.getLog());
                                ti.setUp(this.m_reader, m_regexTermEnum.term());
                                m_return.put(m_regexTermEnum.term().text(), ti);
                            }
                            ti = null;
                        }
                        termDocumentSet = null;
                        continue;
                    }
                    if (collecting) break;
                } while (m_regexTermEnum.next());
                treeMap = m_return;
                Object var12_13 = null;
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(null, 4202, args, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            try {
                if (m_regexTermEnum == null) throw throwable;
                m_regexTermEnum.close();
                throw throwable;
            }
            catch (IOException e2) {
                String[] args = new String[]{_field.getCode(), e2.getMessage()};
                throw new SDXException(null, 210, args, e2);
            }
        }
        try {}
        catch (IOException e2) {
            String[] args = new String[]{_field.getCode(), e2.getMessage()};
            throw new SDXException(null, 210, args, e2);
        }
        if (m_regexTermEnum == null) return treeMap;
        m_regexTermEnum.close();
        return treeMap;
    }

    private void closeReader() throws SDXException {
        if (this.m_reader != null) {
            try {
                this.m_reader.close();
            }
            catch (IOException e) {
                String[] args = new String[]{e.getMessage()};
                throw new SDXException(super.getLog(), 211, args, e);
            }
        }
    }
}

