/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.query.ComplexQuery;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SimpleQuery;
import java.util.StringTokenizer;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;

public class LinearComplexQueryBuilder
extends ComplexQuery {
    private int currentLevel = 1;
    private ComplexQuery currentQueryAND;
    private ComplexQuery currentQueryNOT;
    private ComplexQuery currentQueryOR = this;
    private int queryCounter = 0;

    public void addQuery(Query q) throws SDXException {
        this.addQuery(q, 0);
    }

    public void addQuery(Query q, int op) throws SDXException {
        if (q == null) {
            return;
        }
        ++this.queryCounter;
        if (this.queryCounter == 1) {
            op = 0;
        }
        switch (op) {
            case 1: {
                switch (this.currentLevel) {
                    case 2: {
                        this.currentQueryAND.addComponent(q);
                        break;
                    }
                    case 3: {
                        this.currentQueryAND.addComponent(q);
                        break;
                    }
                    default: {
                        this.initQueryAND();
                        this.createNewLevel(this.currentQueryOR, this.currentQueryAND, q);
                    }
                }
                this.currentLevel = 2;
                break;
            }
            case 2: {
                switch (this.currentLevel) {
                    case 2: {
                        this.initQueryNOT();
                        this.createNewLevel(this.currentQueryAND, this.currentQueryNOT, q);
                        break;
                    }
                    case 3: {
                        this.currentQueryNOT.addComponent(q);
                        break;
                    }
                    default: {
                        this.initQueryAND();
                        this.initQueryNOT();
                        Query last = this.currentQueryOR.removeLastComponent();
                        this.currentQueryOR.addComponent(this.currentQueryAND);
                        this.currentQueryAND.addComponent(this.currentQueryNOT);
                        this.currentQueryNOT.addComponent(last);
                        this.currentQueryNOT.addComponent(q);
                    }
                }
                this.currentLevel = 3;
                break;
            }
            default: {
                this.currentQueryOR.addComponent(q);
                this.currentLevel = 1;
            }
        }
    }

    private void createNewLevel(ComplexQuery up, ComplexQuery down, Query newQ) {
        Query last = up.removeLastComponent();
        up.addComponent(down);
        down.addComponent(last);
        down.addComponent(newQ);
    }

    private void initQueryAND() throws SDXException {
        this.currentQueryAND = this.initQuery(1);
    }

    private void initQueryNOT() throws SDXException {
        this.currentQueryNOT = this.initQuery(2);
    }

    private ComplexQuery initQuery(int op) throws SDXException {
        ComplexQuery cq = new ComplexQuery();
        cq.enableLogging(this.getLog());
        cq.setUp(this.searchLocations, op);
        return cq;
    }

    public static void main(String[] args) throws Exception {
        System.out.print("Traitement de : ");
        SearchLocations sl = new SearchLocations();
        LinearComplexQueryBuilder lcqb = new LinearComplexQueryBuilder();
        lcqb.setUp(sl, 0);
        for (int i = 0; i < args.length; ++i) {
            StringTokenizer st = new StringTokenizer(args[i], "|");
            if (st.countTokens() != 2) continue;
            String sOp = st.nextToken();
            int op = 0;
            if (sOp.equalsIgnoreCase("and")) {
                op = 1;
            } else if (sOp.equalsIgnoreCase("not")) {
                op = 2;
            }
            String sQuery = st.nextToken();
            System.out.print(args[i] + " ");
            SimpleQuery sq = new SimpleQuery();
            sq.setUp(sl, "test", sQuery);
            lcqb.addQuery(sq, op);
        }
        System.out.println("");
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler th = tf.newTransformerHandler();
        Transformer tr = th.getTransformer();
        tr.setOutputProperty("indent", "yes");
        th.setResult(new StreamResult(System.out));
        th.startDocument();
        lcqb.toSAX(th);
        th.endDocument();
    }
}

