/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;
import fr.gouv.culture.sdx.search.lucene.query.CachingRewrittenQueryWrapper;
import fr.gouv.culture.sdx.search.lucene.query.ComplexQuery;
import fr.gouv.culture.sdx.search.lucene.query.Query;
import fr.gouv.culture.sdx.search.lucene.query.Results;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.SortSpecification;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractQuery
extends AbstractSdxObject
implements Query {
    protected SearchLocations searchLocations;
    protected String queryText;
    protected Results baseResults;
    protected Query baseQuery;
    protected int baseOperator;
    protected SortSpecification sortSpecification;
    protected Filter filter;
    protected org.apache.lucene.search.Query luceneQuery;
    protected CachingRewrittenQueryWrapper cachedQuery = null;

    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query lquery) throws SDXException {
        this.setSearchLocations(sLocs);
        if (lquery != null) {
            this.luceneQuery = lquery;
        }
    }

    public void setLuceneQuery(org.apache.lucene.search.Query lquery) {
        if (lquery != null) {
            this.luceneQuery = lquery;
        }
    }

    public org.apache.lucene.search.Query getLuceneQuery() {
        return this.luceneQuery;
    }

    public org.apache.lucene.search.Query getCachedQuery() {
        return this.cachedQuery.getRewrittenQueries();
    }

    public Results execute() throws SDXException {
        this.filter = this.prepare();
        if (this.searchLocations == null) {
            throw new SDXException(null, 4000, null, null);
        }
        Searcher searcher = this.searchLocations.getSearcher();
        if (searcher == null) {
            throw new SDXException(super.getLog(), 4103, null, null);
        }
        if (this.baseQuery != null && !(this instanceof ComplexQuery)) {
            BooleanQuery newQuery = Utilities.newBooleanQuery();
            switch (this.baseOperator) {
                case 0: {
                    newQuery.add(this.luceneQuery, BooleanClause.Occur.SHOULD);
                    newQuery.add(this.baseQuery.getLuceneQuery(), BooleanClause.Occur.SHOULD);
                    break;
                }
                case 2: {
                    newQuery.add(this.luceneQuery, BooleanClause.Occur.MUST_NOT);
                    newQuery.add(this.baseQuery.getLuceneQuery(), BooleanClause.Occur.MUST);
                    break;
                }
                default: {
                    this.baseOperator = 1;
                    newQuery.add(this.luceneQuery, BooleanClause.Occur.MUST);
                    newQuery.add(this.baseQuery.getLuceneQuery(), BooleanClause.Occur.MUST);
                }
            }
            this.luceneQuery = newQuery;
        }
        try {
            if (this.luceneQuery instanceof BooleanQuery) {
                BooleanQuery.setMaxClauseCount((int)Query.LUCENE_BOOLEAN_QUERY_MAX_CLAUSES);
            }
            this.cachedQuery = new CachingRewrittenQueryWrapper(this.luceneQuery);
            Hits searchHits = this.filter == null ? searcher.search((org.apache.lucene.search.Query)this.cachedQuery) : searcher.search((org.apache.lucene.search.Query)this.cachedQuery);
            Results results = new Results();
            results.enableLogging(super.getLog());
            results.setUp(this.searchLocations, searchHits, this.sortSpecification, this);
            return results;
        }
        catch (IOException e) {
            String[] args = new String[3];
            if (this.luceneQuery != null) {
                args[0] = this.luceneQuery.toString();
            }
            args[1] = searcher.toString();
            args[2] = e.getMessage();
            throw new SDXException(super.getLog(), 4104, args, e);
        }
    }

    public static int getOperator(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equalsIgnoreCase("0")) {
            return 0;
        }
        if (str.equalsIgnoreCase("1")) {
            return 1;
        }
        if (str.equalsIgnoreCase("2")) {
            return 2;
        }
        if (str.equalsIgnoreCase("and")) {
            return 1;
        }
        if (str.equalsIgnoreCase("et")) {
            return 1;
        }
        if (str.equalsIgnoreCase("or")) {
            return 0;
        }
        if (str.equalsIgnoreCase("ou")) {
            return 0;
        }
        if (str.equalsIgnoreCase("not")) {
            return 2;
        }
        if (str.equalsIgnoreCase("sauf")) {
            return 2;
        }
        return 1;
    }

    public void addBaseQuery(Results results, int operator) {
        this.baseResults = results;
        this.baseOperator = operator;
        if (results != null) {
            this.baseQuery = results.getQuery();
        }
    }

    public void addBaseQuery(Query query, int operator) {
        if (query != null) {
            this.baseQuery = query;
            this.baseOperator = operator;
        }
    }

    public void addSortSpecification(SortSpecification ss) {
        this.sortSpecification = ss;
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter prepare() {
        return this.filter;
    }

    protected AttributesImpl addAttributesLucene(AttributesImpl atts) throws SAXException {
        atts.addAttribute("", "engine", "engine", "CDATA", "lucene");
        if (this.luceneQuery != null && this.searchLocations != null) {
            try {
                String fieldName = null;
                String luceneQueryString = null;
                Field field = this.searchLocations.getDefaultField();
                if (field != null) {
                    fieldName = field.getCode();
                }
                if (fieldName != null) {
                    luceneQueryString = this.luceneQuery.toString(fieldName);
                }
                if (luceneQueryString != null) {
                    atts.addAttribute("", "luceneQuery", "luceneQuery", "CDATA", luceneQueryString);
                    atts.addAttribute("", "escapedLuceneQuery", "escapedLuceneQuery", "CDATA", Utilities.encodeURL(luceneQueryString, super.getEncoding()));
                }
            }
            catch (SDXException sdxE) {
                throw new SAXException(sdxE.getMessage(), (Exception)((Object)sdxE));
            }
        }
        return atts;
    }

    protected AttributesImpl addAttributesText(AttributesImpl atts) throws SAXException {
        if (this.queryText != null) {
            atts.addAttribute("", "text", "text", "CDATA", this.queryText);
            atts.addAttribute("", "escapedText", "escapedText", "CDATA", Utilities.encodeURL(this.queryText, super.getEncoding()));
        }
        return atts;
    }

    public abstract void toSAX(ContentHandler var1) throws SAXException;

    protected void setSearchLocations(SearchLocations sLocs) throws SDXException {
        if (sLocs == null) {
            throw new SDXException(null, 4000, null, null);
        }
        this.searchLocations = sLocs;
    }

    public void setUp() {
    }

    public SearchLocations getSearchLocations() {
        return this.searchLocations;
    }

    protected String getClassNameSuffix() {
        return "Query";
    }

    public float getBoost() {
        return this.luceneQuery.getBoost();
    }

    public void setBoost(float boost) {
        if (this.luceneQuery != null) {
            if (boost >= 0.0f) {
                this.luceneQuery.setBoost(boost);
            } else {
                String message = "The boost can't be negative : " + this.luceneQuery.toString();
                this.getLog().warn(message);
            }
        }
    }

    public void setBoost(String boost) {
        try {
            this.setBoost(Float.parseFloat(boost));
        }
        catch (NumberFormatException e) {
            String message = "The string is not a valid float.\nThe boost will not be applied:\n" + boost;
            this.getLog().warn(message, (Throwable)e);
        }
    }

    protected boolean initToSax() {
        return true;
    }

    protected void initVolatileObjectsToSax() {
    }
}

