/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.highlight;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.search.Query;
import fr.gouv.culture.sdx.search.TermHighlighter;
import fr.gouv.culture.sdx.search.Terms;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.query.SearchLocations;
import fr.gouv.culture.sdx.search.lucene.query.TermInfo;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.logging.LoggingUtils;
import fr.gouv.culture.sdx.utils.lucene.LuceneTools;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneTermHighlighter
extends GenericPipeline
implements TermHighlighter {
    private int hliteIdx = 0;
    private String uri = "http://www.culture.gouv.fr/ns/sdx/sdx";
    private String local = "hilite";
    private String qName = "sdx:" + this.local;
    private Query query = null;
    private SearchLocations sLocs = null;
    private Hashtable terms = null;
    private boolean saxStreamStarted = false;
    private String termsSt = null;
    private Vector texps = null;
    private String texpsSt = null;

    public void setQuery(Query query) throws SDXException {
        this.query = query;
        if (this.query != null) {
            this.sLocs = ((fr.gouv.culture.sdx.search.lucene.query.Query)this.query).getSearchLocations();
            org.apache.lucene.search.Query lQuery = ((fr.gouv.culture.sdx.search.lucene.query.Query)this.query).getCachedQuery();
            if (lQuery != null) {
                try {
                    this.terms = new Hashtable();
                    LuceneTools.getTerms(lQuery, this.terms, false);
                }
                catch (IOException e) {
                    throw new SDXException(super.getLog(), 111, null, e);
                }
            }
        }
    }

    public void setTerms(Terms terms) {
        if (terms != null) {
            this.sLocs = ((fr.gouv.culture.sdx.search.lucene.query.Terms)terms).getSearchLocations();
            TreeMap termList = terms.getList();
            Iterator termValues = termList.keySet().iterator();
            if (termValues != null) {
                this.terms = new Hashtable();
                while (termValues.hasNext()) {
                    String termText = (String)termValues.next();
                    TermInfo ti = (TermInfo)termList.get(termText);
                    String fieldName = ti.getField();
                    this.terms.put(fieldName + "_" + termText, termText);
                }
            }
        }
    }

    public void highlightTerm(String term, String termText) throws SAXException {
        if (this.xmlConsumer != null && Utilities.checkString(term)) {
            ++this.hliteIdx;
            AttributesImpl locAttr = null;
            locAttr = new AttributesImpl();
            locAttr.addAttribute("", "no", "no", "CDATA", Integer.toString(this.hliteIdx));
            locAttr.addAttribute("", "term", "term", "CDATA", termText);
            this.xmlConsumer.startElement(this.uri, this.local, this.qName, (Attributes)locAttr);
            char[] chars = term.toCharArray();
            if (chars != null) {
                this.xmlConsumer.characters(chars, 0, chars.length);
            }
            this.xmlConsumer.endElement(this.uri, this.local, this.qName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void highlightTerms(String field, String text, Analyzer analyzer) throws SAXException, IOException {
        TokenStream stream = null;
        String lastHilitedTermFromText = "";
        boolean isTestExp = false;
        try {
            char[] chars;
            Token tmpToken;
            stream = analyzer.tokenStream(field, new StringReader(text));
            Vector<Token> tokens = new Vector<Token>();
            StringBuffer tbriefs = null;
            int tmpStartOffset = -1;
            int tmpEndOffset = -1;
            int lastEndOffset = 0;
            while ((tmpToken = stream.next()) != null || tokens.size() > 0) {
                if (tmpStartOffset == -1) {
                    tmpStartOffset = tmpToken.startOffset();
                }
                if (tmpEndOffset == -1) {
                    tmpEndOffset = tmpToken.endOffset();
                }
                if (tmpToken != null && tmpToken.startOffset() == tmpStartOffset && tmpToken.endOffset() == tmpEndOffset) {
                    tokens.add(tmpToken);
                    continue;
                }
                if (tokens.size() <= 0) continue;
                Enumeration tokensForSameTextPosition = tokens.elements();
                while (tokensForSameTextPosition.hasMoreElements()) {
                    char[] chars2;
                    String termText;
                    Token token = (Token)tokensForSameTextPosition.nextElement();
                    if (token == null) continue;
                    int startOffset = token.startOffset();
                    int endOffset = token.endOffset();
                    String originalTextAtTokenPosition = text.substring(startOffset, endOffset);
                    if (startOffset > lastEndOffset) {
                        char[] chars3 = text.substring(lastEndOffset, startOffset).toCharArray();
                        if (chars3 != null && chars3.length > 0) {
                            this.xmlConsumer.characters(chars3, 0, chars3.length);
                        }
                        lastHilitedTermFromText = "";
                    }
                    if (Utilities.checkString(termText = token.termText()) && !Utilities.checkString(lastHilitedTermFromText) && this.terms != null) {
                        if (this.termsSt == null) {
                            this.termsSt = this.terms.toString();
                        }
                        if (this.termsSt != null && (this.termsSt.matches(".*\\b" + termText + "\\b.*") || this.termsSt.matches(".*\\b" + originalTextAtTokenPosition + "\\b.*"))) {
                            if (this.terms.containsValue(termText) || this.terms.containsValue(originalTextAtTokenPosition)) {
                                this.highlightTerm(originalTextAtTokenPosition, termText);
                                lastHilitedTermFromText = termText;
                            } else {
                                if (!isTestExp) {
                                    if (this.texps == null) {
                                        this.texps = new Vector();
                                    }
                                    String tsearch = null;
                                    Enumeration tsearchs = this.terms.elements();
                                    while (tsearchs.hasMoreElements()) {
                                        tsearch = (String)tsearchs.nextElement();
                                        if (!Utilities.checkString(tsearch) || tsearch.indexOf(" ") <= 0) continue;
                                        this.texps.add(tsearch);
                                    }
                                    this.texpsSt = this.texps.toString();
                                    isTestExp = true;
                                }
                                if (isTestExp && this.texps != null && (this.texpsSt.matches(".*\\b" + termText + "\\b.*") || this.texpsSt.matches(".*\\b" + originalTextAtTokenPosition + "\\b.*"))) {
                                    String texp = null;
                                    Enumeration mE = this.texps.elements();
                                    while (mE.hasMoreElements()) {
                                        int nb;
                                        block35: {
                                            Object var28_27;
                                            Token mTk;
                                            TokenStream mStrm;
                                            block34: {
                                                texp = (String)mE.nextElement();
                                                if (Utilities.checkString(texp)) {
                                                    Object var26_26;
                                                    mStrm = null;
                                                    mTk = null;
                                                    nb = 0;
                                                    try {
                                                        mStrm = analyzer.tokenStream(field, new StringReader(texp));
                                                        StringBuffer mSb = new StringBuffer();
                                                        while ((mTk = mStrm.next()) != null) {
                                                            if (nb > 0) {
                                                                mSb.append(" ");
                                                            }
                                                            mSb.append(mTk.termText());
                                                            ++nb;
                                                        }
                                                        texp = mSb.toString();
                                                        var26_26 = null;
                                                        if (mStrm == null) break block34;
                                                    }
                                                    catch (Throwable throwable) {
                                                        var26_26 = null;
                                                        if (mStrm == null) throw throwable;
                                                        mStrm.close();
                                                        throw throwable;
                                                    }
                                                    mStrm.close();
                                                }
                                            }
                                            if (!Utilities.checkString(texp) || texp.indexOf(termText) == -1 || !texp.startsWith(termText)) continue;
                                            mStrm = null;
                                            mTk = null;
                                            try {
                                                mStrm = analyzer.tokenStream(field, new StringReader(text.substring(startOffset)));
                                                tbriefs = new StringBuffer();
                                                int l = texp.split(" ").length;
                                                for (nb = 0; nb < l && (mTk = mStrm.next()) != null; ++nb) {
                                                    if (nb > 0) {
                                                        tbriefs.append(" ");
                                                    }
                                                    tbriefs.append(mTk.termText());
                                                }
                                                var28_27 = null;
                                                if (mStrm == null) break block35;
                                            }
                                            catch (Throwable throwable) {
                                                var28_27 = null;
                                                if (mStrm == null) throw throwable;
                                                mStrm.close();
                                                throw throwable;
                                            }
                                            mStrm.close();
                                        }
                                        if (tbriefs == null || !tbriefs.toString().equals(texp)) continue;
                                        if (nb == 1) {
                                            lastHilitedTermFromText = termText;
                                        } else {
                                            for (int t = 2; t <= nb && tmpToken != null; ++t) {
                                                if (t == nb) {
                                                    endOffset = tmpToken.endOffset();
                                                    lastHilitedTermFromText = tmpToken.termText();
                                                }
                                                tmpToken = stream.next();
                                            }
                                        }
                                        originalTextAtTokenPosition = text.substring(startOffset, endOffset);
                                        this.highlightTerm(originalTextAtTokenPosition, tbriefs.toString());
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    if (!tokensForSameTextPosition.hasMoreElements() && !Utilities.checkString(lastHilitedTermFromText) && (chars2 = originalTextAtTokenPosition.toCharArray()) != null && chars2.length > 0) {
                        this.xmlConsumer.characters(chars2, 0, chars2.length);
                    }
                    lastEndOffset = endOffset;
                }
                tokens.clear();
                if (tmpToken == null) continue;
                tokens.add(tmpToken);
                tmpStartOffset = tmpToken.startOffset();
                tmpEndOffset = tmpToken.endOffset();
            }
            if (lastEndOffset < text.length() && (chars = text.substring(lastEndOffset).toCharArray()) != null) {
                this.xmlConsumer.characters(chars, 0, chars.length);
            }
            Object var30_30 = null;
            if (stream == null) return;
        }
        catch (Throwable throwable) {
            Object var30_31 = null;
            if (stream == null) throw throwable;
            stream.close();
            throw throwable;
        }
        stream.close();
    }

    public void characters(char[] c, int start, int len) throws SAXException {
        block7: {
            StringBuffer sBuff = null;
            sBuff = new StringBuffer();
            sBuff.append(c, start, len);
            try {
                if (sBuff == null) break block7;
                String text = sBuff.toString();
                if (this.sLocs != null) {
                    Analyzer analyzer = null;
                    Field df = this.sLocs.getDefaultField();
                    if (df != null) {
                        analyzer = df.getAnalyzer();
                    }
                    if (analyzer != null && this.terms != null && this.terms.size() > 0) {
                        try {
                            this.highlightTerms(null, text, analyzer);
                            break block7;
                        }
                        catch (IOException e) {
                            throw new SAXException(e.getMessage(), e);
                        }
                    }
                    char[] chars = text.toCharArray();
                    this.xmlConsumer.characters(chars, 0, chars.length);
                    break block7;
                }
                char[] chars = text.toCharArray();
                this.xmlConsumer.characters(chars, 0, chars.length);
            }
            catch (SDXException e) {
                this.xmlConsumer.characters(c, start, len);
            }
        }
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        super.endElement(uri, loc, raw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (!this.saxStreamStarted && this.terms != null) {
            AttributesImpl topAtts;
            block13: {
                topAtts = new AttributesImpl();
                try {
                    if (this.sLocs == null) break block13;
                    Analyzer analyzer = null;
                    Field df = this.sLocs.getDefaultField();
                    if (df != null) {
                        analyzer = df.getAnalyzer();
                    }
                    if (analyzer != null) {
                        topAtts.addAttribute("", "analyzerClass", "analyzerClass", "CDATA", analyzer.getClass().getName());
                    }
                }
                catch (SDXException e) {
                    topAtts.addAttribute("", "analyzerClass", "analyzerClass", "CDATA", "unable to get an analyzer");
                }
            }
            this.xmlConsumer.startElement(this.uri, "hilites", "sdx:hilites", (Attributes)topAtts);
            Enumeration list = this.terms.elements();
            while (list.hasMoreElements()) {
                String localName = "term";
                String localQName = "sdx:" + localName;
                AttributesImpl localAtts = new AttributesImpl();
                localAtts.addAttribute("", "value", "value", "CDATA", (String)list.nextElement());
                this.xmlConsumer.startElement(this.uri, localName, localQName, (Attributes)localAtts);
                this.xmlConsumer.endElement(this.uri, localName, localQName);
            }
            this.xmlConsumer.endElement(this.uri, "hilites", "sdx:hilites");
            this.saxStreamStarted = true;
        }
        if (a.getLength() == 0) {
            super.startElement(uri, loc, raw, a);
            return;
        }
        Attributes hilitedAtts = a;
        try {
            try {
                hilitedAtts = this.getHilitedAttributes(a);
            }
            catch (SDXException e) {
                LoggingUtils.logException(super.getLog(), (Exception)((Object)e));
                Object var11_14 = null;
                super.startElement(uri, loc, raw, hilitedAtts);
                return;
            }
            catch (IOException e) {
                LoggingUtils.logException(super.getLog(), e);
                Object var11_15 = null;
                super.startElement(uri, loc, raw, hilitedAtts);
                return;
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            super.startElement(uri, loc, raw, hilitedAtts);
            throw throwable;
        }
        super.startElement(uri, loc, raw, hilitedAtts);
    }

    protected Attributes getHilitedAttributes(Attributes a) throws SDXException, IOException {
        AttributesImpl hilitedAtts = new AttributesImpl(a);
        if (this.sLocs != null) {
            Analyzer analyzer = null;
            Field df = this.sLocs.getDefaultField();
            if (df != null) {
                analyzer = df.getAnalyzer();
            }
            if (analyzer != null && this.terms != null && this.terms.size() > 0) {
                for (int i = 0; i < a.getLength(); ++i) {
                    Token tmpToken;
                    String attValue;
                    String attName = a.getLocalName(i);
                    String text = attValue = a.getValue(i);
                    String hiliteVal = "";
                    String suffix = "-" + attName;
                    String locName = "hilite" + suffix;
                    String qualName = "sdx:hilite" + suffix;
                    TokenStream stream = analyzer.tokenStream(null, new StringReader(text));
                    Vector<Token> tokens = new Vector<Token>();
                    int tmpStartOffset = -1;
                    int tmpEndOffset = -1;
                    int lastEndOffset = 0;
                    while ((tmpToken = stream.next()) != null || tokens.size() > 0) {
                        if (tmpStartOffset == -1) {
                            tmpStartOffset = tmpToken.startOffset();
                        }
                        if (tmpEndOffset == -1) {
                            tmpEndOffset = tmpToken.endOffset();
                        }
                        if (tmpToken != null && tmpToken.startOffset() == tmpStartOffset && tmpToken.endOffset() == tmpEndOffset) {
                            tokens.add(tmpToken);
                            continue;
                        }
                        if (tokens.size() <= 0) continue;
                        Enumeration tokensForSameTextPosition = tokens.elements();
                        String lastHilitedTermFromText = "";
                        while (tokensForSameTextPosition.hasMoreElements()) {
                            String termText;
                            Token token = (Token)tokensForSameTextPosition.nextElement();
                            if (token == null) continue;
                            int startOffset = token.startOffset();
                            int endOffset = token.endOffset();
                            if (startOffset > lastEndOffset) {
                                lastHilitedTermFromText = "";
                            }
                            if (Utilities.checkString(termText = token.termText()) && !Utilities.checkString(lastHilitedTermFromText) && this.terms != null && this.terms.contains(termText)) {
                                int adjustOffsetForXslStringFunctions = 1;
                                if (Utilities.checkString(hiliteVal)) {
                                    hiliteVal = hiliteVal + ";";
                                }
                                hiliteVal = hiliteVal + Integer.toString(startOffset + adjustOffsetForXslStringFunctions) + ":" + Integer.toString(endOffset);
                                lastHilitedTermFromText = termText;
                            }
                            lastEndOffset = endOffset;
                        }
                        tokens.clear();
                        if (tmpToken == null) continue;
                        tokens.add(tmpToken);
                        tmpStartOffset = tmpToken.startOffset();
                        tmpEndOffset = tmpToken.endOffset();
                    }
                    if (!Utilities.checkString(hiliteVal)) continue;
                    hilitedAtts.addAttribute("http://www.culture.gouv.fr/ns/sdx/sdx", locName, qualName, "CDATA", hiliteVal);
                }
            }
        }
        return hilitedAtts;
    }

    public void recycle() {
        this.saxStreamStarted = false;
        this.hliteIdx = 0;
        this.query = null;
        this.sLocs = null;
        this.terms = null;
    }
}

