/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.analysis;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.analysis.AbstractAnalyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.tokenizer.LaxistLowerCaseTokenizer;
import java.io.Reader;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;

public class DefaultAnalyzer
extends AbstractAnalyzer {
    private static final String STOP_WORDS_ELEMENT = "stopWords";
    private static final String STOP_WORD_ELEMENT = "stopWord";
    protected static final String ATTRIBUTE_USE_STOP_WORDS = "useStopWords";
    protected static final String ATTRIBUTE_EXCLUDE_STEMS = "excludeStems";
    protected static final String ANALYZER_TYPE = "DefaultAnalyzer";
    protected Set stopTable = null;
    protected Set excludeTable = null;
    protected final String EXCLUDE_STEMS_ELEMENT = "excludeStems";
    protected final String EXCLUDE_STEM_ELEMENT = "excludeStem";
    public static final String[] DEFAULT_STOP_WORDS = new String[]{"a", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "s", "such", "t", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};

    protected String getAnalyzerType() {
        return ANALYZER_TYPE;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            boolean useStopWords = configuration.getAttributeAsBoolean(ATTRIBUTE_USE_STOP_WORDS, true);
            if (useStopWords) {
                try {
                    this.stopTable = this.buildStopTable(configuration);
                }
                catch (SDXException e) {
                    throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
                }
            } else {
                this.stopTable = null;
            }
            boolean excludeStems = configuration.getAttributeAsBoolean(ATTRIBUTE_EXCLUDE_STEMS, true);
            this.excludeTable = excludeStems ? this.buildExcludeTable(configuration) : null;
        } else {
            this.stopTable = StopFilter.makeStopSet((String[])this.getDefaultStopWords());
        }
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (this.stopTable != null) {
            return new StopFilter((TokenStream)new LaxistLowerCaseTokenizer(reader), this.stopTable);
        }
        return new LaxistLowerCaseTokenizer(reader);
    }

    protected Set buildStopTable(Configuration conf) throws SDXException, ConfigurationException {
        Configuration[] cStops;
        Configuration cStop;
        Set stops = null;
        if (conf != null && (cStop = conf.getChild(STOP_WORDS_ELEMENT, false)) != null && (cStops = cStop.getChildren(STOP_WORD_ELEMENT)) != null) {
            String[] words = new String[cStops.length];
            for (int i = 0; i < cStops.length; ++i) {
                words[i] = cStops[i].getValue();
            }
            stops = StopFilter.makeStopSet((String[])words);
        }
        if (stops == null) {
            stops = StopFilter.makeStopSet((String[])this.getDefaultStopWords());
        }
        return stops;
    }

    protected String[] getDefaultStopWords() {
        return DEFAULT_STOP_WORDS;
    }

    protected Set buildExcludeTable(Configuration conf) throws ConfigurationException {
        Configuration[] cExcludes;
        Configuration cExclude;
        Set excludes = null;
        if (conf != null && (cExclude = conf.getChild(ATTRIBUTE_EXCLUDE_STEMS, false)) != null && (cExcludes = cExclude.getChildren("excludeStem")) != null) {
            String[] words = new String[cExcludes.length];
            for (int i = 0; i < cExcludes.length; ++i) {
                words[i] = cExcludes[i].getValue();
            }
            excludes = StopFilter.makeStopSet((String[])words);
        }
        if (excludes == null) {
            excludes = StopFilter.makeStopSet((String[])this.getDefaultStopWords());
        }
        return excludes;
    }

    public TokenStream tokenStream(Reader reader) {
        return this.tokenStream(null, reader);
    }
}

