---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  TCL_UTILITIES.ADS
--  Description : Useful utilities for RAPID programmers
--
--  By: Martin Carlisle, Patrick Maes and Jonathan Busch
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
---------------------------------------------------------------
-- Recall a Window_Name is "." for the main window, or ".bob" for
-- a window called bob (never is the first letter upper case)
--
-- These utilities are coded so that you could omit the "."
-- from the beginning of the window name, and use "main" as
-- the name of the main window (to hide some of the Tcl-isms).
--
-- Name refers to the name of the widget
---------------------------------------------------------------
with Tcl;
package Tcl_Utilities is

   -- change the title displayed for a window
   --   procedure Change_Window_Title(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Title       : in String);

   -- return True if File1 is newer than File2
   -- or File2 doesn't exist.
   --   function Is_Newer(Interp : Tcl.Tcl_Interp;
   --      File1 : in String;
   --      File2 : in String) return Boolean;

   --   procedure Destroy_Window(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String);

   -- Change the foreground and background colors for a
   -- widget
   --   procedure Set_Widget_Color(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      FG_Color	  : in String;
   --      BG_Color    : in String);

   -- return the value of a Tcl variable as a string
   procedure Get_Value
     (Interp : Tcl.Tcl_Interp;
      Name   : in String;
      Result : out String;
      Last   : out Natural);

   -- return the value of a Tcl variable as an integer
   procedure Get_Value
     (Interp : Tcl.Tcl_Interp;
      Name   : in String;
      Result : out Integer);

   -- clear the text entry window
   --   procedure Clear_Text_Entry(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   -- get all of text from entry widget
   --   procedure Get_Text_Entry(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Result      : out String;
   --      Last        : out Natural);

   procedure Get_Text_Entry
     (Interp      : Tcl.Tcl_Interp;
      Window_Name : in String;
      Name        : in String;
      Result      : out Integer);

   --   procedure Get_Text_Entry(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Result      : out Float);

   --   procedure Set_Text_Entry(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Text        : in String);

   -- get value from scale widget
   --   procedure Get_Scale_Value(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Value       : out Float);

   -- set value of widget scale
   --   procedure Set_Scale_Value(Interp : Tcl.Tcl_Interp;
   --         Window_Name : in String;
   --         Name        : in String;
   --         Value       : in String);

   -- returns a string where \ is replaced by \\ and
   -- " is replaced by \"
   function Fix_Quotes (Text : in String) return String;

   --   -- basically the inverse of Fix_Quotes
   --   function Unescape(Text : in String) return String;

   --   procedure Highlight_Text_Entry(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   -- Use the following for checkboxes
   --   procedure Select_Box(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   procedure Deselect_Box(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   function Is_Checked(Interp : Tcl.Tcl_Interp;
   --      Name        : in String) return Boolean;

   --   -- Change the text of a label widget
   --   procedure Change_Label_Text(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      New_Text	  : in String);

   --   -- Add an entry at end of Listbox
   --   procedure Append_Listbox_Text(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      New_Text    : in String);

   --   --Add an entry to beginning of Listbox
   --   procedure Prepend_Listbox_Text(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      New_Text    : in String);

   --   --Place text at place position, 0 is before start
   --   --1 is after 1st, etc.
   --   procedure Insert_Listbox_Text(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      New_Text    : in String;
   --      Position    : in Natural);

   --   --Remove all entries from listbox
   --   procedure Clear_Listbox(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   --Remove some entries from listbox
   --   --1 is first, 2 is second...
   --   procedure Delete_Listbox_Entries(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      From        : in Positive;
   --      To          : in Positive);

   --   -- return which item in Listbox is selected
   --   -- 1 is first, 2 is second,...
   --   -- return 0 if nothing selected
   --   function Listbox_Selected(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String) return Natural;

   --   -- The following two procedures allow you to disable
   --   -- and reenable buttons
   --   procedure Activate_Button(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   procedure Disable_Button(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String);

   --   -- The following two procedures allow you to disable
   --   -- and reenable menu items
   --   -- Name is the name of the menu and index is the
   --   -- position in the menu.
   --   procedure Activate_Menu_Item(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Index       : in Natural);

   --   procedure Disable_Menu_Item(Interp : Tcl.Tcl_Interp;
   --      Window_Name : in String;
   --      Name        : in String;
   --      Index       : in Natural);

end Tcl_Utilities;
