-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with peer;
with Tcl;
with Interfaces.C;
with CArgv;
package body mcc.Gui.Event_Scheduler is
   The_Event          : Event_Callback_Type;
   Have_Event_Command : Boolean := False;

   --------------------------
   -- Tcl callback for
   -- timed events
   --------------------------
   function Event_Command_Function
     (ClientData : in Integer;
      Interp     : in Tcl.Tcl_Interp;
      Argc       : in Interfaces.C.int;
      Argv       : in CArgv.Chars_Ptr_Ptr)
      return       Interfaces.C.int;
   pragma Convention (C, Event_Command_Function);

   -- protocol for arguments will be:
   -- no arguments
   function Event_Command_Function
     (ClientData : in Integer;
      Interp     : in Tcl.Tcl_Interp;
      Argc       : in Interfaces.C.int;
      Argv       : in CArgv.Chars_Ptr_Ptr)
      return       Interfaces.C.int
   is
   begin
      The_Event.all;
      return Tcl.TCL_OK;
   end Event_Command_Function;

   --------------------
   -- Schedule_Event --
   --------------------

   procedure Schedule_Event
     (Number_Of_Milliseconds : Natural;
      Event_Callback         : Event_Callback_Type)
   is
      Event_Command : Tcl.Tcl_Command;
   begin
      if not Have_Event_Command then
         Event_Command      :=
            peer.CreateCommands.Tcl_CreateCommand
              (peer.Get_Interp,
               "eventcommand",
               Event_Command_Function'Access,
               0,
               null);
         Have_Event_Command := True;
      end if;

      The_Event := Event_Callback;
      peer.Eval
        ("after " & mcc.Img (Number_Of_Milliseconds) & " eventcommand");
   end Schedule_Event;

end Mcc.Gui.Event_Scheduler;
