---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-STATIC.ADS
--  Description : GUI Widget Static Label
--
--  By: Martin Carlisle and Jonathan Busch
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
---------------------------------------------------------------
with mcc.Gui.Container;
with mcc.Gui.Widget.Text_Entry;

package gui.Widget.Static is

   type Label is new GUI_Widget with record
      Text          : String_Pointer := null;
      Justify       : String_Pointer := null;
      FG_Color      : String_Pointer := null;
      BG_Color      : String_Pointer := null;
      Parent        : String_Pointer := null;
      Frame         : Boolean        := False;
      Text_Entry    : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Justify_Entry : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      FG_Entry      : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      BG_Entry      : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into Label,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Label);

   -- Writes information to file from Label
   procedure Write_Widget (Widget : in Label);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Label);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Label);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Label;
      Window_Name : in String);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Label;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Label);

   procedure Apply_Properties (Widget : in out Label);

   procedure Check_Properties (Widget : in out Label; Ok : out Boolean);

end Gui.Widget.Static;
