-- Auto generated by RAPID (http://savannah.nongnu.org/projects/rapid/)

with Ada.Exceptions;

with Mcc.Gui.Fonts;
with main_actions;
with enum_try;


package body main_window is
   
   procedure Generate_Window is
   begin
      
      if Mcc.Gui.Container.Window.Is_Open
           (Mcc.Gui.Container.Window.Window (main_window))
      then
         raise Already_Open;
      end if;
      
      Mcc.Gui.Container.Window.Create
        (Obj    => main_window,
         X      => 0,
         Y      => 0,
         Width  => 300,
         Height => 300);
      
      Mcc.Gui.Container.Window.Set_Title
        (Obj   => main_window,
         Title => "drop down demo");
      
      
      Mcc.Gui.Widget.Dropdown.Create
        (Obj         => listbox,
         Parent      => main_window,
         X           => 98,
         Y           => 29,
         Width       => 93,
         Height      => 46,
         Number_Rows => 2);
      for E in enum_try.cadet_type loop
         Mcc.Gui.Widget.Dropdown.Add_Entry
           (Obj      => listbox,
            Location => enum_try.cadet_type'Pos(E),
            Text     => enum_try.cadet_type'Image(E));
      end loop;
      Mcc.Gui.Widget.Label.Create
        (Obj     => echo_rank,
         Parent  => main_window,
         X       => 89,
         Y       => 105,
         Width   => 111,
         Height  => 37,
         Justify => Mcc.Gui.Widget.Label.center,
         Text    => "No choice yet.");
      Mcc.Gui.Widget.Button.Text.Create
        (Obj    => go_button,
         Parent => main_window,
         X      => 107,
         Y      => 167,
         Width  => 75,
         Height => 37,
         Text   => "Go Button");
      Mcc.Gui.Widget.Button.Set_Push_Callback
        (Obj      => go_button'access,
         Callback => main_actions.go_button_pushed'access);
      Mcc.Gui.Widget.Button.Text.Create
        (Obj    => Exit_button,
         Parent => main_window,
         X      => 119,
         Y      => 252,
         Width  => 57,
         Height => 35,
         Text   => "Exit");
      Mcc.Gui.Widget.Button.Set_Push_Callback
        (Obj      => Exit_button'access,
         Callback => main_actions.exit_button_pushed'access);
      
   end Generate_Window;
   
   
   procedure Fill_Window is
   begin
      Mcc.Gui.Widget.Dropdown.Select_Item
        (Obj      => listbox,
         Number   => enum_try.cadet_type'Pos(main_actions.whichrank) + 1);
      
   end Fill_Window;
   
   procedure Generate_and_Fill_Window is
   begin
       Generate_Window;
       Fill_Window;
   end Generate_and_Fill_Window;
   
   procedure Read_Window
     (Success         :    out Boolean;
      Highlight_Error : in     Boolean := True;
      Beep_On_Error   : in     Boolean := True) is
   begin
      Success := True;
      declare
         Position : Integer := Mcc.Gui.Widget.Dropdown.Get_Selected(listbox) - 1;
      begin
         main_actions.whichrank := enum_try.cadet_type'Val(Position);
      end;
   exception when others =>
      Success := False;
      if Beep_On_Error then
         Mcc.Gui.Bell;
      end if;
   end Read_Window;
   
   procedure Close_Window is
   begin
      Mcc.Gui.Destroy(Mcc.Gui.Object(main_window));
   end Close_Window;
   
end main_window;
   
