pragma Source_File_Name (ada_main, Spec_File_Name => "b~drop_down_demo.ads");
pragma Source_File_Name (ada_main, Body_File_Name => "b~drop_down_demo.adb");

package body ada_main is
   pragma Warnings (Off);

   procedure Do_Finalize;
   pragma Import (C, Do_Finalize, "system__standard_library__adafinal");

   procedure adainit is
      E012 : Boolean; pragma Import (Ada, E012, "system__secondary_stack_E");
      E008 : Boolean; pragma Import (Ada, E008, "ada__exceptions_E");
      E025 : Boolean; pragma Import (Ada, E025, "system__exceptions_E");
      E017 : Boolean; pragma Import (Ada, E017, "system__soft_links_E");
      E031 : Boolean; pragma Import (Ada, E031, "system__exception_table_E");
      E079 : Boolean; pragma Import (Ada, E079, "ada__io_exceptions_E");
      E048 : Boolean; pragma Import (Ada, E048, "ada__strings_E");
      E070 : Boolean; pragma Import (Ada, E070, "ada__tags_E");
      E068 : Boolean; pragma Import (Ada, E068, "ada__streams_E");
      E087 : Boolean; pragma Import (Ada, E087, "interfaces__c_E");
      E089 : Boolean; pragma Import (Ada, E089, "interfaces__c__strings_E");
      E067 : Boolean; pragma Import (Ada, E067, "system__finalization_root_E");
      E054 : Boolean; pragma Import (Ada, E054, "ada__strings__maps_E");
      E158 : Boolean; pragma Import (Ada, E158, "ada__strings__maps__constants_E");
      E072 : Boolean; pragma Import (Ada, E072, "system__finalization_implementation_E");
      E065 : Boolean; pragma Import (Ada, E065, "ada__finalization_E");
      E099 : Boolean; pragma Import (Ada, E099, "ada__finalization__list_controller_E");
      E050 : Boolean; pragma Import (Ada, E050, "ada__strings__unbounded_E");
      E097 : Boolean; pragma Import (Ada, E097, "system__file_control_block_E");
      E096 : Boolean; pragma Import (Ada, E096, "system__file_io_E");
      E092 : Boolean; pragma Import (Ada, E092, "ada__text_io_E");
      E081 : Boolean; pragma Import (Ada, E081, "cargv_E");
      E101 : Boolean; pragma Import (Ada, E101, "cargv_helpers_E");
      E085 : Boolean; pragma Import (Ada, E085, "chelper_E");
      E135 : Boolean; pragma Import (Ada, E135, "expanding_array_E");
      E043 : Boolean; pragma Import (Ada, E043, "mcc_E");
      E141 : Boolean; pragma Import (Ada, E141, "tcl_E");
      E153 : Boolean; pragma Import (Ada, E153, "tcl__ada_E");
      E151 : Boolean; pragma Import (Ada, E151, "peer_E");
      E047 : Boolean; pragma Import (Ada, E047, "mcc__gui_E");
      E191 : Boolean; pragma Import (Ada, E191, "mcc__gui__colors_E");
      E130 : Boolean; pragma Import (Ada, E130, "mcc__gui__container_E");
      E132 : Boolean; pragma Import (Ada, E132, "mcc__gui__container__window_E");
      E149 : Boolean; pragma Import (Ada, E149, "mcc__common_dialogs_E");
      E189 : Boolean; pragma Import (Ada, E189, "mcc__gui__fonts_E");
      E145 : Boolean; pragma Import (Ada, E145, "mcc__gui__widget_E");
      E187 : Boolean; pragma Import (Ada, E187, "mcc__gui__widget__button_E");
      E197 : Boolean; pragma Import (Ada, E197, "mcc__gui__widget__button__text_E");
      E147 : Boolean; pragma Import (Ada, E147, "mcc__gui__widget__dropdown_E");
      E183 : Boolean; pragma Import (Ada, E183, "mcc__gui__widget__label_E");
      E005 : Boolean; pragma Import (Ada, E005, "main_window_E");
      E177 : Boolean; pragma Import (Ada, E177, "mcc__gui__widget__listbox_E");
      E179 : Boolean; pragma Import (Ada, E179, "mcc__gui__widget__progress_E");
      E181 : Boolean; pragma Import (Ada, E181, "mcc__gui__widget__textbox_E");
      E133 : Boolean; pragma Import (Ada, E133, "my_expanding_array_E");
      E143 : Boolean; pragma Import (Ada, E143, "tcl__tk_E");
      E155 : Boolean; pragma Import (Ada, E155, "tcl_utilities_E");

      Restrictions : constant String :=
        "nnvvnnnvvnnvnnvnvvvvvvnvvnvnvnnvnnnvnvvnnnnnnvvvvnnnvvnv";

      Interrupt_States : constant String :=
        "";

      procedure Set_Globals
        (Main_Priority            : Integer;
         Time_Slice_Value         : Integer;
         WC_Encoding              : Character;
         Locking_Policy           : Character;
         Queuing_Policy           : Character;
         Task_Dispatching_Policy  : Character;
         Restrictions             : System.Address;
         Interrupt_States         : System.Address;
         Num_Interrupt_States     : Integer;
         Unreserve_All_Interrupts : Integer;
         Exception_Tracebacks     : Integer;
         Zero_Cost_Exceptions     : Integer);
      pragma Import (C, Set_Globals, "__gnat_set_globals");

      procedure Install_Handler;
      pragma Import (C, Install_Handler, "__gnat_install_handler");

      Handler_Installed : Integer;
      pragma Import (C, Handler_Installed, "__gnat_handler_installed");
   begin
      Set_Globals
        (Main_Priority            => -1,
         Time_Slice_Value         => -1,
         WC_Encoding              => 'b',
         Locking_Policy           => ' ',
         Queuing_Policy           => ' ',
         Task_Dispatching_Policy  => ' ',
         Restrictions             => Restrictions'Address,
         Interrupt_States         => Interrupt_States'Address,
         Num_Interrupt_States     => 0,
         Unreserve_All_Interrupts => 0,
         Exception_Tracebacks     => 0,
         Zero_Cost_Exceptions     => 0);

      if Handler_Installed = 0 then
         Install_Handler;
      end if;

      Ada.Exceptions'Elab_Spec;
      System.Exceptions'Elab_Spec;
      E025 := True;
      System.Soft_Links'Elab_Body;
      E017 := True;
      System.Secondary_Stack'Elab_Body;
      E012 := True;
      System.Exception_Table'Elab_Body;
      E031 := True;
      Ada.Io_Exceptions'Elab_Spec;
      E079 := True;
      Ada.Strings'Elab_Spec;
      E048 := True;
      Ada.Tags'Elab_Spec;
      Ada.Tags'Elab_Body;
      E070 := True;
      Ada.Streams'Elab_Spec;
      E068 := True;
      Interfaces.C'Elab_Spec;
      E087 := True;
      Interfaces.C.Strings'Elab_Spec;
      E089 := True;
      System.Finalization_Root'Elab_Spec;
      E067 := True;
      Ada.Exceptions'Elab_Body;
      E008 := True;
      Ada.Strings.Maps'Elab_Spec;
      E054 := True;
      Ada.Strings.Maps.Constants'Elab_Spec;
      E158 := True;
      System.Finalization_Implementation'Elab_Spec;
      System.Finalization_Implementation'Elab_Body;
      E072 := True;
      Ada.Finalization'Elab_Spec;
      E065 := True;
      Ada.Finalization.List_Controller'Elab_Spec;
      E099 := True;
      Ada.Strings.Unbounded'Elab_Spec;
      E050 := True;
      System.File_Control_Block'Elab_Spec;
      E097 := True;
      System.File_Io'Elab_Body;
      E096 := True;
      Ada.Text_Io'Elab_Spec;
      Ada.Text_Io'Elab_Body;
      E092 := True;
      Cargv'Elab_Spec;
      Cargv_Helpers'Elab_Spec;
      E101 := True;
      E085 := True;
      E081 := True;
      E135 := True;
      E043 := True;
      Tcl'Elab_Spec;
      E141 := True;
      Tcl.Ada'Elab_Spec;
      E153 := True;
      mcc.gui'elab_spec;
      mcc.gui.colors'elab_spec;
      E191 := True;
      mcc.gui.container'elab_spec;
      E130 := True;
      mcc.gui.container.window'elab_spec;
      mcc.gui.fonts'elab_spec;
      mcc.gui.widget'elab_spec;
      mcc.gui.widget.button'elab_spec;
      mcc.gui.widget.button.text'elab_spec;
      E197 := True;
      mcc.gui.widget.dropdown'elab_spec;
      E147 := True;
      mcc.gui.widget.label'elab_spec;
      E183 := True;
      main_window'elab_spec;
      E005 := True;
      mcc.gui.widget.listbox'elab_spec;
      E177 := True;
      mcc.gui.fonts'elab_body;
      E189 := True;
      mcc.gui.widget.progress'elab_spec;
      E179 := True;
      mcc.gui.widget.textbox'elab_spec;
      E181 := True;
      E145 := True;
      My_Expanding_Array'Elab_Spec;
      E133 := True;
      E187 := True;
      E047 := True;
      E143 := True;
      E132 := True;
      peer'elab_body;
      E151 := True;
      E155 := True;
      E149 := True;
   end adainit;

   procedure adafinal is
   begin
      Do_Finalize;
   end adafinal;

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer
   is
      procedure initialize;
      pragma Import (C, initialize, "__gnat_initialize");

      procedure finalize;
      pragma Import (C, finalize, "__gnat_finalize");


      procedure Ada_Main_Program;
      pragma Import (Ada, Ada_Main_Program, "_ada_drop_down_demo");

      Ensure_Reference : System.Address := Ada_Main_Program_Name'Address;

   begin
      gnat_argc := argc;
      gnat_argv := argv;
      gnat_envp := envp;

      Initialize;
      adainit;
      Break_Start;
      Ada_Main_Program;
      Do_Finalize;
      Finalize;
      return (gnat_exit_status);
   end;

--  BEGIN Object file/option list
   --   ./cargv_helpers.o
   --   E:/MinGW/msys/1.0/tash841a/src\chelper.o
   --   E:/MinGW/msys/1.0/tash841a/src\cargv.o
   --   ./enum_try.o
   --   ./expanding_array.o
   --   ./mcc.o
   --   E:/MinGW/msys/1.0/tash841a/src\tcl.o
   --   E:/MinGW/msys/1.0/tash841a/src\tcl-ada.o
   --   ./mcc-gui-colors.o
   --   ./mcc-gui-container.o
   --   ./mcc-gui-widget-button-text.o
   --   ./mcc-gui-widget-dropdown.o
   --   ./mcc-gui-widget-label.o
   --   ./drop_down_demo.o
   --   ./main_actions.o
   --   ./main_window.o
   --   ./mcc-gui-widget-listbox.o
   --   ./mcc-gui-fonts.o
   --   ./mcc-gui-widget-progress.o
   --   ./mcc-gui-widget-textbox.o
   --   ./mcc-gui-widget.o
   --   ./my_expanding_array.o
   --   ./mcc-gui-widget-button.o
   --   ./mcc-gui.o
   --   E:/MinGW/msys/1.0/tash841a/src\tcl-tk.o
   --   ./mcc-gui-container-window.o
   --   ./peer.o
   --   ./tcl_utilities.o
   --   ./mcc-common_dialogs.o
   --   -L./
   --   -L../../include\
   --   -LE:/MinGW/msys/1.0/tash841a/src\
   --   -Le:/MinGW/lib/gcc/mingw32/3.4.5/adalib/
   --   -static
   --   -lgnat
   --   -Wl,--stack=0x2000000
--  END Object file/option list   

end ada_main;
