import random

from pygsear.Drawable import Rectangle, Square, String, Image
from pygsear.locals import WHITE, TRANSPARENT

class Target:
    def __init__(self):
        pass

    def die(self, ev=None):
        self.kill()

class Rectangle_Target(Target, Rectangle):
    def __init__(self, minSize=5, maxSize=70, color=WHITE, bgcolor=TRANSPARENT):
        Target.__init__(self)
        side1 = random.randrange(minSize, maxSize)
        side2 = random.randrange(minSize, maxSize)
        while abs(side1 - side2) < 15:
            side2 = random.randrange(minSize, maxSize)
        Rectangle.__init__(self, side1, side2, color, bgcolor)


class Square_Target(Target, Square):
    def __init__(self, minSize=5, maxSize=70, color=WHITE, bgcolor=TRANSPARENT):
        Target.__init__(self)
        side = random.randrange(minSize, maxSize)
        Square.__init__(self, side, color, bgcolor)


class Number_Target(Target, String):
    def __init__(self, number=None, fontSize=50, color=WHITE, bgcolor=TRANSPARENT, **kwargs):
        Target.__init__(self)
        self.fontSize = fontSize
        self.color = color
        self.bgcolor = bgcolor
        if number is None:
            minimum = kwargs.get('minimum', 1)
            maximum = kwargs.get('maximum', 9)
            self.random(minimum, maximum)
        else:
            self.set_number(number)

    def set_number(self, number):
        self.number = number
        String.__init__(self, message=number, fontSize=self.fontSize, color=self.color, bgcolor=self.bgcolor)

    def random(self, minimum, maximum):
        number = random.randrange(minimum, maximum+1)
        self.set_number(number)

    def is_negative(self):
        if self.number < 0:
            return True
        else:
            return False

    def is_positive(self):
        if self.number > 0:
            return True
        else:
            return False

    def is_zero(self):
        if self.number == 0:
            return True
        else:
            return False

    def is_even(self):
        if not self.number % 2:
            return True
        else:
            return False

    def is_odd(self):
        if self.number % 2:
            return True
        else:
            return False


class OddNumber_Target(Number_Target):
    def __init__(self, minVal=1, maxVal=9, fontSize=50, color=WHITE, bg=TRANSPARENT):
        Number_Target.__init__(self, minVal, maxVal, fontSize, color, bg)


class AlgPhrase_Target(Number_Target):
    def __init__(self, minTerms=1, maxTerms=1, opTypes=['+'], minVal=1, maxVal=9, fontSize=80, color=WHITE, bg=TRANSPARENT):
        Target.__init__(self)
        vals = []
        ops = []
        s = ''
        nTerms = random.randrange(minTerms, maxTerms+1)
        for n in range(nTerms):
            randVal = random.randrange(minVal, maxVal+1)
            vals.append(randVal)
            randOp = random.choice(opTypes)
            ops.append(randOp)
            s += str(randVal) + str(randOp)
        s = s[:-1]
        self.total = eval(s.replace('x', '*'))
        String.__init__(self, message=s, fontSize=fontSize, color=color, bgcolor=bg)
