from pygsear.Drawable import Image, Multi, MultiRotated


class Creature:
    def __init__(self):
        self.right = 0
        self.left = 0
        self.up = 0
        self.down = 0

    def start_left(self, ev):
        self.left = 1
    def stop_left(self, ev):
        self.left = 0

    def start_right(self, ev):
        self.right = 1
    def stop_right(self, ev):
        self.right = 0

    def start_up(self, ev):
        self.up = 1
    def stop_up(self, ev):
        self.up = 0

    def start_down(self, ev):
        self.down = 1
    def stop_down(self, ev):
        self.down = 0


class Blob(Creature, MultiRotated):
    def __init__(self):
        Creature.__init__(self)
        filenames = ['blob01.png', 'blob02.png', 'blob03.png', 'blob04.png']
        MultiRotated.__init__(self, filenames=filenames, steps=36, colorkey=None)

        m = min(self.crect.h, self.crect.w)
        self.crect.h = m
        self.crect.w = m
        self.crect.inflate_ip(-24, -24)

        self.speed = 100

    def move(self):
        if self.left and not self.right:
            self.rotate_left()
        elif self.right and not self.left:
            self.rotate_right()
        else:
            self.rotate_stop()

        if self.up and not self.down:
            self.path.set_speed(self.speed)
            self.set_flip_images_rate(7)
        elif self.down and not self.up:
            self.path.set_speed(-self.speed/2)
            self.set_flip_images_rate(4)
        else:
            self.path.set_speed(0)
            self.set_flip_images_rate(0)
            self.switch_images('blob01.png')

        self.path.set_direction(self.get_rotation())
        MultiRotated.move(self)


class Egg(Creature, Image):
    def __init__(self):
        Creature.__init__(self)
        Image.__init__(self, filename='egg.png')

        self.speed = 285
        self.path.set_restriction(speed=self.speed)
        self.acc = 210
        self.dec = 45

    def move(self):
        vx, vy = self.path.get_velocity()

        if self.right and not self.left:
            if vx >= 0:
                self.path.set_acceleration(ax=self.acc)
            elif vx < 0:
                self.path.set_acceleration(ax=self.acc+self.dec)
        elif self.left and not self.right:
            if vx >= 0:
                self.path.set_acceleration(ax=-(self.acc+self.dec))
            elif vx < 0:
                self.path.set_acceleration(ax=-self.acc)
        else:
            if vx > 0:
                self.path.set_acceleration(ax=-self.dec)
            elif vx < 0:
                self.path.set_acceleration(ax=self.dec)

        if self.down and not self.up:
            if vy >= 0:
                self.path.set_acceleration(ay=self.acc)
            elif vy < 0:
                self.path.set_acceleration(ay=self.acc+self.dec)
        elif self.up and not self.down:
            if vy >= 0:
                self.path.set_acceleration(ay=-(self.acc+self.dec))
            elif vy < 0:
                self.path.set_acceleration(ay=-self.acc)
        else:
            if vy > 0:
                self.path.set_acceleration(ay=-self.dec)
            elif vy < 0:
                self.path.set_acceleration(ay=self.dec)

        Image.move(self)


class Snake(Creature):
    def __init__(self):
        Creature.__init__(self)
        self.length = 10

        self.speed = 50
        self.path.set_speed(self.speed)

        self.direction = -0.75
        self.path.set_direction(self.direction)
        self.turnrate = 0.15

        self.right = 0
        self.left = 0

        self.head = SnakeHead(self)
        self.addSprite(self.head)
        self.tail = []

    def slower(self, ev):
        self.speed -= 1

    def move(self):
        if self.right and not self.left:
            self.turnLeft()
        elif self.left and not self.right:
            self.turnRight()

        self.path.set_direction(self.direction)
        Multi.move(self)
        #         if len(self.tail) < self.length:
        #             self.add_segment()
        #         elif self.style != 'normal':
        #             self.changeImages('normal')
        #         if self.tail:
        #             self.tail[-1].rect[0] = self.head.rect[0]
        #             self.tail[-1].rect[1] = self.head.rect[1]
        #             self.head.move(self.speed, self.direction)
        #             self.tail.insert(0, self.tail.pop())
        #         else:
        #             self.head.move(self.speed, self.direction)

    def set_turnrate(self, ev, rate):
        self.turnrate = rate

    def turnLeft(self):
        self.direction += -self.turnrate

    def turnRight(self):
        self.direction += self.turnrate

    def changeLength(self, addToLength=5):
        self.length += addToLength

    def changeImages(self, style):
        self.style = style
        self.head.image = self.headImages[style]
        for segment in self.tail:
            segment.image = self.tailImages[style]

    def followMove(self):
        tailq = self.tail[:]
        tailq.reverse()
        for seg in tailq:
            seg.follow()
        self.head.move(self.speed, self.direction)
        #print self.spritedict
        #print self.sprites()
        if len(self.sprites()) > 1:
            pass
            #print 'IS', self.sprites()[0] is self.sprites()[1]

    def add_segment(self, ev=None):
        if self.tail:
            lead = self.tail[-1]
        else:
            lead = self.head
        seg = SnakeSegment(self, lead)
        self.tail.append(seg)


class SnakeHead(Image):
    def __init__(self, snake):
        Image.__init__(self, filename='newsnh.png')
        self.snake = snake


class SnakeSegment(Image):
    def __init__(self, snake, lead):
        Image.__init__(self, filename='newsn.png')
        self.snake = snake
        self.lead = lead

    def move(self, speed, direction):
        dx = speed * math.cos(direction)
        dy = speed * math.sin(direction)

        self.rect[0] += dx
        self.rect[1] += dy

        if self.wrapping:
            if self.rect[0] < 0:
                self.rect[0] = WINSIZE[0]
            elif self.rect[0] > WINSIZE[0]:
                self.rect[0] = 0
            if self.rect[1] < 0:
                self.rect[1] = WINSIZE[1]
            elif self.rect[1] > WINSIZE[1]:
                self.rect[1] = 0
        else:
            self.touchedWall = 1
            if self.rect[0] < 0 or self.rect[0] > WINSIZE[0]:
                self.rect[0] -= dx
            if self.rect[1] < 0 or self.rect[1] > WINSIZE[1]:
                self.rect[1] -= dy

    def follow(self):
        self.rect[0] = self.lead.rect[0]
        self.rect[1] = self.lead.rect[1]
    


