/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Line2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.nongnu.pulsefire.device.ui.JComponentFactory;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.components.JFireDial;
import org.nongnu.pulsefire.device.ui.tabs.AbstractFireTabPanel;

public class JTabPanelScope
extends AbstractFireTabPanel
implements ActionListener,
JFireDial.DialListener {
    private static final long serialVersionUID = -6711428986888517858L;
    private Logger logger = null;
    private JScopePanel scopePanel = null;
    private JButton startButton = null;
    private JButton channelsButton = null;
    private CaptureManager captureManager = null;
    private JFireDial gainDialA = null;
    private JFireDial gainDialB = null;
    private JFireDial timeDial = null;
    private List<Line2D> lines0 = Collections.synchronizedList(new ArrayList(15000));
    private List<Line2D> lines1 = Collections.synchronizedList(new ArrayList(15000));
    private AudioInputStream audioInputStream = null;

    public JTabPanelScope() {
        this.logger = Logger.getLogger(JTabPanelScope.class.getName());
        this.captureManager = new CaptureManager();
        this.setLayout(new FlowLayout(0));
        JPanel wrap = new JPanel();
        wrap.add((Component)this.createScope(), "Center");
        wrap.add((Component)this.createScopeOptions(), "After");
        this.add(wrap);
    }

    private JPanel createScopeOptions() {
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new BoxLayout(optionPanel, 3));
        JPanel inputPanel = JComponentFactory.createJFirePanel("Options");
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(this);
        inputPanel.add(this.startButton);
        this.channelsButton = new JButton("Channels");
        this.channelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JAudioCardDialog audioDialog = new JAudioCardDialog(PulseFireUI.getInstance().getMainFrame());
                audioDialog.pack();
                audioDialog.setLocationRelativeTo(PulseFireUI.getInstance().getMainFrame());
                audioDialog.setVisible(true);
            }
        });
        inputPanel.add(this.channelsButton);
        this.gainDialA = new JFireDial(-100, 100, 0);
        this.gainDialA.addDialListener(this);
        inputPanel.add(this.gainDialA);
        this.gainDialB = new JFireDial(-100, 100, 0);
        this.gainDialB.addDialListener(this);
        inputPanel.add(this.gainDialB);
        this.timeDial = new JFireDial(1, 32768, 32768);
        this.timeDial.addDialListener(this);
        this.timeDial.setEnabled(false);
        inputPanel.add(this.timeDial);
        optionPanel.add(inputPanel);
        for (int i = 0; i < 3; ++i) {
            JPanel channelPanel = JComponentFactory.createJFirePanel("Channel A");
            JFireDial gainChannel = new JFireDial(-100, 100, 0);
            gainChannel.setEnabled(false);
            channelPanel.add(gainChannel);
            optionPanel.add(channelPanel);
        }
        return optionPanel;
    }

    private JPanel createScope() {
        JPanel panel = JComponentFactory.createJFirePanel("Scope");
        this.scopePanel = new JScopePanel();
        panel.add(this.scopePanel);
        return panel;
    }

    @Override
    public Class<?> getTabClassName() {
        return this.getClass();
    }

    private AudioFormat getAudioFormat() {
        float sampleRate = 44100.0f;
        int sampleSizeInBits = 16;
        int channels = 2;
        boolean signed = true;
        boolean bigEndian = false;
        return new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.captureManager.isRunning()) {
            this.captureManager.stop();
            this.startButton.setText("Start");
        } else {
            this.captureManager.start();
            this.startButton.setText("Stop");
        }
    }

    @Override
    public void dialAdjusted(JFireDial.DialEvent e) {
    }

    public class JAudioCardDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 5741561145725436759L;
        private JTable table;
        private AudioCardTableModel tableModel;

        public JAudioCardDialog(Frame aFrame) {
            super(aFrame, true);
            this.table = null;
            this.tableModel = null;
            this.setTitle("Audio");
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            this.tableModel = new AudioCardTableModel();
            this.table = new JTable(this.tableModel);
            this.table.getTableHeader().setReorderingAllowed(false);
            this.table.getTableHeader().setResizingAllowed(true);
            this.table.setAutoResizeMode(0);
            this.table.setFillsViewportHeight(true);
            this.table.setShowHorizontalLines(true);
            this.table.setSelectionMode(0);
            this.table.setRowMargin(2);
            this.table.setRowHeight(26);
            TableColumn nameColumn = this.table.getColumnModel().getColumn(0);
            nameColumn.setPreferredWidth(150);
            TableColumn speedColumn = this.table.getColumnModel().getColumn(1);
            speedColumn.setPreferredWidth(130);
            ToolTipManager.sharedInstance().unregisterComponent(this.table);
            ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
            JScrollPane scroll = new JScrollPane(this.table);
            mainPanel.add((Component)scroll, "Center");
            this.getContentPane().add(mainPanel);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    JAudioCardDialog.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public class AudioCardTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = -1432038909521987705L;
            private List<MixerInfo> data = null;
            private String[] columnNames = new String[]{"name", "description", "vendor"};

            public AudioCardTableModel() {
                this.data = new ArrayList<MixerInfo>(10);
                for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
                    Mixer mixer = AudioSystem.getMixer(mixerInfo);
                    try {
                        mixer.open();
                        MixerInfo mi = new MixerInfo();
                        mi.mixerInfo = mixerInfo;
                        for (Line.Info lineInfo : mixer.getSourceLineInfo()) {
                            mi.data.add(lineInfo);
                        }
                        if (mi.data.isEmpty()) continue;
                        this.data.add(mi);
                    }
                    catch (LineUnavailableException e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public int getRowCount() {
                return this.data.size();
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                MixerInfo mi = this.data.get(row);
                switch (col) {
                    default: {
                        return mi.mixerInfo.getName();
                    }
                    case 1: {
                        return mi.mixerInfo.getDescription();
                    }
                    case 2: 
                }
                return mi.data.size();
            }
        }

        class MixerInfo {
            Mixer.Info mixerInfo = null;
            List<Line.Info> data = new ArrayList<Line.Info>(10);

            MixerInfo() {
            }
        }
    }

    class JScopePanel
    extends JPanel {
        private static final long serialVersionUID = -8942308841693048263L;

        public JScopePanel() {
            this.setPreferredSize(new Dimension(600, 300));
        }

        @Override
        public void paint(Graphics g) {
            int i;
            Dimension d = this.getSize();
            int w = d.width;
            int h = d.height;
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(this.getBackground());
            g2.clearRect(0, 0, w, h);
            g2.setColor(Color.YELLOW);
            for (i = 0; i < 10; ++i) {
                g2.drawLine(0, i * (h / 10), w, i * (h / 10));
            }
            g2.setColor(Color.YELLOW);
            for (i = 0; i < 10; ++i) {
                g2.drawLine(i * (w / 10), 0, i * (w / 10), h);
            }
            g2.drawLine(0, h - 1, w - 1, h - 1);
            g2.drawLine(w - 1, 0, w - 1, h - 1);
            g2.setColor(Color.BLUE);
            for (i = 1; i < JTabPanelScope.this.lines0.size(); ++i) {
                g2.draw((Line2D)JTabPanelScope.this.lines0.get(i));
            }
            g2.setColor(Color.CYAN);
            for (i = 1; i < JTabPanelScope.this.lines1.size(); ++i) {
                g2.draw((Line2D)JTabPanelScope.this.lines1.get(i));
            }
        }

        public void createWaveForm(byte[] audioBytes) {
            int i;
            int nlengthInSamples;
            JTabPanelScope.this.lines0.clear();
            JTabPanelScope.this.lines1.clear();
            AudioFormat format = JTabPanelScope.this.audioInputStream.getFormat();
            if (audioBytes == null) {
                try {
                    audioBytes = new byte[(int)(JTabPanelScope.this.audioInputStream.getFrameLength() * (long)format.getFrameSize())];
                    JTabPanelScope.this.audioInputStream.read(audioBytes);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            }
            int[] audioData = null;
            if (format.getSampleSizeInBits() == 16) {
                nlengthInSamples = audioBytes.length / 2;
                audioData = new int[nlengthInSamples];
                if (format.isBigEndian()) {
                    for (i = 0; i < nlengthInSamples; ++i) {
                        byte MSB = audioBytes[2 * i];
                        byte LSB = audioBytes[2 * i + 1];
                        audioData[i] = MSB << 8 | 0xFF & LSB;
                    }
                } else {
                    for (i = 0; i < nlengthInSamples; ++i) {
                        byte LSB = audioBytes[2 * i];
                        byte MSB = audioBytes[2 * i + 1];
                        audioData[i] = MSB << 8 | 0xFF & LSB;
                    }
                }
            } else if (format.getSampleSizeInBits() == 8) {
                nlengthInSamples = audioBytes.length;
                audioData = new int[nlengthInSamples];
                if (format.getEncoding().toString().startsWith("PCM_SIGN")) {
                    for (i = 0; i < audioBytes.length; ++i) {
                        audioData[i] = audioBytes[i];
                    }
                } else {
                    for (i = 0; i < audioBytes.length; ++i) {
                        audioData[i] = audioBytes[i] - 128;
                    }
                }
            }
            Dimension d = this.getSize();
            int w = d.width;
            int h = d.height - 15;
            int frames_per_pixel = audioBytes.length / format.getFrameSize() / w;
            byte my_byte0 = 0;
            byte my_byte1 = 0;
            double y_last0 = 0.0;
            double y_last1 = 0.0;
            int numChannels = format.getChannels();
            for (double x = 0.0; x < (double)w && audioData != null; x += 1.0) {
                int idx;
                if (numChannels == 1) {
                    idx = (int)((double)(frames_per_pixel * numChannels) * x);
                    my_byte0 = format.getSampleSizeInBits() == 8 ? (byte)audioData[idx] : (byte)(128 * audioData[idx] / 32768);
                    double y_new = h * (128 - my_byte0) / 256;
                    JTabPanelScope.this.lines0.add(new Line2D.Double(x, y_last0, x, y_new += (double)JTabPanelScope.this.gainDialA.getValue()));
                    y_last0 = y_new;
                    continue;
                }
                idx = (int)((double)(frames_per_pixel * 2) * x);
                if (format.getSampleSizeInBits() == 8) {
                    my_byte0 = (byte)audioData[idx];
                    my_byte1 = (byte)audioData[idx + 1];
                } else {
                    my_byte0 = (byte)(128 * audioData[idx] / 32768);
                    my_byte1 = (byte)(128 * audioData[idx + 1] / 32768);
                }
                double y_new0 = h * (128 - my_byte0) / 256;
                double y_new1 = h * (128 - my_byte1) / 256;
                JTabPanelScope.this.lines0.add(new Line2D.Double(x, y_last0, x, y_new0 += (double)JTabPanelScope.this.gainDialA.getValue()));
                y_last0 = y_new0;
                JTabPanelScope.this.lines1.add(new Line2D.Double(x, y_last1, x, y_new1 += (double)JTabPanelScope.this.gainDialB.getValue()));
                y_last1 = y_new1;
            }
            this.repaint();
        }
    }

    class CaptureManager
    implements Runnable {
        volatile TargetDataLine line = null;
        volatile Thread thread = null;

        CaptureManager() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.setName("Capture");
            this.thread.start();
            JTabPanelScope.this.logger.info("Starting capture thread.");
        }

        public boolean isRunning() {
            return this.thread != null;
        }

        public void stop() {
            JTabPanelScope.this.logger.info("Stopping capture thread.");
            this.thread = null;
        }

        private void shutDown(String message) {
            this.stop();
        }

        @Override
        public void run() {
            AudioFormat format = JTabPanelScope.this.getAudioFormat();
            DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
            if (!AudioSystem.isLineSupported(info)) {
                this.shutDown("Line matching " + info + " not supported.");
                return;
            }
            try {
                this.line = (TargetDataLine)AudioSystem.getLine(info);
                this.line.open(format, this.line.getBufferSize());
            }
            catch (LineUnavailableException ex) {
                this.shutDown("Unable to open the line: " + ex);
                return;
            }
            catch (SecurityException ex) {
                this.shutDown(ex.toString());
                return;
            }
            catch (Exception ex) {
                this.shutDown(ex.toString());
                return;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int frameSizeInBytes = format.getFrameSize();
            int bufferLengthInFrames = this.line.getBufferSize() / 8;
            int bufferLengthInBytes = bufferLengthInFrames * frameSizeInBytes;
            byte[] data = new byte[bufferLengthInBytes];
            this.line.start();
            while (this.thread != null) {
                if (this.line.available() < 10000) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                int numBytesRead = this.line.read(data, 0, bufferLengthInBytes);
                if (numBytesRead == -1) break;
                out.write(data, 0, numBytesRead);
                byte[] audioBytes = out.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(audioBytes);
                JTabPanelScope.this.audioInputStream = new AudioInputStream(bais, format, audioBytes.length / frameSizeInBytes);
                try {
                    JTabPanelScope.this.audioInputStream.reset();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                JTabPanelScope.this.scopePanel.createWaveForm(audioBytes);
                out.reset();
            }
            try {
                this.line.stop();
                this.line.close();
                this.line = null;
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public class ScopeDataChannel {
    }
}

