<?php
##############################################################
# FILENAME  : tournaments.php
# COPYRIGHT : (c) 2006, Tyler N. King <aibotca@yahoo.ca>
# GPL v2.0 or later. See docs/COPYING.
##############################################################
# This program is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) 
# any later version.
#
# This program is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with this program; if not, write to the 
# Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, 
# Boston, MA  02110-1301  USA
##############################################################
define ( IN_PHPBB, true );
$phpbb_root_path	= './';

include ( $phpbb_root_path . 'includes/page_header.'.$phpEx );

if ( !$userdata[ 'session_logged_in' ] )
{
	message_die ( GENERAL_MESSAGE, $lang[ 'rivals_ltfin' ] );
}

if ( !empty ( $http_vars[ 'tournament_id' ] ) )
{
	$math	= $tournament->data[ 'tournament_brackets' ] - count ( explode ( '|', $tournament->data[ 'tournament_clans' ] ) );
	message_die ( GENERAL_MESSAGE, sprintf ( $lang[ 'rivals_wwww' ], ( $math < 0 ) ? 0 : $math, $tournament->data[ 'tournament_info' ] ) );
}

$sql	= 'SELECT * FROM ' . TOURNAMENTS_TABLE . ' WHERE tournament_state != "2"';
$result	= $db->sql_query ( $sql );

if ( $db->sql_numrows ( $result ) > 0 )
{
	for ( $i = 0; $i < $db->sql_numrows ( $result ); $i++ )
	{
		$row	= $db->sql_fetchrow ( $result );

		$sql_2		= 'SELECT * FROM ' . SPONSORS_TABLE . ' WHERE sponsor_tournament = ' . $row[ 'tournament_id' ];
		$result_2	= $db->sql_query ( $sql_2 );

		$code		= ( $row[ 'tournament_status' ] == 1 ) ? '<input type="hidden" name="tournament" value="' . $row[ 'tournament_id' ] . '" /><input type="submit" name="submit" value="' . $lang[ 'rivals_tfcnt' ] . '">' : '';
		$code_2		= ( $db->sql_numrows ( $result_2 ) > 0 ) ? '(<a href="' . append_sid ( 'rivals.php?action=sponsors&tournament_id=' . $row[ 'tournament_id' ] ) . '">' . $lang[ 'rivals_gdhj' ] . '</a>)' : '';

		$template->assign_block_vars ( 'block_tournaments', array (
			'U_SIGNUP' => $code,
			'U_SPONSORS' => $code_2,
			'S_I' => $i + 1,
			'S_ROWCOLOR' => ( $i % 2 ) ? 'row1' : 'row2',
			'L_DETAILS' => $lang[ 'rivals_vmd' ],
			'U_ACTION' => append_sid ( 'rivals.php?action=brackets&tournament_id=' . $row[ 'tournament_id' ] ),
			'U_ACTION2' => append_sid ( 'rivals.php?action=tournaments&tournament_id=' . $row[ 'tournament_id' ] ),
			'U_ACTION3' => append_sid ( 'rivals.php?action=sign_up&tournament_id=' . $row[ 'tournament_id' ] ),
			'S_TOURNAMENTNAME' => $row[ 'tournament_name' ] )
		);
	}
}
else
{
	$template->assign_block_vars ( 'block_not', array (
		'L_NOTOURNAMENTS' => $lang[ 'rivals_67h' ] )
	);
}

$template->assign_vars ( array (
	'L_TOURNAMENTS' => $lang[ 'rivals_swiz' ] )
);

$template->set_filenames ( array (
	'body' => 'rivals/ts_mode4.tpl' )
);

$template->pparse ( 'body' );

include ( $phpbb_root_path . 'includes/page_tail.'.$phpEx )

?>
