#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from qt import *
from OBBLabel import OBBLabel
from PushButton import PushButton
from PixmapSet import *

class OBBSpinBox(OBBLabel):
    def __init__( self,
                  labelPixSet,
                  upPixSet,
                  downPixSet,
                  parent=None,
                  x=0,
                  y=0,
                  stretchPoint=30,
                  stretchSize=50,
                  wantedSize=100,
                  borderX = 5,
                  borderY = 7,
                  fontSize = 12 ):
        OBBLabel.__init__( self,
                           labelPixSet,
                           parent,
                           x,
                           y,
                           stretchPoint,
                           stretchSize,
                           wantedSize,
                           borderX,
                           borderY,
                           fontSize )
        self.__up = PushButton( upPixSet, self, self.width()+3, 5 )
        self.__down = PushButton( downPixSet, self, self.width()+3, 25 )
        
        self.addSubWidget(self.__up)
        self.addSubWidget(self.__down)

        self.connect( self.__up, PYSIGNAL("clicked()"), self.increment)
        self.connect( self.__down, PYSIGNAL("clicked()"), self.decrement)
        self.connect( self, PYSIGNAL("beingWheeled(e)"), self.processWheel)
        
        self.__max = 600
        self.__min = 30
        self.__value = self.__min

        self.setupTimers()

    def setupTimers(self):
        # TODO lower the timeout delay after some time
        self.__incTimer = QTimer()
        self.__decTimer = QTimer()
        self.__timerInterval = 300

        self.connect( self.__incTimer, SIGNAL("timeout()"), self.increment )
        self.connect( self.__decTimer, SIGNAL("timeout()"), self.decrement )

        self.connect( self.__up,
                      PYSIGNAL("beingPressed(e)"),
                      self.startIncTimer )

        self.connect( self.__down,
                      PYSIGNAL("beingPressed(e)"),
                      self.startDecTimer )

        self.connect( self.__up,
                      PYSIGNAL("beingReleased(e)"),
                      self.__incTimer.stop )

        self.connect( self.__down,
                      PYSIGNAL("beingReleased(e)"),
                      self.__decTimer.stop )

    def startIncTimer(self):
        self.__incTimer.start(self.__timerInterval)

    def startDecTimer(self):
        self.__decTimer.start(self.__timerInterval)

    def increment(self):
        self.setValue(self.__value+1)

    def decrement(self):
        self.setValue(self.__value-1)

    def setValue(self, value):
        if self.__min <= value <= self.__max:
            self.__value = value
            self.setText("%d" % value)
            self.emit(PYSIGNAL("valueChanged(int)"), (value,))
            
    def processWheel(self, event):
        if event.delta() < 0:
            self.decrement()
        else:
            self.increment()
