#include <iostream>
#include <vector>
#include <mpfrcpp/mpfrcpp.hpp>
#include <mpfrcpp/extra/complex.hpp>
#include <mpfrcpp/extra/polynomial.hpp>

int main () {

    size_t n = /*10, 21, 43, 87, ...*/ 43;

    mpfrcpp::Library.setPrecision(mpfrcpp::Precision(100));

    mpfrcpp::Polynomial<mpfrcpp::Real> P =
         mpfrcpp::LegendrePolynomial<mpfrcpp::Real> (n);
    std::cout << "P_" << n << " = " << P << std::endl << std::endl;

    std::vector<mpfrcpp::Complex> roots =
         PolynomialRoots(mpfrcpp::Polynomial<mpfrcpp::Complex>(P),
                         mpfrcpp::Real::epsilon(), 10000);

    for (size_t i = 0; i < roots.size(); i++)
        std::cout << "x_" << i << " = " << roots.at(i).real() << std::endl;

    return 0;
}
