# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
from . import CQueryHit

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode CMatchFile structure
# @see MatchObjects.cpp - CMatchFile::Serialize
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (decoder, version):
  f = dataholder ()
  f.hash_bth = None
  f.hash_md5 = None
  f.preview = None
  f.last_seen_time = None

  if version >= 10:
    f.size = decoder.get_qword ()
  else:
    f.size = decoder.get_dword ()

  f.str_size = decoder.get_string ()
  f.hash_sha1 = decoder.get_hex_string (20)
  f.hash_tiger = decoder.get_hex_string (24)
  f.hash_ed2k = decoder.get_hex_string (16)

  if version >= 13:
    f.hash_bth = decoder.get_hex_string (20)
    f.hash_md5 = decoder.get_hex_string (16)

  f.tri_busy = decoder.get_dword ()
  f.tri_push = decoder.get_dword ()
  f.tri_stable = decoder.get_dword ()
  f.speed = decoder.get_dword ()
  f.str_speed = decoder.get_string ()
  f.b_expanded = decoder.get_bool ()
  f.b_existing = decoder.get_bool ()
  f.b_download = decoder.get_bool ()
  f.b_one_valid = decoder.get_bool ()

  n_preview = decoder.get_count ()

  if n_preview > 0:
    f.preview = decoder.get_data (n_preview)

  total = decoder.get_count ()
  f.query_hits = []

  for i in range (total):
    query_hit = CQueryHit.decode (decoder, version)
    f.query_hits.append (query_hit)

  if version >= 14:
    f.last_seen_time = decoder.get_ctime ()

  return f
