#ifndef MOBIUS_IO_RESOURCE_IMPL_BASE_H
#define MOBIUS_IO_RESOURCE_IMPL_BASE_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <string>
#include <sys/types.h>
#include <mobius/datetime/datetime.h>

namespace mobius
{
namespace io
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief resource implementation base class
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class resource_impl_base
{
public:
  virtual ~resource_impl_base () = default;

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  // datatypes
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  using size_type = std::uint64_t;	//< file size in bytes
  using user_id_type = uid_t;		//< user ID
  using group_id_type = gid_t;		//< group ID
  using permission_type = mode_t;	//< access permission mask

  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  //! \brief abstract methods
  // =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  virtual std::string get_url () const = 0;
  virtual operator bool () const noexcept = 0;
  virtual bool exists () const = 0;
  virtual bool is_file () const = 0;
  virtual bool is_folder () const = 0;
  virtual size_type get_size () const = 0;
  virtual user_id_type get_user_id () const = 0;
  virtual std::string get_user_name () const = 0;
  virtual group_id_type get_group_id () const = 0;
  virtual std::string get_group_name () const = 0;
  virtual permission_type get_permissions () const = 0;
  virtual mobius::datetime::datetime get_last_access_time () const = 0;
  virtual mobius::datetime::datetime get_last_modification_time () const = 0;
  virtual mobius::datetime::datetime get_last_metadata_time () const = 0;
};

} // namespace io
} // namespace mobius

#endif
